/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.util.JavaCompatibility;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class FlatUIUtils {
    public static final boolean MAC_USE_QUARTZ = Boolean.getBoolean("apple.awt.graphics.UseQuartz");

    public static Rectangle addInsets(Rectangle r, Insets insets) {
        return new Rectangle(r.x - insets.left, r.y - insets.top, r.width + insets.left + insets.right, r.height + insets.top + insets.bottom);
    }

    public static Rectangle subtractInsets(Rectangle r, Insets insets) {
        return new Rectangle(r.x + insets.left, r.y + insets.top, r.width - insets.left - insets.right, r.height - insets.top - insets.bottom);
    }

    public static Color getUIColor(String key, int defaultColorRGB) {
        Color color = UIManager.getColor(key);
        return color != null ? color : new Color(defaultColorRGB);
    }

    public static Color getUIColor(String key, Color defaultColor) {
        Color color = UIManager.getColor(key);
        return color != null ? color : defaultColor;
    }

    public static int getUIInt(String key, int defaultValue) {
        Object value = UIManager.get(key);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    public static Color nonUIResource(Color c) {
        return c instanceof ColorUIResource ? new Color(c.getRGB(), true) : c;
    }

    public static void setRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MAC_USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
    }

    public static void drawRoundRectangle(Graphics2D g, int x, int y, int width, int height, float focusWidth, float lineWidth, float arc) {
        float arc2 = arc > lineWidth ? arc - lineWidth : 0.0f;
        RoundRectangle2D.Float r1 = new RoundRectangle2D.Float((float)x + focusWidth, (float)y + focusWidth, (float)width - focusWidth * 2.0f, (float)height - focusWidth * 2.0f, arc, arc);
        RoundRectangle2D.Float r2 = new RoundRectangle2D.Float(r1.x + lineWidth, r1.y + lineWidth, r1.width - lineWidth * 2.0f, r1.height - lineWidth * 2.0f, arc2, arc2);
        Path2D.Float border = new Path2D.Float(0);
        border.append(r1, false);
        border.append(r2, false);
        g.fill(border);
    }

    public static void fillRoundRectangle(Graphics2D g, int x, int y, int width, int height, float focusWidth, float arc) {
        g.fill(new RoundRectangle2D.Float((float)x + focusWidth, (float)y + focusWidth, (float)width - focusWidth * 2.0f, (float)height - focusWidth * 2.0f, arc, arc));
    }

    public static void paintParentBackground(Graphics g, JComponent c) {
        Container parent = FlatUIUtils.findOpaqueParent(c);
        if (parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    private static Container findOpaqueParent(Container c) {
        while ((c = c.getParent()) != null) {
            if (!c.isOpaque()) continue;
            return c;
        }
        return null;
    }

    public static void paintOutlineBorder(Graphics2D g, int x, int y, int width, int height, float focusWidth, float lineWidth, float arc) {
        float outerArc = arc > 0.0f ? arc + focusWidth - UIScale.scale(2.0f) : focusWidth;
        float ow = focusWidth + lineWidth;
        Path2D.Float path = new Path2D.Float(0);
        path.append(FlatUIUtils.createOutlinePath(x, y, width, height, outerArc), false);
        path.append(FlatUIUtils.createOutlinePath((float)x + ow, (float)y + ow, (float)width - ow * 2.0f, (float)height - ow * 2.0f, outerArc - ow), false);
        g.fill(path);
    }

    private static Shape createOutlinePath(float x, float y, float width, float height, float arc) {
        if (arc <= 0.0f) {
            return new Rectangle2D.Float(x, y, width, height);
        }
        float x2 = x + width;
        float y2 = y + height;
        Path2D.Float rect = new Path2D.Float();
        ((Path2D)rect).moveTo(x2 - arc, y);
        ((Path2D)rect).quadTo(x2, y, x2, y + arc);
        ((Path2D)rect).lineTo(x2, y2 - arc);
        ((Path2D)rect).quadTo(x2, y2, x2 - arc, y2);
        ((Path2D)rect).lineTo(x + arc, y2);
        ((Path2D)rect).quadTo(x, y2, x, y2 - arc);
        ((Path2D)rect).lineTo(x, y + arc);
        ((Path2D)rect).quadTo(x, y, x + arc, y);
        rect.closePath();
        return rect;
    }

    public static Path2D createPath(double ... points) {
        return FlatUIUtils.createPath(true, points);
    }

    public static Path2D createPath(boolean close, double ... points) {
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(points[0], points[1]);
        for (int i = 2; i < points.length; i += 2) {
            ((Path2D)path).lineTo(points[i], points[i + 1]);
        }
        if (close) {
            path.closePath();
        }
        return path;
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        JavaCompatibility.drawStringUnderlineCharAt(c, g, text, underlinedIndex, x, y);
    }

    public static class HoverListener
    extends MouseAdapter {
        private final JComponent repaintComponent;
        private final Consumer<Boolean> hoverChanged;

        public HoverListener(JComponent repaintComponent, Consumer<Boolean> hoverChanged) {
            this.repaintComponent = repaintComponent;
            this.hoverChanged = hoverChanged;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.hoverChanged.accept(true);
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.hoverChanged.accept(false);
            this.repaint();
        }

        private void repaint() {
            if (this.repaintComponent != null && this.repaintComponent.isEnabled()) {
                this.repaintComponent.repaint();
            }
        }
    }
}

