/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatRoundBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;

public class FlatComboBoxUI
extends BasicComboBoxUI {
    protected int focusWidth;
    protected int arc;
    protected String arrowType;
    protected Color borderColor;
    protected Color disabledBorderColor;
    protected Color disabledBackground;
    protected Color disabledForeground;
    protected Color buttonBackground;
    protected Color buttonEditableBackground;
    protected Color buttonArrowColor;
    protected Color buttonDisabledArrowColor;
    protected Color buttonHoverArrowColor;
    private MouseListener hoverListener;
    private boolean hover;

    public static ComponentUI createUI(JComponent c) {
        return new FlatComboBoxUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.hoverListener = new FlatUIUtils.HoverListener(null, h -> {
            if (!this.comboBox.isEditable()) {
                this.hover = h;
                if (this.arrowButton != null) {
                    this.arrowButton.repaint();
                }
            }
        });
        this.comboBox.addMouseListener(this.hoverListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.hoverListener);
        this.hoverListener = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.focusWidth = UIManager.getInt("Component.focusWidth");
        this.arc = UIManager.getInt("Component.arc");
        this.arrowType = UIManager.getString("Component.arrowType");
        this.borderColor = UIManager.getColor("Component.borderColor");
        this.disabledBorderColor = UIManager.getColor("Component.disabledBorderColor");
        this.disabledBackground = UIManager.getColor("ComboBox.disabledBackground");
        this.disabledForeground = UIManager.getColor("ComboBox.disabledForeground");
        this.buttonBackground = UIManager.getColor("ComboBox.buttonBackground");
        this.buttonEditableBackground = UIManager.getColor("ComboBox.buttonEditableBackground");
        this.buttonArrowColor = UIManager.getColor("ComboBox.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("ComboBox.buttonDisabledArrowColor");
        this.buttonHoverArrowColor = UIManager.getColor("ComboBox.buttonHoverArrowColor");
        this.padding = UIScale.scale(this.padding);
        MigLayoutVisualPadding.install((JComponent)this.comboBox, this.focusWidth);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.borderColor = null;
        this.disabledBorderColor = null;
        this.disabledBackground = null;
        this.disabledForeground = null;
        this.buttonBackground = null;
        this.buttonEditableBackground = null;
        this.buttonArrowColor = null;
        this.buttonDisabledArrowColor = null;
        this.buttonHoverArrowColor = null;
        MigLayoutVisualPadding.uninstall(this.comboBox);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                if (FlatComboBoxUI.this.editor != null && FlatComboBoxUI.this.padding != null) {
                    FlatComboBoxUI.this.editor.setBounds(FlatUIUtils.subtractInsets(FlatComboBoxUI.this.editor.getBounds(), FlatComboBoxUI.this.padding));
                }
            }
        };
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicComboBoxUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                if (FlatComboBoxUI.this.comboBox != null && FlatComboBoxUI.this.comboBox.isEditable()) {
                    FlatComboBoxUI.this.comboBox.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                if (FlatComboBoxUI.this.comboBox != null && FlatComboBoxUI.this.comboBox.isEditable()) {
                    FlatComboBoxUI.this.comboBox.repaint();
                }
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new BasicComboBoxUI.PropertyChangeHandler(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                super.propertyChange(e);
                Object source = e.getSource();
                String propertyName = e.getPropertyName();
                if (FlatComboBoxUI.this.editor != null && (source == FlatComboBoxUI.this.comboBox && (propertyName == "background" || propertyName == "foreground") || source == FlatComboBoxUI.this.editor && propertyName == "enabled")) {
                    FlatComboBoxUI.this.updateEditorColors();
                }
            }
        };
    }

    @Override
    protected ComboPopup createPopup() {
        return new FlatComboPopup(this.comboBox);
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (this.editor instanceof JTextComponent) {
            ((JTextComponent)this.editor).setBorder(BorderFactory.createEmptyBorder());
        }
        this.updateEditorColors();
    }

    private void updateEditorColors() {
        boolean enabled = this.editor.isEnabled();
        this.editor.setBackground(FlatUIUtils.nonUIResource(enabled ? this.comboBox.getBackground() : this.disabledBackground));
        this.editor.setForeground(FlatUIUtils.nonUIResource(enabled || this.editor instanceof JTextComponent ? this.comboBox.getForeground() : this.disabledForeground));
        if (this.editor instanceof JTextComponent) {
            ((JTextComponent)this.editor).setDisabledTextColor(FlatUIUtils.nonUIResource(this.disabledForeground));
        }
    }

    @Override
    protected JButton createArrowButton() {
        return new FlatArrowButton(5, this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, this.buttonHoverArrowColor, null){

            @Override
            protected boolean isHover() {
                return super.isHover() || !FlatComboBoxUI.this.comboBox.isEditable() && FlatComboBoxUI.this.hover;
            }
        };
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            FlatUIUtils.paintParentBackground(g, c);
            Graphics2D g2 = (Graphics2D)g;
            FlatUIUtils.setRenderingHints(g2);
            int width = c.getWidth();
            int height = c.getHeight();
            float focusWidth = c.getBorder() instanceof FlatBorder ? UIScale.scale((float)this.focusWidth) : 0.0f;
            float arc = c.getBorder() instanceof FlatRoundBorder ? UIScale.scale((float)this.arc) : 0.0f;
            int arrowX = this.arrowButton.getX();
            int arrowWidth = this.arrowButton.getWidth();
            boolean enabled = this.comboBox.isEnabled();
            boolean isLeftToRight = this.comboBox.getComponentOrientation().isLeftToRight();
            g2.setColor(enabled ? c.getBackground() : this.disabledBackground);
            FlatUIUtils.fillRoundRectangle(g2, 0, 0, width, height, focusWidth, arc);
            if (enabled) {
                g2.setColor(this.comboBox.isEditable() ? this.buttonEditableBackground : this.buttonBackground);
                Shape oldClip = g2.getClip();
                if (isLeftToRight) {
                    g2.clipRect(arrowX, 0, width - arrowX, height);
                } else {
                    g2.clipRect(0, 0, arrowX + arrowWidth, height);
                }
                FlatUIUtils.fillRoundRectangle(g2, 0, 0, width, height, focusWidth, arc);
                g2.setClip(oldClip);
            }
            if (this.comboBox.isEditable()) {
                g2.setColor(enabled ? this.borderColor : this.disabledBorderColor);
                float lw = UIScale.scale(1.0f);
                float lx = isLeftToRight ? (float)arrowX : (float)(arrowX + arrowWidth) - lw;
                g2.fill(new Rectangle2D.Float(lx, focusWidth, lw, (float)height - focusWidth * 2.0f));
            }
        }
        this.paint(g, c);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Insets rendererInsets;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        CellPaddingBorder.uninstall(renderer);
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        c.setFont(this.comboBox.getFont());
        CellPaddingBorder.uninstall(c);
        boolean enabled = this.comboBox.isEnabled();
        c.setForeground(enabled ? this.comboBox.getForeground() : this.disabledForeground);
        c.setBackground(enabled ? this.comboBox.getBackground() : this.disabledBackground);
        boolean shouldValidate = c instanceof JPanel;
        if (this.padding != null) {
            bounds = FlatUIUtils.subtractInsets(bounds, this.padding);
        }
        if ((rendererInsets = this.getRendererComponentInsets(c)) != null) {
            bounds = FlatUIUtils.addInsets(bounds, rendererInsets);
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        g.setColor(this.comboBox.isEnabled() ? this.comboBox.getBackground() : this.disabledBackground);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    protected Dimension getSizeForComponent(Component comp) {
        Dimension size = super.getSizeForComponent(comp);
        Insets rendererInsets = this.getRendererComponentInsets(comp);
        if (rendererInsets != null) {
            size = new Dimension(size.width, size.height - rendererInsets.top - rendererInsets.bottom);
        }
        return size;
    }

    private Insets getRendererComponentInsets(Component rendererComponent) {
        Border rendererBorder;
        if (rendererComponent instanceof JComponent && (rendererBorder = ((JComponent)rendererComponent).getBorder()) != null) {
            return rendererBorder.getBorderInsets(rendererComponent);
        }
        return null;
    }

    private static class CellPaddingBorder
    extends AbstractBorder {
        private final Insets padding;
        private Border rendererBorder;

        CellPaddingBorder(Insets padding) {
            this.padding = padding;
        }

        void install(JComponent rendererComponent) {
            Border oldBorder = rendererComponent.getBorder();
            if (!(oldBorder instanceof CellPaddingBorder)) {
                this.rendererBorder = oldBorder;
                rendererComponent.setBorder(this);
            }
        }

        static void uninstall(Object o) {
            if (!(o instanceof JComponent)) {
                return;
            }
            JComponent rendererComponent = (JComponent)o;
            Border border = rendererComponent.getBorder();
            if (border instanceof CellPaddingBorder) {
                CellPaddingBorder paddingBorder = (CellPaddingBorder)border;
                rendererComponent.setBorder(paddingBorder.rendererBorder);
                paddingBorder.rendererBorder = null;
            }
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (this.rendererBorder != null) {
                Insets insideInsets = this.rendererBorder.getBorderInsets(c);
                insets.top = Math.max(this.padding.top, insideInsets.top);
                insets.left = Math.max(this.padding.left, insideInsets.left);
                insets.bottom = Math.max(this.padding.bottom, insideInsets.bottom);
                insets.right = Math.max(this.padding.right, insideInsets.right);
            } else {
                insets.top = this.padding.top;
                insets.left = this.padding.left;
                insets.bottom = this.padding.bottom;
                insets.right = this.padding.right;
            }
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.rendererBorder != null) {
                this.rendererBorder.paintBorder(c, g, x, y, width, height);
            }
        }
    }

    private class FlatComboPopup
    extends BasicComboPopup {
        private CellPaddingBorder paddingBorder;

        FlatComboPopup(JComboBox combo) {
            super(combo);
        }

        @Override
        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            Object prototype = this.comboBox.getPrototypeDisplayValue();
            if (prototype != null) {
                this.comboBox.setPrototypeDisplayValue(null);
            }
            Dimension displaySize = FlatComboBoxUI.this.getDisplaySize();
            if (prototype != null) {
                this.comboBox.setPrototypeDisplayValue(prototype);
            }
            pw = Math.max(pw, displaySize.width);
            return super.computePopupBounds(px, py, pw, ph);
        }

        @Override
        protected void configurePopup() {
            super.configurePopup();
            Border border = UIManager.getBorder("PopupMenu.border");
            if (border != null) {
                this.setBorder(border);
            }
        }

        @Override
        protected void configureList() {
            super.configureList();
            this.list.setCellRenderer(new PopupListCellRenderer());
        }

        @Override
        protected PropertyChangeListener createPropertyChangeListener() {
            return new BasicComboPopup.PropertyChangeHandler(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    super.propertyChange(e);
                    if (e.getPropertyName() == "renderer") {
                        FlatComboPopup.this.list.setCellRenderer(new PopupListCellRenderer());
                    }
                }
            };
        }

        private class PopupListCellRenderer
        implements ListCellRenderer {
            private PopupListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ListCellRenderer<Object> renderer = FlatComboPopup.this.comboBox.getRenderer();
                CellPaddingBorder.uninstall(renderer);
                Component c = renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (c instanceof JComponent) {
                    if (FlatComboPopup.this.paddingBorder == null) {
                        FlatComboPopup.this.paddingBorder = new CellPaddingBorder(FlatComboBoxUI.this.padding);
                    }
                    FlatComboPopup.this.paddingBorder.install((JComponent)c);
                }
                return c;
            }
        }
    }
}

