/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class FlatScrollPaneUI
extends BasicScrollPaneUI {
    private Handler handler;

    public static ComponentUI createUI(JComponent c) {
        return new FlatScrollPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (this.scrollpane.getLayout() instanceof UIResource) {
            this.scrollpane.setLayout(new FlatScrollPaneLayout());
        }
        MigLayoutVisualPadding.install((JComponent)this.scrollpane, UIManager.getInt("Component.focusWidth"));
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.scrollpane.getLayout() instanceof FlatScrollPaneLayout) {
            this.scrollpane.setLayout(new ScrollPaneLayout.UIResource());
        }
        MigLayoutVisualPadding.uninstall(this.scrollpane);
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners(JScrollPane c) {
        super.installListeners(c);
        this.addViewportListeners(this.scrollpane.getViewport());
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        super.uninstallListeners(c);
        this.removeViewportListeners(this.scrollpane.getViewport());
        this.handler = null;
    }

    public Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    @Override
    protected void updateViewport(PropertyChangeEvent e) {
        super.updateViewport(e);
        JViewport oldViewport = (JViewport)e.getOldValue();
        JViewport newViewport = (JViewport)e.getNewValue();
        this.removeViewportListeners(oldViewport);
        this.addViewportListeners(newViewport);
    }

    private void addViewportListeners(JViewport viewport) {
        if (viewport == null) {
            return;
        }
        viewport.addContainerListener(this.getHandler());
        Component view = viewport.getView();
        if (view != null) {
            view.addFocusListener(this.getHandler());
        }
    }

    private void removeViewportListeners(JViewport viewport) {
        if (viewport == null) {
            return;
        }
        viewport.removeContainerListener(this.getHandler());
        Component view = viewport.getView();
        if (view != null) {
            view.removeFocusListener(this.getHandler());
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            FlatUIUtils.paintParentBackground(g, c);
            Insets insets = c.getInsets();
            g.setColor(c.getBackground());
            g.fillRect(insets.left, insets.top, c.getWidth() - insets.left - insets.right, c.getHeight() - insets.top - insets.bottom);
        }
        this.paint(g, c);
    }

    private static class FlatScrollPaneLayout
    extends ScrollPaneLayout {
        private FlatScrollPaneLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            if (this.colHead != null && this.vsb != null && this.colHead.isVisible() && this.vsb.isVisible()) {
                Rectangle colHeadBounds = this.colHead.getBounds();
                Rectangle vsbBounds = this.vsb.getBounds();
                if (vsbBounds.y > colHeadBounds.y) {
                    vsbBounds.height += vsbBounds.y - colHeadBounds.y;
                    vsbBounds.y = colHeadBounds.y;
                    this.vsb.setBounds(vsbBounds);
                }
            }
        }
    }

    private class Handler
    implements ContainerListener,
    FocusListener {
        private Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            e.getChild().addFocusListener(this);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            e.getChild().removeFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent e) {
            FlatScrollPaneUI.this.scrollpane.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            FlatScrollPaneUI.this.scrollpane.repaint();
        }
    }
}

