/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class FlatTabbedPaneUI
extends BasicTabbedPaneUI {
    protected Color disabledForeground;
    protected Color selectedForeground;
    protected Color underlineColor;
    protected Color disabledUnderlineColor;
    protected Color hoverColor;
    protected Color focusColor;
    protected Color contentAreaColor;
    protected int tabHeight;
    protected int tabSelectionHeight;
    protected int contentSeparatorHeight;
    protected boolean hasFullBorder;
    protected boolean tabsOverlapBorder;

    public static ComponentUI createUI(JComponent c) {
        return new FlatTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.disabledForeground = UIManager.getColor("TabbedPane.disabledForeground");
        this.selectedForeground = UIManager.getColor("TabbedPane.selectedForeground");
        this.underlineColor = UIManager.getColor("TabbedPane.underlineColor");
        this.disabledUnderlineColor = UIManager.getColor("TabbedPane.disabledUnderlineColor");
        this.hoverColor = UIManager.getColor("TabbedPane.hoverColor");
        this.focusColor = UIManager.getColor("TabbedPane.focusColor");
        this.contentAreaColor = UIManager.getColor("TabbedPane.contentAreaColor");
        this.tabHeight = UIManager.getInt("TabbedPane.tabHeight");
        this.tabSelectionHeight = UIManager.getInt("TabbedPane.tabSelectionHeight");
        this.contentSeparatorHeight = UIManager.getInt("TabbedPane.contentSeparatorHeight");
        this.hasFullBorder = UIManager.getBoolean("TabbedPane.hasFullBorder");
        this.tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        this.textIconGap = UIScale.scale(this.textIconGap);
        this.tabInsets = UIScale.scale(this.tabInsets);
        this.selectedTabPadInsets = UIScale.scale(this.selectedTabPadInsets);
        this.tabAreaInsets = UIScale.scale(this.tabAreaInsets);
        this.tabHeight = UIScale.scale(this.tabHeight);
        this.tabSelectionHeight = UIScale.scale(this.tabSelectionHeight);
        this.contentSeparatorHeight = UIScale.scale(this.contentSeparatorHeight);
        MigLayoutVisualPadding.install((JComponent)this.tabPane, null);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.disabledForeground = null;
        this.selectedForeground = null;
        this.underlineColor = null;
        this.disabledUnderlineColor = null;
        this.hoverColor = null;
        this.focusColor = null;
        this.contentAreaColor = null;
        MigLayoutVisualPadding.uninstall(this.tabPane);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new BasicTabbedPaneUI.PropertyChangeHandler(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                super.propertyChange(e);
                if ("JTabbedPane.hasFullBorder".equals(e.getPropertyName())) {
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    FlatTabbedPaneUI.this.tabPane.repaint();
                }
            }
        };
    }

    @Override
    protected JButton createScrollButton(int direction) {
        return new FlatArrowButton(direction, UIManager.getString("Component.arrowType"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.disabledForeground"), null, UIManager.getColor("TabbedPane.hoverColor"));
    }

    @Override
    protected void setRolloverTab(int index) {
        int oldIndex = this.getRolloverTab();
        super.setRolloverTab(index);
        if (index == oldIndex) {
            return;
        }
        this.repaintTab(oldIndex);
        this.repaintTab(index);
    }

    private void repaintTab(int tabIndex) {
        if (tabIndex < 0 || tabIndex >= this.tabPane.getTabCount()) {
            return;
        }
        Rectangle r = this.getTabBounds(this.tabPane, tabIndex);
        if (r != null) {
            this.tabPane.repaint(r);
        }
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) - 3 + (!this.isTopOrBottom(tabPlacement) && this.isScrollTabLayout() ? this.contentSeparatorHeight : 0);
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return Math.max(this.tabHeight, super.calculateTabHeight(tabPlacement, tabIndex, fontHeight) - 2) + (this.isTopOrBottom(tabPlacement) && this.isScrollTabLayout() ? this.contentSeparatorHeight : 0);
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets insets;
        boolean hasFullBorder = this.hasFullBorder || this.tabPane.getClientProperty("JTabbedPane.hasFullBorder") == Boolean.TRUE;
        int sh = this.contentSeparatorHeight;
        Insets insets2 = insets = hasFullBorder ? new Insets(sh, sh, sh, sh) : new Insets(sh, 0, 0, 0);
        if (this.isScrollTabLayout()) {
            insets.top = 0;
        }
        FlatTabbedPaneUI.rotateInsets(insets, this.contentBorderInsets, tabPlacement);
        return this.contentBorderInsets;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        if (this.isScrollTabLayout() && !this.isTopOrBottom(tabPlacement)) {
            float shift = (float)this.contentSeparatorHeight / 2.0f;
            return Math.round(tabPlacement == 2 ? -shift : shift);
        }
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        if (this.isScrollTabLayout() && this.isTopOrBottom(tabPlacement)) {
            float shift = (float)this.contentSeparatorHeight / 2.0f;
            return Math.round(tabPlacement == 1 ? -shift : shift);
        }
        return 0;
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.isScrollTabLayout()) {
            Rectangle bounds = g.getClipBounds();
            g.setColor(this.contentAreaColor);
            if (tabPlacement == 1 || tabPlacement == 3) {
                int y = tabPlacement == 1 ? bounds.y + bounds.height - this.contentSeparatorHeight : bounds.y;
                g.fillRect(bounds.x, y, bounds.x + bounds.width, this.contentSeparatorHeight);
            } else {
                int x = tabPlacement == 2 ? bounds.x + bounds.width - this.contentSeparatorHeight : bounds.x;
                g.fillRect(x, bounds.y, this.contentSeparatorHeight, bounds.y + bounds.height);
            }
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Color color;
        g.setFont(font);
        View view = this.getTextViewForTab(tabIndex);
        if (view != null) {
            view.paint(g, textRect);
            return;
        }
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            color = this.tabPane.getForegroundAt(tabIndex);
            if (isSelected && color instanceof UIResource && this.selectedForeground != null) {
                color = this.selectedForeground;
            }
        } else {
            color = this.disabledForeground;
        }
        int mnemIndex = FlatLaf.isShowMnemonics() ? this.tabPane.getDisplayedMnemonicIndexAt(tabIndex) : -1;
        g.setColor(color);
        FlatUIUtils.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean enabled;
        if (this.isScrollTabLayout()) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                if (tabPlacement == 3) {
                    y += this.contentSeparatorHeight;
                }
                h -= this.contentSeparatorHeight;
            } else {
                if (tabPlacement == 4) {
                    x += this.contentSeparatorHeight;
                }
                w -= this.contentSeparatorHeight;
            }
        }
        g.setColor((enabled = this.tabPane.isEnabled()) && this.tabPane.isEnabledAt(tabIndex) && this.getRolloverTab() == tabIndex ? this.hoverColor : (enabled && isSelected && this.tabPane.hasFocus() ? this.focusColor : this.tabPane.getBackgroundAt(tabIndex)));
        g.fillRect(x, y, w, h);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (!isSelected) {
            return;
        }
        g.setColor(this.tabPane.isEnabled() ? this.underlineColor : this.disabledUnderlineColor);
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        switch (tabPlacement) {
            default: {
                int sy = y + h + contentInsets.top - this.tabSelectionHeight;
                g.fillRect(x, sy, w, this.tabSelectionHeight);
                break;
            }
            case 3: {
                g.fillRect(x, y - contentInsets.bottom, w, this.tabSelectionHeight);
                break;
            }
            case 2: {
                int sx = x + w + contentInsets.left - this.tabSelectionHeight;
                g.fillRect(sx, y, this.tabSelectionHeight, h);
                break;
            }
            case 4: {
                g.fillRect(x - contentInsets.right, y, this.tabSelectionHeight, h);
            }
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.tabPane.getTabCount() <= 0) {
            return;
        }
        Insets insets = this.tabPane.getInsets();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = this.tabPane.getWidth() - insets.right - insets.left;
        int h = this.tabPane.getHeight() - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (this.tabsOverlapBorder) {
                    x -= tabAreaInsets.right;
                }
                w -= x - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (!this.tabsOverlapBorder) break;
                w += tabAreaInsets.left;
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (!this.tabsOverlapBorder) break;
                h += tabAreaInsets.top;
                break;
            }
            default: {
                y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (this.tabsOverlapBorder) {
                    y -= tabAreaInsets.bottom;
                }
                h -= y - insets.top;
            }
        }
        g.setColor(this.contentAreaColor);
        g.fillRect(x, y, w, h);
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    private boolean isScrollTabLayout() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    private boolean isTopOrBottom(int tabPlacement) {
        return tabPlacement == 1 || tabPlacement == 3;
    }
}

