/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatDefaultsAddon;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.util.ColorFunctions;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.ScaledNumber;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;

class UIDefaultsLoader {
    private static final String TYPE_PREFIX = "{";
    private static final String TYPE_PREFIX_END = "}";
    private static final String VARIABLE_PREFIX = "@";
    private static final String REF_PREFIX = "@@";
    private static final String OPTIONAL_PREFIX = "?";
    private static final String GLOBAL_PREFIX = "*.";

    UIDefaultsLoader() {
    }

    static void loadDefaultsFromProperties(Class<?> lookAndFeelClass, UIDefaults defaults) {
        ArrayList lafClasses = new ArrayList();
        Class<?> lafClass = lookAndFeelClass;
        while (FlatLaf.class.isAssignableFrom(lafClass)) {
            lafClasses.add(0, lafClass);
            lafClass = lafClass.getSuperclass();
        }
        try {
            String key;
            Properties properties = new Properties();
            ServiceLoader<FlatDefaultsAddon> addonLoader = ServiceLoader.load(FlatDefaultsAddon.class);
            for (Class clazz : lafClasses) {
                String propertiesName = "/" + clazz.getName().replace('.', '/') + ".properties";
                try (InputStream in = clazz.getResourceAsStream(propertiesName);){
                    if (in != null) {
                        properties.load(in);
                    }
                }
                for (FlatDefaultsAddon addon : addonLoader) {
                    InputStream in = addon.getDefaults(clazz);
                    try {
                        if (in == null) continue;
                        properties.load(in);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
            }
            Function<String, String> resolver = value -> UIDefaultsLoader.resolveValue(properties, value);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                key = (String)e.getKey();
                if (!key.startsWith(GLOBAL_PREFIX)) continue;
                String value2 = UIDefaultsLoader.resolveValue(properties, (String)e.getValue());
                try {
                    hashMap.put(key.substring(GLOBAL_PREFIX.length()), UIDefaultsLoader.parseValue(key, value2, resolver));
                }
                catch (RuntimeException ex) {
                    UIDefaultsLoader.logParseError(key, value2, ex);
                }
            }
            for (Map.Entry<Object, Object> key2 : defaults.keySet()) {
                String skey;
                String globalKey;
                Object globalValue;
                if (!(key2 instanceof String) || !((String)((Object)key2)).contains(".") || (globalValue = hashMap.get(globalKey = (skey = (String)((Object)key2)).substring(skey.lastIndexOf(46) + 1))) == null) continue;
                defaults.put(key2, globalValue);
            }
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                key = (String)e.getKey();
                if (key.startsWith(VARIABLE_PREFIX) || key.startsWith(GLOBAL_PREFIX)) continue;
                String value2 = UIDefaultsLoader.resolveValue(properties, (String)e.getValue());
                try {
                    defaults.put(key, UIDefaultsLoader.parseValue(key, value2, resolver));
                }
                catch (RuntimeException ex) {
                    UIDefaultsLoader.logParseError(key, value2, ex);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void logParseError(String key, String value, RuntimeException ex) {
        System.err.println("Failed to parse: '" + key + '=' + value + '\'');
        System.err.println("    " + ex.getMessage());
    }

    private static String resolveValue(Properties properties, String value) {
        String newValue;
        if (!value.startsWith(VARIABLE_PREFIX)) {
            return value;
        }
        if (value.startsWith(REF_PREFIX)) {
            value = value.substring(REF_PREFIX.length());
        }
        boolean optional = false;
        if (value.startsWith(OPTIONAL_PREFIX)) {
            value = value.substring(OPTIONAL_PREFIX.length());
            optional = true;
        }
        if ((newValue = properties.getProperty(value)) == null) {
            if (optional) {
                return "null";
            }
            throw new IllegalArgumentException("variable or reference '" + value + "' not found");
        }
        return UIDefaultsLoader.resolveValue(properties, newValue);
    }

    private static Object parseValue(String key, String value, Function<String, String> resolver) {
        int end;
        switch (value = value.trim()) {
            case "null": {
                return null;
            }
            case "false": {
                return false;
            }
            case "true": {
                return true;
            }
        }
        ValueType valueType = ValueType.UNKNOWN;
        if (value.startsWith(TYPE_PREFIX) && (end = value.indexOf(TYPE_PREFIX_END)) != -1) {
            try {
                String typeStr = value.substring(TYPE_PREFIX.length(), end);
                valueType = ValueType.valueOf(typeStr.toUpperCase(Locale.ENGLISH));
                value = value.substring(end + TYPE_PREFIX_END.length());
            }
            catch (IllegalArgumentException typeStr) {
                // empty catch block
            }
        }
        if (valueType == ValueType.UNKNOWN) {
            if (key.endsWith(".border") || key.endsWith("Border")) {
                valueType = ValueType.BORDER;
            } else if (key.endsWith(".icon") || key.endsWith("Icon")) {
                valueType = ValueType.ICON;
            } else if (key.endsWith(".margin") || key.endsWith(".padding") || key.endsWith("Margins") || key.endsWith("Insets")) {
                valueType = ValueType.INSETS;
            } else if (key.endsWith("Size")) {
                valueType = ValueType.SIZE;
            } else if (key.endsWith("Width") || key.endsWith("Height")) {
                valueType = ValueType.INTEGER;
            }
        }
        switch (valueType) {
            case STRING: {
                return value;
            }
            case INTEGER: {
                return UIDefaultsLoader.parseInteger(value, true);
            }
            case BORDER: {
                return UIDefaultsLoader.parseBorder(value, resolver);
            }
            case ICON: {
                return UIDefaultsLoader.parseInstance(value);
            }
            case INSETS: {
                return UIDefaultsLoader.parseInsets(value);
            }
            case SIZE: {
                return UIDefaultsLoader.parseSize(value);
            }
            case COLOR: {
                return UIDefaultsLoader.parseColor(value, true);
            }
            case SCALEDNUMBER: {
                return UIDefaultsLoader.parseScaledNumber(value);
            }
        }
        ColorUIResource color = UIDefaultsLoader.parseColor(value, false);
        if (color != null) {
            return color;
        }
        Integer integer = UIDefaultsLoader.parseInteger(value, false);
        if (integer != null) {
            return integer;
        }
        return value;
    }

    private static Object parseBorder(String value, Function<String, String> resolver) {
        if (value.indexOf(44) >= 0) {
            List<String> parts = UIDefaultsLoader.split(value, ',');
            Insets insets = UIDefaultsLoader.parseInsets(value);
            ColorUIResource lineColor = parts.size() == 5 ? UIDefaultsLoader.parseColor(resolver.apply(parts.get(4)), true) : null;
            return t -> lineColor != null ? new FlatLineBorder(insets, lineColor) : new FlatEmptyBorder(insets);
        }
        return UIDefaultsLoader.parseInstance(value);
    }

    private static Object parseInstance(String value) {
        return t -> {
            try {
                return Class.forName(value).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
        };
    }

    private static Insets parseInsets(String value) {
        List<String> numbers = UIDefaultsLoader.split(value, ',');
        try {
            return new InsetsUIResource(Integer.parseInt(numbers.get(0)), Integer.parseInt(numbers.get(1)), Integer.parseInt(numbers.get(2)), Integer.parseInt(numbers.get(3)));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("invalid insets '" + value + "'");
        }
    }

    private static Dimension parseSize(String value) {
        List<String> numbers = UIDefaultsLoader.split(value, ',');
        try {
            return new DimensionUIResource(Integer.parseInt(numbers.get(0)), Integer.parseInt(numbers.get(1)));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("invalid size '" + value + "'");
        }
    }

    private static ColorUIResource parseColor(String value, boolean reportError) {
        block6: {
            if (value.endsWith(")")) {
                return UIDefaultsLoader.parseColorFunctions(value, reportError);
            }
            try {
                int rgb = Integer.parseInt(value, 16);
                if (value.length() == 6) {
                    return new ColorUIResource(rgb);
                }
                if (value.length() == 8) {
                    return new ColorUIResource(new Color(rgb, true));
                }
                if (reportError) {
                    throw new NumberFormatException(value);
                }
            }
            catch (NumberFormatException ex) {
                if (!reportError) break block6;
                throw new IllegalArgumentException("invalid color '" + value + "'");
            }
        }
        return null;
    }

    private static ColorUIResource parseColorFunctions(String value, boolean reportError) {
        int paramsStart = value.indexOf(40);
        if (paramsStart < 0) {
            if (reportError) {
                throw new IllegalArgumentException("missing opening parenthesis in function '" + value + "'");
            }
            return null;
        }
        String function = value.substring(0, paramsStart).trim();
        List<String> params = UIDefaultsLoader.split(value.substring(paramsStart + 1, value.length() - 1), ',');
        if (params.isEmpty()) {
            throw new IllegalArgumentException("missing parameters in function '" + value + "'");
        }
        switch (function) {
            case "lighten": {
                return UIDefaultsLoader.parseColorLightenOrDarken(true, params, reportError);
            }
            case "darken": {
                return UIDefaultsLoader.parseColorLightenOrDarken(false, params, reportError);
            }
        }
        throw new IllegalArgumentException("unknown color function '" + value + "'");
    }

    private static ColorUIResource parseColorLightenOrDarken(boolean lighten, List<String> params, boolean reportError) {
        int amount = UIDefaultsLoader.parsePercentage(params.get(0));
        boolean relative = false;
        boolean autoInverse = false;
        if (params.size() >= 2) {
            String options = params.get(1);
            relative = options.contains("relative");
            autoInverse = options.contains("autoInverse");
        }
        return new DerivedColor(lighten ? new ColorFunctions.Lighten(amount, relative, autoInverse) : new ColorFunctions.Darken(amount, relative, autoInverse));
    }

    private static int parsePercentage(String value) {
        int val;
        if (!value.endsWith("%")) {
            throw new NumberFormatException("invalid percentage '" + value + "'");
        }
        try {
            val = Integer.parseInt(value.substring(0, value.length() - 1));
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("invalid percentage '" + value + "'");
        }
        if (val < 0 || val > 100) {
            throw new IllegalArgumentException("percentage out of range (0-100%) '" + value + "'");
        }
        return val;
    }

    private static Integer parseInteger(String value, boolean reportError) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            if (reportError) {
                throw new NumberFormatException("invalid integer '" + value + "'");
            }
            return null;
        }
    }

    private static ScaledNumber parseScaledNumber(String value) {
        try {
            return new ScaledNumber(Integer.parseInt(value));
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("invalid integer '" + value + "'");
        }
    }

    static List<String> split(String str, char delim) {
        ArrayList<String> strs = new ArrayList<String>();
        int delimIndex = str.indexOf(delim);
        int index = 0;
        while (delimIndex >= 0) {
            strs.add(str.substring(index, delimIndex));
            index = delimIndex + 1;
            delimIndex = str.indexOf(delim, index);
        }
        strs.add(str.substring(index));
        return strs;
    }

    private static enum ValueType {
        UNKNOWN,
        STRING,
        INTEGER,
        BORDER,
        ICON,
        INSETS,
        SIZE,
        COLOR,
        SCALEDNUMBER;

    }
}

