/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class FlatToolTipUI
extends BasicToolTipUI {
    private static ComponentUI instance;

    public static ComponentUI createUI(JComponent c) {
        if (instance == null) {
            instance = new FlatToolTipUI();
        }
        return instance;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.isMultiLine(c)) {
            FontMetrics fm = c.getFontMetrics(c.getFont());
            Insets insets = c.getInsets();
            List<String> lines = FlatLaf.split(((JToolTip)c).getTipText(), '\n');
            int width = 0;
            int height = fm.getHeight() * Math.max(lines.size(), 1);
            for (String line : lines) {
                width = Math.max(width, SwingUtilities.computeStringWidth(fm, line));
            }
            return new Dimension(insets.left + width + insets.right, insets.top + height + insets.bottom);
        }
        return super.getPreferredSize(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.isMultiLine(c)) {
            FontMetrics fm = c.getFontMetrics(c.getFont());
            Insets insets = c.getInsets();
            FlatUIUtils.setRenderingHints((Graphics2D)g);
            g.setColor(c.getForeground());
            List<String> lines = FlatLaf.split(((JToolTip)c).getTipText(), '\n');
            int x = insets.left;
            int x2 = c.getWidth() - insets.right;
            int y = insets.top - fm.getDescent();
            int lineHeight = fm.getHeight();
            JComponent comp = ((JToolTip)c).getComponent();
            boolean leftToRight = (comp != null ? comp : c).getComponentOrientation().isLeftToRight();
            for (String line : lines) {
                g.drawString(line, leftToRight ? x : x2 - SwingUtilities.computeStringWidth(fm, line), y += lineHeight);
            }
        } else {
            super.paint(g, c);
        }
    }

    private boolean isMultiLine(JComponent c) {
        String text = ((JToolTip)c).getTipText();
        return c.getClientProperty("html") == null && text != null && text.indexOf(10) >= 0;
    }
}

