/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class FlatProgressBarUI
extends BasicProgressBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new FlatProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.progressBar, "opaque", false);
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        return UIScale.scale(super.getPreferredInnerHorizontal());
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        return UIScale.scale(super.getPreferredInnerVertical());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            FlatUIUtils.paintParentBackground(g, c);
        }
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Insets insets = this.progressBar.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.progressBar.getWidth() - (insets.right + insets.left);
        int height = this.progressBar.getHeight() - (insets.top + insets.bottom);
        if (width <= 0 || height <= 0) {
            return;
        }
        boolean horizontal = this.progressBar.getOrientation() == 0;
        int arc = horizontal ? height : width;
        FlatUIUtils.setRenderingHints((Graphics2D)g);
        g.setColor(this.progressBar.getBackground());
        ((Graphics2D)g).fill(new RoundRectangle2D.Float(x, y, width, height, arc, arc));
        if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                g.setColor(this.progressBar.getForeground());
                ((Graphics2D)g).fill(new RoundRectangle2D.Float(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height, arc, arc));
            }
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, x, y, width, height, 0, insets);
            }
        } else {
            int amountFull = this.getAmountFull(insets, width, height);
            g.setColor(this.progressBar.getForeground());
            ((Graphics2D)g).fill(horizontal ? new RoundRectangle2D.Float(c.getComponentOrientation().isLeftToRight() ? (float)x : (float)(x + (width - amountFull)), y, amountFull, height, arc, arc) : new RoundRectangle2D.Float(x, y + (height - amountFull), width, amountFull, arc, arc));
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, x, y, width, height, amountFull, insets);
            }
        }
    }
}

