/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class FlatScrollBarUI
extends BasicScrollBarUI {
    protected Color hoverTrackColor;
    protected Color hoverThumbColor;
    private MouseAdapter hoverListener;
    private boolean hoverTrack;
    private boolean hoverThumb;
    private static boolean isPressed;

    public static ComponentUI createUI(JComponent c) {
        return new FlatScrollBarUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.hoverListener = new ScrollBarHoverListener();
        this.scrollbar.addMouseListener(this.hoverListener);
        this.scrollbar.addMouseMotionListener(this.hoverListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removeMouseListener(this.hoverListener);
        this.scrollbar.removeMouseMotionListener(this.hoverListener);
        this.hoverListener = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.hoverTrackColor = UIManager.getColor("ScrollBar.hoverTrackColor");
        this.hoverThumbColor = UIManager.getColor("ScrollBar.hoverThumbColor");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.hoverTrackColor = null;
        this.hoverThumbColor = null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return UIScale.scale(super.getPreferredSize(c));
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return this.createInvisibleButton();
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return this.createInvisibleButton();
    }

    private JButton createInvisibleButton() {
        JButton button = new JButton();
        button.setMinimumSize(new Dimension());
        button.setMaximumSize(new Dimension());
        button.setPreferredSize(new Dimension());
        button.setFocusable(false);
        button.setRequestFocusEnabled(false);
        return button;
    }

    @Override
    protected void paintDecreaseHighlight(Graphics g) {
    }

    @Override
    protected void paintIncreaseHighlight(Graphics g) {
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(this.hoverTrack ? this.hoverTrackColor : this.trackColor);
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        g.setColor(this.hoverThumb ? this.hoverThumbColor : this.thumbColor);
        g.fillRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return UIScale.scale(super.getMinimumThumbSize());
    }

    @Override
    protected Dimension getMaximumThumbSize() {
        return UIScale.scale(super.getMaximumThumbSize());
    }

    private class ScrollBarHoverListener
    extends MouseAdapter {
        private ScrollBarHoverListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!isPressed) {
                FlatScrollBarUI.this.hoverTrack = (FlatScrollBarUI.this.hoverThumb = false);
                this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!isPressed) {
                this.update(e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            isPressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            isPressed = false;
            this.update(e.getX(), e.getY());
        }

        private void update(int x, int y) {
            boolean inTrack = FlatScrollBarUI.this.getTrackBounds().contains(x, y);
            boolean inThumb = FlatScrollBarUI.this.getThumbBounds().contains(x, y);
            if (inTrack != FlatScrollBarUI.this.hoverTrack || inThumb != FlatScrollBarUI.this.hoverThumb) {
                FlatScrollBarUI.this.hoverTrack = inTrack;
                FlatScrollBarUI.this.hoverThumb = inThumb;
                this.repaint();
            }
        }

        private void repaint() {
            if (FlatScrollBarUI.this.scrollbar.isEnabled()) {
                FlatScrollBarUI.this.scrollbar.repaint();
            }
        }
    }
}

