/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatButtonUI;
import java.awt.Color;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class FlatToggleButtonUI
extends FlatButtonUI {
    protected Color selectedBackground;
    protected Color selectedForeground;
    protected Color disabledSelectedBackground;
    protected Color toolbarSelectedBackground;
    private boolean defaults_initialized = false;
    private static ComponentUI instance;

    public static ComponentUI createUI(JComponent c) {
        if (instance == null) {
            instance = new FlatToggleButtonUI();
        }
        return instance;
    }

    @Override
    protected String getPropertyPrefix() {
        return "ToggleButton.";
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.selectedBackground = UIManager.getColor("ToggleButton.selectedBackground");
            this.selectedForeground = UIManager.getColor("ToggleButton.selectedForeground");
            this.disabledSelectedBackground = UIManager.getColor("ToggleButton.disabledSelectedBackground");
            this.toolbarSelectedBackground = UIManager.getColor("ToggleButton.toolbar.selectedBackground");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    @Override
    protected Color getBackground(JComponent c) {
        ButtonModel model = ((AbstractButton)c).getModel();
        if (model.isSelected()) {
            boolean toolBarButton = FlatToggleButtonUI.isToolBarButton(c);
            return FlatToggleButtonUI.buttonStateColor(c, toolBarButton ? this.toolbarSelectedBackground : this.selectedBackground, toolBarButton ? this.toolbarSelectedBackground : this.disabledSelectedBackground, null, null, toolBarButton ? this.toolbarPressedBackground : this.pressedBackground);
        }
        return super.getBackground(c);
    }

    @Override
    protected Color getForeground(JComponent c) {
        ButtonModel model = ((AbstractButton)c).getModel();
        if (model.isSelected() && !FlatToggleButtonUI.isToolBarButton(c)) {
            return this.selectedForeground;
        }
        return super.getForeground(c);
    }
}

