/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class FlatButtonBorder
extends FlatBorder {
    protected final Color borderColor = UIManager.getColor("Button.borderColor");
    protected final Color disabledBorderColor = UIManager.getColor("Button.disabledBorderColor");
    protected final Color focusedBorderColor = UIManager.getColor("Button.focusedBorderColor");
    protected final Color hoverBorderColor = UIManager.getColor("Button.hoverBorderColor");
    protected final Color defaultBorderColor = UIManager.getColor("Button.default.borderColor");
    protected final Color defaultHoverBorderColor = UIManager.getColor("Button.default.hoverBorderColor");
    protected final Color defaultFocusedBorderColor = UIManager.getColor("Button.default.focusedBorderColor");
    protected final Color defaultFocusColor = UIManager.getColor("Button.default.focusColor");
    protected final int defaultBorderWidth = UIManager.getInt("Button.default.borderWidth");
    protected final int arc = UIManager.getInt("Button.arc");

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (FlatButtonUI.isContentAreaFilled(c) && !FlatButtonUI.isHelpButton(c)) {
            super.paintBorder(c, g, x, y, width, height);
        }
    }

    @Override
    protected Color getFocusColor(Component c) {
        return FlatButtonUI.isDefaultButton(c) ? this.defaultFocusColor : super.getFocusColor(c);
    }

    @Override
    protected Color getBorderColor(Component c) {
        boolean def = FlatButtonUI.isDefaultButton(c);
        return FlatButtonUI.buttonStateColor(c, def ? this.defaultBorderColor : this.borderColor, this.disabledBorderColor, def ? this.defaultFocusedBorderColor : this.focusedBorderColor, def ? this.defaultHoverBorderColor : this.hoverBorderColor, null);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets = super.getBorderInsets(c, insets);
        if (FlatButtonUI.isIconOnlyButton(c) && ((JButton)c).getMargin() instanceof UIResource) {
            insets.left = insets.right = Math.min(insets.top, insets.bottom);
        }
        return insets;
    }

    @Override
    protected float getBorderWidth(Component c) {
        return FlatButtonUI.isDefaultButton(c) ? UIScale.scale((float)this.defaultBorderWidth) : super.getBorderWidth(c);
    }

    @Override
    protected float getArc() {
        return UIScale.scale((float)this.arc);
    }
}

