/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class FlatScrollPaneUI
extends BasicScrollPaneUI {
    private Handler handler;

    public static ComponentUI createUI(JComponent c) {
        return new FlatScrollPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        int focusWidth = UIManager.getInt("Component.focusWidth");
        LookAndFeel.installProperty(c, "opaque", focusWidth == 0);
        MigLayoutVisualPadding.install((JComponent)this.scrollpane, focusWidth);
    }

    @Override
    public void uninstallUI(JComponent c) {
        MigLayoutVisualPadding.uninstall(this.scrollpane);
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners(JScrollPane c) {
        super.installListeners(c);
        this.addViewportListeners(this.scrollpane.getViewport());
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        super.uninstallListeners(c);
        this.removeViewportListeners(this.scrollpane.getViewport());
        this.handler = null;
    }

    public Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    @Override
    protected void updateViewport(PropertyChangeEvent e) {
        super.updateViewport(e);
        JViewport oldViewport = (JViewport)e.getOldValue();
        JViewport newViewport = (JViewport)e.getNewValue();
        this.removeViewportListeners(oldViewport);
        this.addViewportListeners(newViewport);
    }

    private void addViewportListeners(JViewport viewport) {
        if (viewport == null) {
            return;
        }
        viewport.addContainerListener(this.getHandler());
        Component view = viewport.getView();
        if (view != null) {
            view.addFocusListener(this.getHandler());
        }
    }

    private void removeViewportListeners(JViewport viewport) {
        if (viewport == null) {
            return;
        }
        viewport.removeContainerListener(this.getHandler());
        Component view = viewport.getView();
        if (view != null) {
            view.removeFocusListener(this.getHandler());
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            FlatUIUtils.paintParentBackground(g, c);
            Insets insets = c.getInsets();
            g.setColor(c.getBackground());
            g.fillRect(insets.left, insets.top, c.getWidth() - insets.left - insets.right, c.getHeight() - insets.top - insets.bottom);
        }
        this.paint(g, c);
    }

    private class Handler
    implements ContainerListener,
    FocusListener {
        private Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            e.getChild().addFocusListener(this);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            e.getChild().removeFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent e) {
            FlatScrollPaneUI.this.scrollpane.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            FlatScrollPaneUI.this.scrollpane.repaint();
        }
    }
}

