/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.LinuxFontPolicy;
import com.formdev.flatlaf.UIDefaultsLoader;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLEditorKit;

public abstract class FlatLaf
extends BasicLookAndFeel {
    private BasicLookAndFeel base;
    private String desktopPropertyName;
    private PropertyChangeListener desktopPropertyListener;
    private KeyEventPostProcessor mnemonicListener;
    private static boolean altKeyPressed;
    private Consumer<UIDefaults> postInitialization;

    public static boolean install(LookAndFeel newLookAndFeel) {
        try {
            UIManager.setLookAndFeel(newLookAndFeel);
            return true;
        }
        catch (Exception ex) {
            System.err.println("Failed to initialize look and feel " + newLookAndFeel.getClass().getName());
            return false;
        }
    }

    @Override
    public String getID() {
        return "FlatLaf - " + this.getName();
    }

    public abstract boolean isDark();

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public void initialize() {
        this.getBase().initialize();
        super.initialize();
        if (PopupFactory.getSharedInstance().getClass() != PopupFactory.class) {
            PopupFactory.setSharedInstance(new PopupFactory());
        }
        this.mnemonicListener = e -> {
            if (e.getKeyCode() == 18) {
                FlatLaf.altKeyChanged(e.getID() == 401);
            }
            return false;
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.mnemonicListener);
        if (SystemInfo.IS_WINDOWS) {
            this.desktopPropertyName = "win.messagebox.font";
        } else if (SystemInfo.IS_LINUX) {
            this.desktopPropertyName = "gnome.Xft/DPI";
        }
        if (this.desktopPropertyName != null) {
            this.desktopPropertyListener = e -> FlatLaf.reSetLookAndFeel();
            Toolkit.getDefaultToolkit().addPropertyChangeListener(this.desktopPropertyName, this.desktopPropertyListener);
        }
        this.postInitialization = defaults -> {
            Color linkColor = defaults.getColor("Component.linkColor");
            if (linkColor != null) {
                new HTMLEditorKit().getStyleSheet().addRule(String.format("a { color: #%06x; }", linkColor.getRGB() & 0xFFFFFF));
            }
        };
    }

    @Override
    public void uninitialize() {
        if (this.desktopPropertyListener != null) {
            Toolkit.getDefaultToolkit().removePropertyChangeListener(this.desktopPropertyName, this.desktopPropertyListener);
            this.desktopPropertyName = null;
            this.desktopPropertyListener = null;
        }
        if (this.mnemonicListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.mnemonicListener);
            this.mnemonicListener = null;
        }
        new HTMLEditorKit().getStyleSheet().addRule("a { color: blue; }");
        this.postInitialization = null;
        if (this.base != null) {
            this.base.uninitialize();
        }
        super.uninitialize();
    }

    private BasicLookAndFeel getBase() {
        if (this.base == null) {
            if (SystemInfo.IS_MAC) {
                try {
                    this.base = (BasicLookAndFeel)Class.forName("com.apple.laf.AquaLookAndFeel").newInstance();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new IllegalStateException();
                }
            } else {
                this.base = new MetalLookAndFeel();
            }
        }
        return this.base;
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults defaults = this.getBase().getDefaults();
        defaults.addResourceBundle("com.sun.swing.internal.plaf.metal.resources.metal");
        Color control = defaults.getColor("control");
        defaults.put("EditorPane.disabledBackground", control);
        defaults.put("EditorPane.inactiveBackground", control);
        defaults.put("FormattedTextField.disabledBackground", control);
        defaults.put("PasswordField.disabledBackground", control);
        defaults.put("TextArea.disabledBackground", control);
        defaults.put("TextArea.inactiveBackground", control);
        defaults.put("TextField.disabledBackground", control);
        defaults.put("TextPane.disabledBackground", control);
        defaults.put("TextPane.inactiveBackground", control);
        defaults.put("Spinner.disabledBackground", control);
        defaults.put("Spinner.disabledForeground", control);
        boolean useScreenMenuBar = SystemInfo.IS_MAC && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
        Object aquaMenuBarUI = useScreenMenuBar ? defaults.get("MenuBarUI") : null;
        this.initFonts(defaults);
        FlatLaf.initIconColors(defaults, this.isDark());
        List<Class<?>> lafClassesForDefaultsLoading = this.getLafClassesForDefaultsLoading();
        if (lafClassesForDefaultsLoading != null) {
            UIDefaultsLoader.loadDefaultsFromProperties(lafClassesForDefaultsLoading, defaults);
        } else {
            UIDefaultsLoader.loadDefaultsFromProperties(this.getClass(), defaults);
        }
        if (useScreenMenuBar) {
            defaults.put("MenuBarUI", aquaMenuBarUI);
        }
        if (this.postInitialization != null) {
            this.postInitialization.accept(defaults);
            this.postInitialization = null;
        }
        return defaults;
    }

    List<Class<?>> getLafClassesForDefaultsLoading() {
        return null;
    }

    private void initFonts(UIDefaults defaults) {
        Font font;
        FontUIResource uiFont = null;
        if (SystemInfo.IS_WINDOWS) {
            Font winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font");
            if (winFont != null) {
                uiFont = new FontUIResource(winFont);
            }
        } else if (SystemInfo.IS_MAC) {
            font = defaults.getFont("Label.font");
            if (SystemInfo.IS_MAC_OS_10_11_EL_CAPITAN_OR_LATER) {
                font = new FontUIResource(".SF NS Text", font.getStyle(), font.getSize());
            }
            uiFont = font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
        } else if (SystemInfo.IS_LINUX) {
            font = LinuxFontPolicy.getFont();
            FontUIResource fontUIResource = uiFont = font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
        }
        if (uiFont == null) {
            return;
        }
        uiFont = UIScale.applyCustomScaleFactor(uiFont);
        for (Object key : defaults.keySet()) {
            if (!(key instanceof String) || !((String)key).endsWith(".font")) continue;
            defaults.put(key, uiFont);
        }
        defaults.put("MenuItem.acceleratorFont", uiFont);
    }

    public static void initIconColors(UIDefaults defaults, boolean dark) {
        defaults.put("Actions.Red", new ColorUIResource(!dark ? 14375008 : 13063248));
        defaults.put("Actions.Yellow", new ColorUIResource(!dark ? 15573504 : 15771442));
        defaults.put("Actions.Green", new ColorUIResource(!dark ? 5875817 : 4824148));
        defaults.put("Actions.Blue", new ColorUIResource(!dark ? 3710934 : 3510980));
        defaults.put("Actions.Grey", new ColorUIResource(!dark ? 0x6E6E6E : 11514291));
        defaults.put("Actions.GreyInline", new ColorUIResource(!dark ? 8358801 : 8358801));
        defaults.put("Objects.Grey", new ColorUIResource(10135472));
        defaults.put("Objects.Blue", new ColorUIResource(4241120));
        defaults.put("Objects.Green", new ColorUIResource(6468931));
        defaults.put("Objects.Yellow", new ColorUIResource(16035645));
        defaults.put("Objects.YellowDark", new ColorUIResource(14263107));
        defaults.put("Objects.Purple", new ColorUIResource(12164088));
        defaults.put("Objects.Pink", new ColorUIResource(16354206));
        defaults.put("Objects.Red", new ColorUIResource(15885602));
        defaults.put("Objects.RedStatus", new ColorUIResource(0xE05555));
        defaults.put("Objects.GreenAndroid", new ColorUIResource(10798649));
        defaults.put("Objects.BlackText", new ColorUIResource(2301728));
    }

    private static void reSetLookAndFeel() {
        EventQueue.invokeLater(() -> {
            try {
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                UIManager.setLookAndFeel(lookAndFeel);
                PropertyChangeEvent e = new PropertyChangeEvent(UIManager.class, "lookAndFeel", lookAndFeel, lookAndFeel);
                for (PropertyChangeListener l : UIManager.getPropertyChangeListeners()) {
                    l.propertyChange(e);
                }
                FlatLaf.updateUI();
            }
            catch (UnsupportedLookAndFeelException ex) {
                ex.printStackTrace();
            }
        });
    }

    public static void updateUI() {
        for (Window w : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(w);
        }
    }

    public static boolean isShowMnemonics() {
        return altKeyPressed || !UIManager.getBoolean("Component.hideMnemonics");
    }

    private static void altKeyChanged(boolean pressed) {
        if (pressed == altKeyPressed) {
            return;
        }
        altKeyPressed = pressed;
        if (!UIManager.getBoolean("Component.hideMnemonics")) {
            return;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            return;
        }
        Window window = SwingUtilities.windowForComponent(focusOwner);
        if (window == null) {
            return;
        }
        FlatLaf.repaintMnemonics(window);
    }

    private static void repaintMnemonics(Container container) {
        for (Component c : container.getComponents()) {
            if (FlatLaf.hasMnemonic(c)) {
                c.repaint();
            }
            if (!(c instanceof Container)) continue;
            FlatLaf.repaintMnemonics((Container)c);
        }
    }

    private static boolean hasMnemonic(Component c) {
        if (c instanceof JLabel && ((JLabel)c).getDisplayedMnemonicIndex() >= 0) {
            return true;
        }
        if (c instanceof AbstractButton && ((AbstractButton)c).getDisplayedMnemonicIndex() >= 0) {
            return true;
        }
        if (c instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)c;
            int tabCount = tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (tabPane.getDisplayedMnemonicIndexAt(i) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

