/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class FlatTabbedPaneUI
extends BasicTabbedPaneUI {
    protected Color disabledForeground;
    protected Color selectedBackground;
    protected Color selectedForeground;
    protected Color underlineColor;
    protected Color disabledUnderlineColor;
    protected Color hoverColor;
    protected Color focusColor;
    protected Color tabSeparatorColor;
    protected Color contentAreaColor;
    protected int tabHeight;
    protected int tabSelectionHeight;
    protected int contentSeparatorHeight;
    protected boolean showTabSeparators;
    protected boolean hasFullBorder;
    protected boolean tabsOverlapBorder;

    public static ComponentUI createUI(JComponent c) {
        return new FlatTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.disabledForeground = UIManager.getColor("TabbedPane.disabledForeground");
        this.selectedBackground = UIManager.getColor("TabbedPane.selectedBackground");
        this.selectedForeground = UIManager.getColor("TabbedPane.selectedForeground");
        this.underlineColor = UIManager.getColor("TabbedPane.underlineColor");
        this.disabledUnderlineColor = UIManager.getColor("TabbedPane.disabledUnderlineColor");
        this.hoverColor = UIManager.getColor("TabbedPane.hoverColor");
        this.focusColor = UIManager.getColor("TabbedPane.focusColor");
        this.tabSeparatorColor = UIManager.getColor("TabbedPane.tabSeparatorColor");
        this.contentAreaColor = UIManager.getColor("TabbedPane.contentAreaColor");
        this.tabHeight = UIManager.getInt("TabbedPane.tabHeight");
        this.tabSelectionHeight = UIManager.getInt("TabbedPane.tabSelectionHeight");
        this.contentSeparatorHeight = UIManager.getInt("TabbedPane.contentSeparatorHeight");
        this.showTabSeparators = UIManager.getBoolean("TabbedPane.showTabSeparators");
        this.hasFullBorder = UIManager.getBoolean("TabbedPane.hasFullBorder");
        this.tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        this.textIconGap = UIScale.scale(this.textIconGap);
        this.tabInsets = UIScale.scale(this.tabInsets);
        this.selectedTabPadInsets = UIScale.scale(this.selectedTabPadInsets);
        this.tabAreaInsets = UIScale.scale(this.tabAreaInsets);
        this.tabHeight = UIScale.scale(this.tabHeight);
        this.tabSelectionHeight = UIScale.scale(this.tabSelectionHeight);
        MigLayoutVisualPadding.install((JComponent)this.tabPane, null);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.disabledForeground = null;
        this.selectedBackground = null;
        this.selectedForeground = null;
        this.underlineColor = null;
        this.disabledUnderlineColor = null;
        this.hoverColor = null;
        this.focusColor = null;
        this.tabSeparatorColor = null;
        this.contentAreaColor = null;
        MigLayoutVisualPadding.uninstall(this.tabPane);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new BasicTabbedPaneUI.PropertyChangeHandler(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                super.propertyChange(e);
                switch (e.getPropertyName()) {
                    case "JTabbedPane.showTabSeparators": 
                    case "JTabbedPane.hasFullBorder": {
                        FlatTabbedPaneUI.this.tabPane.revalidate();
                        FlatTabbedPaneUI.this.tabPane.repaint();
                    }
                }
            }
        };
    }

    @Override
    protected JButton createScrollButton(int direction) {
        return new FlatArrowButton(direction, UIManager.getString("Component.arrowType"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.disabledForeground"), null, UIManager.getColor("TabbedPane.hoverColor"));
    }

    @Override
    protected void setRolloverTab(int index) {
        int oldIndex = this.getRolloverTab();
        super.setRolloverTab(index);
        if (index == oldIndex) {
            return;
        }
        this.repaintTab(oldIndex);
        this.repaintTab(index);
    }

    private void repaintTab(int tabIndex) {
        if (tabIndex < 0 || tabIndex >= this.tabPane.getTabCount()) {
            return;
        }
        Rectangle r = this.getTabBounds(this.tabPane, tabIndex);
        if (r != null) {
            this.tabPane.repaint(r);
        }
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) - 3;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return Math.max(this.tabHeight, super.calculateTabHeight(tabPlacement, tabIndex, fontHeight) - 2);
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        boolean hasFullBorder = FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.hasFullBorder", this.hasFullBorder);
        int sh = UIScale.scale(this.contentSeparatorHeight);
        Insets insets = hasFullBorder ? new Insets(sh, sh, sh, sh) : new Insets(sh, 0, 0, 0);
        Insets contentBorderInsets = new Insets(0, 0, 0, 0);
        FlatTabbedPaneUI.rotateInsets(insets, contentBorderInsets, tabPlacement);
        return contentBorderInsets;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        FlatUIUtils.setRenderingHints((Graphics2D)g);
        super.update(g, c);
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Color color;
        g.setFont(font);
        View view = this.getTextViewForTab(tabIndex);
        if (view != null) {
            view.paint(g, textRect);
            return;
        }
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            color = this.tabPane.getForegroundAt(tabIndex);
            if (isSelected && color instanceof UIResource && this.selectedForeground != null) {
                color = this.selectedForeground;
            }
        } else {
            color = this.disabledForeground;
        }
        int mnemIndex = FlatLaf.isShowMnemonics() ? this.tabPane.getDisplayedMnemonicIndexAt(tabIndex) : -1;
        g.setColor(color);
        FlatUIUtils.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean enabled = this.tabPane.isEnabled();
        g.setColor(enabled && this.tabPane.isEnabledAt(tabIndex) && this.getRolloverTab() == tabIndex ? this.hoverColor : (enabled && isSelected && this.tabPane.hasFocus() ? this.focusColor : (this.selectedBackground != null && enabled && isSelected ? this.selectedBackground : this.tabPane.getBackgroundAt(tabIndex))));
        g.fillRect(x, y, w, h);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showTabSeparators", this.showTabSeparators) && !this.isLastInRun(tabIndex)) {
            float sepWidth = UIScale.scale(1.0f);
            float offset = UIScale.scale(5.0f);
            g.setColor(this.tabSeparatorColor != null ? this.tabSeparatorColor : this.contentAreaColor);
            if (tabPlacement == 2 || tabPlacement == 4) {
                ((Graphics2D)g).fill(new Rectangle2D.Float((float)x + offset, (float)(y + h) - sepWidth, (float)w - offset * 2.0f, sepWidth));
            } else if (this.tabPane.getComponentOrientation().isLeftToRight()) {
                ((Graphics2D)g).fill(new Rectangle2D.Float((float)(x + w) - sepWidth, (float)y + offset, sepWidth, (float)h - offset * 2.0f));
            } else {
                ((Graphics2D)g).fill(new Rectangle2D.Float(x, (float)y + offset, sepWidth, (float)h - offset * 2.0f));
            }
        }
        if (isSelected) {
            this.paintTabSelection(g, tabPlacement, x, y, w, h);
        }
    }

    protected void paintTabSelection(Graphics g, int tabPlacement, int x, int y, int w, int h) {
        Rectangle clipBounds;
        Rectangle rectangle = clipBounds = this.isScrollTabLayout() ? g.getClipBounds() : null;
        if (clipBounds != null) {
            Rectangle newClipBounds = new Rectangle(clipBounds);
            int contentSeparatorHeight = UIScale.scale(this.contentSeparatorHeight);
            switch (tabPlacement) {
                default: {
                    newClipBounds.height += contentSeparatorHeight;
                    break;
                }
                case 3: {
                    newClipBounds.y -= contentSeparatorHeight;
                    newClipBounds.height += contentSeparatorHeight;
                    break;
                }
                case 2: {
                    newClipBounds.width += contentSeparatorHeight;
                    break;
                }
                case 4: {
                    newClipBounds.x -= contentSeparatorHeight;
                    newClipBounds.width += contentSeparatorHeight;
                }
            }
            g.setClip(newClipBounds);
        }
        g.setColor(this.tabPane.isEnabled() ? this.underlineColor : this.disabledUnderlineColor);
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        switch (tabPlacement) {
            default: {
                int sy = y + h + contentInsets.top - this.tabSelectionHeight;
                g.fillRect(x, sy, w, this.tabSelectionHeight);
                break;
            }
            case 3: {
                g.fillRect(x, y - contentInsets.bottom, w, this.tabSelectionHeight);
                break;
            }
            case 2: {
                int sx = x + w + contentInsets.left - this.tabSelectionHeight;
                g.fillRect(sx, y, this.tabSelectionHeight, h);
                break;
            }
            case 4: {
                g.fillRect(x - contentInsets.right, y, this.tabSelectionHeight, h);
            }
        }
        if (clipBounds != null) {
            g.setClip(clipBounds);
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        Component scrollableTabViewport;
        if (this.tabPane.getTabCount() <= 0) {
            return;
        }
        Insets insets = this.tabPane.getInsets();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = this.tabPane.getWidth() - insets.right - insets.left;
        int h = this.tabPane.getHeight() - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (this.tabsOverlapBorder) {
                    x -= tabAreaInsets.right;
                }
                w -= x - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (!this.tabsOverlapBorder) break;
                w += tabAreaInsets.left;
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (!this.tabsOverlapBorder) break;
                h += tabAreaInsets.top;
                break;
            }
            default: {
                y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (this.tabsOverlapBorder) {
                    y -= tabAreaInsets.bottom;
                }
                h -= y - insets.top;
            }
        }
        boolean hasFullBorder = FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.hasFullBorder", this.hasFullBorder);
        int sh = UIScale.scale(this.contentSeparatorHeight * 100);
        Insets ci = new Insets(0, 0, 0, 0);
        FlatTabbedPaneUI.rotateInsets(hasFullBorder ? new Insets(sh, sh, sh, sh) : new Insets(sh, 0, 0, 0), ci, tabPlacement);
        g.setColor(this.contentAreaColor);
        Path2D.Float path = new Path2D.Float(0);
        path.append(new Rectangle2D.Float(x, y, w, h), false);
        path.append(new Rectangle2D.Float((float)x + (float)ci.left / 100.0f, (float)y + (float)ci.top / 100.0f, (float)w - (float)ci.left / 100.0f - (float)ci.right / 100.0f, (float)h - (float)ci.top / 100.0f - (float)ci.bottom / 100.0f), false);
        ((Graphics2D)g).fill(path);
        if (this.isScrollTabLayout() && selectedIndex >= 0 && (scrollableTabViewport = this.findComponentByClassName(this.tabPane, BasicTabbedPaneUI.class.getName() + "$ScrollableTabViewport")) != null) {
            Rectangle tabRect = this.getTabBounds(this.tabPane, selectedIndex);
            Shape oldClip = g.getClip();
            g.setClip(scrollableTabViewport.getBounds());
            this.paintTabSelection(g, tabPlacement, tabRect.x, tabRect.y, tabRect.width, tabRect.height);
            g.setClip(oldClip);
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    private boolean isLastInRun(int tabIndex) {
        int run = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        return this.lastTabInRun(this.tabPane.getTabCount(), run) == tabIndex;
    }

    private boolean isScrollTabLayout() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    private Component findComponentByClassName(Container c, String className) {
        for (Component child : c.getComponents()) {
            Component c2;
            if (className.equals(child.getClass().getName())) {
                return child;
            }
            if (!(child instanceof Container) || (c2 = this.findComponentByClassName((Container)child, className)) == null) continue;
            return c2;
        }
        return null;
    }
}

