/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.JTextComponent;

public class FlatBorder
extends BasicBorders.MarginBorder {
    protected final int focusWidth = UIManager.getInt("Component.focusWidth");
    protected final float innerFocusWidth = FlatUIUtils.getUIFloat("Component.innerFocusWidth", 0.0f);
    protected final Color focusColor = UIManager.getColor("Component.focusColor");
    protected final Color borderColor = UIManager.getColor("Component.borderColor");
    protected final Color disabledBorderColor = UIManager.getColor("Component.disabledBorderColor");
    protected final Color focusedBorderColor = UIManager.getColor("Component.focusedBorderColor");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            float arc;
            FlatUIUtils.setRenderingHints(g2);
            boolean isCellEditor = this.isTableCellEditor(c);
            float focusWidth = isCellEditor ? 0.0f : this.getFocusWidth();
            float borderWidth = this.getBorderWidth(c);
            float f = arc = isCellEditor ? 0.0f : this.getArc();
            if (this.isFocused(c)) {
                g2.setColor(this.getFocusColor(c));
                FlatUIUtils.paintComponentOuterBorder(g2, x, y, width, height, focusWidth, this.getLineWidth() + UIScale.scale(this.innerFocusWidth), arc);
            }
            g2.setPaint(this.getBorderColor(c));
            FlatUIUtils.paintComponentBorder(g2, x, y, width, height, focusWidth, borderWidth, arc);
        }
        finally {
            g2.dispose();
        }
    }

    protected Color getFocusColor(Component c) {
        return this.focusColor;
    }

    protected Paint getBorderColor(Component c) {
        return this.isEnabled(c) ? (this.isFocused(c) ? this.focusedBorderColor : this.borderColor) : this.disabledBorderColor;
    }

    protected boolean isEnabled(Component c) {
        if (c instanceof JScrollPane) {
            Component view;
            JViewport viewport = ((JScrollPane)c).getViewport();
            Component component = view = viewport != null ? viewport.getView() : null;
            if (view != null && !this.isEnabled(view)) {
                return false;
            }
        }
        return c.isEnabled() && (!(c instanceof JTextComponent) || ((JTextComponent)c).isEditable());
    }

    protected boolean isFocused(Component c) {
        if (c instanceof JScrollPane) {
            Component view;
            JViewport viewport = ((JScrollPane)c).getViewport();
            Component component = view = viewport != null ? viewport.getView() : null;
            if (view != null) {
                Component focusOwner;
                if (view.hasFocus()) {
                    return true;
                }
                if ((view instanceof JTable && ((JTable)view).isEditing() || view instanceof JTree && ((JTree)view).isEditing()) && (focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null) {
                    return SwingUtilities.isDescendingFrom(focusOwner, view);
                }
            }
            return false;
        }
        if (c instanceof JComboBox && ((JComboBox)c).isEditable()) {
            Component editorComponent = ((JComboBox)c).getEditor().getEditorComponent();
            return editorComponent != null ? editorComponent.hasFocus() : false;
        }
        if (c instanceof JSpinner) {
            JFormattedTextField textField;
            JComponent editor = ((JSpinner)c).getEditor();
            if (editor instanceof JSpinner.DefaultEditor && (textField = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
                return textField.hasFocus();
            }
            return false;
        }
        return c.hasFocus();
    }

    protected boolean isTableCellEditor(Component c) {
        return FlatUIUtils.isTableCellEditor(c);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        boolean isCellEditor = this.isTableCellEditor(c);
        float ow = (isCellEditor ? 0.0f : this.getFocusWidth()) + this.getLineWidth();
        insets = super.getBorderInsets(c, insets);
        insets.top = Math.round(UIScale.scale((float)insets.top) + ow);
        insets.left = Math.round(UIScale.scale((float)insets.left) + ow);
        insets.bottom = Math.round(UIScale.scale((float)insets.bottom) + ow);
        insets.right = Math.round(UIScale.scale((float)insets.right) + ow);
        return insets;
    }

    protected float getFocusWidth() {
        return UIScale.scale((float)this.focusWidth);
    }

    protected float getLineWidth() {
        return UIScale.scale(1.0f);
    }

    protected float getBorderWidth(Component c) {
        return this.getLineWidth();
    }

    protected float getArc() {
        return 0.0f;
    }
}

