/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatTextFieldUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;

public class FlatPasswordFieldUI
extends BasicPasswordFieldUI {
    protected int focusWidth;
    protected int minimumWidth;
    protected boolean isIntelliJTheme;
    protected Color placeholderForeground;
    private FocusListener focusListener;

    public static ComponentUI createUI(JComponent c) {
        return new FlatPasswordFieldUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (SystemInfo.IS_MAC) {
            LookAndFeel.installProperty(this.getComponent(), "echoChar", Character.valueOf('\u2022'));
        }
        String prefix = this.getPropertyPrefix();
        this.focusWidth = UIManager.getInt("Component.focusWidth");
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.isIntelliJTheme = UIManager.getBoolean("Component.isIntelliJTheme");
        this.placeholderForeground = UIManager.getColor(prefix + ".placeholderForeground");
        LookAndFeel.installProperty(this.getComponent(), "opaque", this.focusWidth == 0);
        MigLayoutVisualPadding.install((JComponent)this.getComponent(), this.focusWidth);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.placeholderForeground = null;
        MigLayoutVisualPadding.uninstall(this.getComponent());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.focusListener = new FlatUIUtils.RepaintFocusListener(this.getComponent());
        this.getComponent().addFocusListener(this.focusListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    @Override
    protected void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if ("JTextField.placeholderText".equals(e.getPropertyName())) {
            this.getComponent().repaint();
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        FlatTextFieldUI.paintBackground(g, this.getComponent(), this.focusWidth, this.isIntelliJTheme);
        FlatTextFieldUI.paintPlaceholder(g, this.getComponent(), this.placeholderForeground);
        super.paintSafely(g);
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.applyMinimumWidth(super.getPreferredSize(c), c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.applyMinimumWidth(super.getMinimumSize(c), c);
    }

    private Dimension applyMinimumWidth(Dimension size, JComponent c) {
        int focusWidth = c.getBorder() instanceof FlatBorder ? this.focusWidth : 0;
        size.width = Math.max(size.width, UIScale.scale(this.minimumWidth + focusWidth * 2));
        return size;
    }
}

