/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.HSLColor;
import java.awt.Color;

public class ColorFunctions {
    public static Color applyFunctions(Color color, ColorFunction ... functions) {
        float[] hsl = HSLColor.fromRGB(color);
        float alpha = (float)color.getAlpha() / 255.0f;
        for (ColorFunction function : functions) {
            function.apply(hsl);
        }
        return HSLColor.toRGB(hsl, alpha);
    }

    private static float clamp(float value) {
        return value < 0.0f ? 0.0f : (value > 100.0f ? 100.0f : value);
    }

    public static class Darken
    extends Lighten {
        public Darken(float amount, boolean relative, boolean autoInverse) {
            super(-amount, relative, autoInverse);
        }

        @Override
        protected boolean shouldInverse(float[] hsl) {
            return hsl[2] < 50.0f;
        }
    }

    public static class Lighten
    implements ColorFunction {
        private final float amount;
        private final boolean relative;
        private final boolean autoInverse;

        public Lighten(float amount, boolean relative, boolean autoInverse) {
            this.amount = amount;
            this.relative = relative;
            this.autoInverse = autoInverse;
        }

        @Override
        public void apply(float[] hsl) {
            float amount2 = this.autoInverse && this.shouldInverse(hsl) ? -this.amount : this.amount;
            hsl[2] = ColorFunctions.clamp(this.relative ? hsl[2] * ((100.0f + amount2) / 100.0f) : hsl[2] + amount2);
        }

        protected boolean shouldInverse(float[] hsl) {
            return hsl[2] >= 50.0f;
        }
    }

    public static interface ColorFunction {
        public void apply(float[] var1);
    }
}

