/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class FlatProgressBarUI
extends BasicProgressBarUI {
    protected int arc;
    protected Dimension horizontalSize;
    protected Dimension verticalSize;

    public static ComponentUI createUI(JComponent c) {
        return new FlatProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.progressBar, "opaque", false);
        this.arc = UIManager.getInt("ProgressBar.arc");
        this.horizontalSize = UIManager.getDimension("ProgressBar.horizontalSize");
        this.verticalSize = UIManager.getDimension("ProgressBar.verticalSize");
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (this.progressBar.isStringPainted()) {
            Insets insets = this.progressBar.getInsets();
            FontMetrics fm = this.progressBar.getFontMetrics(this.progressBar.getFont());
            if (this.progressBar.getOrientation() == 0) {
                size.height = Math.max(fm.getHeight() + insets.top + insets.bottom, this.getPreferredInnerHorizontal().height);
            } else {
                size.width = Math.max(fm.getHeight() + insets.left + insets.right, this.getPreferredInnerVertical().width);
            }
        }
        return size;
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        return UIScale.scale(this.horizontalSize);
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        return UIScale.scale(this.verticalSize);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            FlatUIUtils.paintParentBackground(g, c);
        }
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Insets insets = this.progressBar.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.progressBar.getWidth() - (insets.right + insets.left);
        int height = this.progressBar.getHeight() - (insets.top + insets.bottom);
        if (width <= 0 || height <= 0) {
            return;
        }
        boolean horizontal = this.progressBar.getOrientation() == 0;
        int arc = Math.min(UIScale.scale(this.arc), horizontal ? height : width);
        FlatUIUtils.setRenderingHints((Graphics2D)g);
        RoundRectangle2D.Float trackShape = new RoundRectangle2D.Float(x, y, width, height, arc, arc);
        g.setColor(this.progressBar.getBackground());
        ((Graphics2D)g).fill(trackShape);
        if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                g.setColor(this.progressBar.getForeground());
                ((Graphics2D)g).fill(new RoundRectangle2D.Float(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height, arc, arc));
            }
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, x, y, width, height, 0, insets);
            }
        } else {
            int amountFull = this.getAmountFull(insets, width, height);
            RoundRectangle2D.Float progressShape = horizontal ? new RoundRectangle2D.Float(c.getComponentOrientation().isLeftToRight() ? (float)x : (float)(x + (width - amountFull)), y, amountFull, height, arc, arc) : new RoundRectangle2D.Float(x, y + (height - amountFull), width, amountFull, arc, arc);
            g.setColor(this.progressBar.getForeground());
            if (amountFull < (horizontal ? height : width)) {
                Area area = new Area(trackShape);
                area.intersect(new Area(progressShape));
                ((Graphics2D)g).fill(area);
            } else {
                ((Graphics2D)g).fill(progressShape);
            }
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, x, y, width, height, amountFull, insets);
            }
        }
    }
}

