/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatCaret;
import com.formdev.flatlaf.ui.FlatTextFieldUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class FlatPasswordFieldUI
extends BasicPasswordFieldUI {
    protected int arc;
    protected int focusWidth;
    protected int minimumWidth;
    protected boolean isIntelliJTheme;
    protected Color placeholderForeground;
    protected Icon capsLockIcon;
    private FocusListener focusListener;
    private KeyListener capsLockListener;

    public static ComponentUI createUI(JComponent c) {
        return new FlatPasswordFieldUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String prefix = this.getPropertyPrefix();
        this.arc = UIManager.getInt("TextComponent.arc");
        this.focusWidth = UIManager.getInt("Component.focusWidth");
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.isIntelliJTheme = UIManager.getBoolean("Component.isIntelliJTheme");
        this.placeholderForeground = UIManager.getColor(prefix + ".placeholderForeground");
        this.capsLockIcon = UIManager.getIcon("PasswordField.capsLockIcon");
        LookAndFeel.installProperty(this.getComponent(), "opaque", this.focusWidth == 0);
        MigLayoutVisualPadding.install((JComponent)this.getComponent(), this.focusWidth);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.placeholderForeground = null;
        this.capsLockIcon = null;
        MigLayoutVisualPadding.uninstall(this.getComponent());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.focusListener = new FlatUIUtils.RepaintFocusListener(this.getComponent());
        this.capsLockListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.repaint(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.repaint(e);
            }

            private void repaint(KeyEvent e) {
                if (e.getKeyCode() == 20) {
                    e.getComponent().repaint();
                }
            }
        };
        this.getComponent().addFocusListener(this.focusListener);
        this.getComponent().addKeyListener(this.capsLockListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this.focusListener);
        this.getComponent().removeKeyListener(this.capsLockListener);
        this.focusListener = null;
        this.capsLockListener = null;
    }

    @Override
    protected Caret createCaret() {
        return new FlatCaret(UIManager.getString("TextComponent.selectAllOnFocusPolicy"));
    }

    @Override
    protected void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if ("JTextField.placeholderText".equals(e.getPropertyName())) {
            this.getComponent().repaint();
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        FlatTextFieldUI.paintBackground(g, this.getComponent(), this.focusWidth, this.arc, this.isIntelliJTheme);
        FlatTextFieldUI.paintPlaceholder(g, this.getComponent(), this.placeholderForeground);
        this.paintCapsLock(g);
        super.paintSafely(g);
    }

    protected void paintCapsLock(Graphics g) {
        JTextComponent c = this.getComponent();
        if (!c.isFocusOwner() || !Toolkit.getDefaultToolkit().getLockingKeyState(20)) {
            return;
        }
        int y = (c.getHeight() - this.capsLockIcon.getIconHeight()) / 2;
        int x = c.getWidth() - this.capsLockIcon.getIconWidth() - y;
        this.capsLockIcon.paintIcon(c, g, x, y);
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.applyMinimumWidth(super.getPreferredSize(c), c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.applyMinimumWidth(super.getMinimumSize(c), c);
    }

    private Dimension applyMinimumWidth(Dimension size, JComponent c) {
        int minimumWidth = FlatUIUtils.minimumWidth(this.getComponent(), this.minimumWidth);
        int focusWidth = c.getBorder() instanceof FlatBorder ? this.focusWidth : 0;
        size.width = Math.max(size.width, UIScale.scale(minimumWidth + focusWidth * 2));
        return size;
    }
}

