/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatDefaultsAddon;
import com.formdev.flatlaf.FlatInputMaps;
import com.formdev.flatlaf.LinuxFontPolicy;
import com.formdev.flatlaf.UIDefaultsLoader;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTMLEditorKit;

public abstract class FlatLaf
extends BasicLookAndFeel {
    static final Logger LOG = Logger.getLogger(FlatLaf.class.getName());
    private static final String DESKTOPFONTHINTS = "awt.font.desktophints";
    private String desktopPropertyName;
    private PropertyChangeListener desktopPropertyListener;
    private static boolean aquaLoaded;
    private static boolean updateUIPending;
    private KeyEventPostProcessor mnemonicListener;
    private static boolean showMnemonics;
    private static WeakReference<Window> lastShowMnemonicWindow;
    private Consumer<UIDefaults> postInitialization;

    public static boolean install(LookAndFeel newLookAndFeel) {
        try {
            UIManager.setLookAndFeel(newLookAndFeel);
            return true;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "FlatLaf: Failed to initialize look and feel '" + newLookAndFeel.getClass().getName() + "'.", ex);
            return false;
        }
    }

    @Override
    public String getID() {
        return "FlatLaf - " + this.getName();
    }

    public abstract boolean isDark();

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public void initialize() {
        if (SystemInfo.IS_MAC) {
            this.initializeAqua();
        }
        super.initialize();
        this.mnemonicListener = e -> {
            FlatLaf.checkShowMnemonics(e);
            return false;
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.mnemonicListener);
        if (SystemInfo.IS_WINDOWS) {
            this.desktopPropertyName = "win.messagebox.font";
        } else if (SystemInfo.IS_LINUX) {
            this.desktopPropertyName = "gnome.Xft/DPI";
        }
        if (this.desktopPropertyName != null) {
            this.desktopPropertyListener = e -> {
                String propertyName = e.getPropertyName();
                if (this.desktopPropertyName.equals(propertyName)) {
                    FlatLaf.reSetLookAndFeel();
                } else if (DESKTOPFONTHINTS.equals(propertyName) && UIManager.getLookAndFeel() instanceof FlatLaf) {
                    this.putAATextInfo(UIManager.getLookAndFeelDefaults());
                    FlatLaf.updateUILater();
                }
            };
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.addPropertyChangeListener(this.desktopPropertyName, this.desktopPropertyListener);
            toolkit.addPropertyChangeListener(DESKTOPFONTHINTS, this.desktopPropertyListener);
        }
        this.postInitialization = defaults -> {
            Color linkColor = defaults.getColor("Component.linkColor");
            if (linkColor != null) {
                new HTMLEditorKit().getStyleSheet().addRule(String.format("a { color: #%06x; }", linkColor.getRGB() & 0xFFFFFF));
            }
        };
    }

    @Override
    public void uninitialize() {
        if (this.desktopPropertyListener != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.removePropertyChangeListener(this.desktopPropertyName, this.desktopPropertyListener);
            toolkit.removePropertyChangeListener(DESKTOPFONTHINTS, this.desktopPropertyListener);
            this.desktopPropertyName = null;
            this.desktopPropertyListener = null;
        }
        if (this.mnemonicListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.mnemonicListener);
            this.mnemonicListener = null;
        }
        new HTMLEditorKit().getStyleSheet().addRule("a { color: blue; }");
        this.postInitialization = null;
        super.uninitialize();
    }

    private void initializeAqua() {
        BasicLookAndFeel aquaLaf;
        if (aquaLoaded) {
            return;
        }
        aquaLoaded = true;
        String aquaLafClassName = "com.apple.laf.AquaLookAndFeel";
        try {
            if (SystemInfo.IS_JAVA_9_OR_LATER) {
                Method m = UIManager.class.getMethod("createLookAndFeel", String.class);
                aquaLaf = (BasicLookAndFeel)m.invoke(null, "Mac OS X");
            } else {
                aquaLaf = (BasicLookAndFeel)Class.forName(aquaLafClassName).newInstance();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "FlatLaf: Failed to initialize Aqua look and feel '" + aquaLafClassName + "'.", ex);
            throw new IllegalStateException();
        }
        PopupFactory oldPopupFactory = PopupFactory.getSharedInstance();
        aquaLaf.initialize();
        aquaLaf.uninitialize();
        PopupFactory.setSharedInstance(oldPopupFactory);
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults defaults = super.getDefaults();
        defaults.addResourceBundle("com.sun.swing.internal.plaf.metal.resources.metal");
        this.putDefaults(defaults, defaults.getColor("control"), "EditorPane.disabledBackground", "EditorPane.inactiveBackground", "FormattedTextField.disabledBackground", "PasswordField.disabledBackground", "Spinner.disabledBackground", "TextArea.disabledBackground", "TextArea.inactiveBackground", "TextField.disabledBackground", "TextPane.disabledBackground", "TextPane.inactiveBackground");
        this.putDefaults(defaults, defaults.getColor("textInactiveText"), "Button.disabledText", "CheckBox.disabledText", "CheckBoxMenuItem.disabledForeground", "Menu.disabledForeground", "MenuItem.disabledForeground", "RadioButton.disabledText", "RadioButtonMenuItem.disabledForeground", "Spinner.disabledForeground", "ToggleButton.disabledText");
        this.putDefaults(defaults, defaults.getColor("textText"), "DesktopIcon.foreground");
        this.initFonts(defaults);
        FlatLaf.initIconColors(defaults, this.isDark());
        FlatInputMaps.initInputMaps(defaults);
        ServiceLoader<FlatDefaultsAddon> addonLoader = ServiceLoader.load(FlatDefaultsAddon.class);
        ArrayList<FlatDefaultsAddon> addons = new ArrayList<FlatDefaultsAddon>();
        for (FlatDefaultsAddon addon : addonLoader) {
            addons.add(addon);
        }
        addons.sort((addon1, addon2) -> addon1.getPriority() - addon2.getPriority());
        List<Class<?>> lafClassesForDefaultsLoading = this.getLafClassesForDefaultsLoading();
        if (lafClassesForDefaultsLoading != null) {
            UIDefaultsLoader.loadDefaultsFromProperties(lafClassesForDefaultsLoading, addons, this.getAdditionalDefaults(), this.isDark(), defaults);
        } else {
            UIDefaultsLoader.loadDefaultsFromProperties(this.getClass(), addons, this.getAdditionalDefaults(), this.isDark(), defaults);
        }
        if (SystemInfo.IS_MAC && Boolean.getBoolean("apple.laf.useScreenMenuBar")) {
            defaults.put("MenuBarUI", "com.apple.laf.AquaMenuBarUI");
        }
        this.putAATextInfo(defaults);
        this.applyAdditionalDefaults(defaults);
        for (FlatDefaultsAddon addon : addons) {
            addon.afterDefaultsLoading(this, defaults);
        }
        if (this.postInitialization != null) {
            this.postInitialization.accept(defaults);
            this.postInitialization = null;
        }
        return defaults;
    }

    void applyAdditionalDefaults(UIDefaults defaults) {
    }

    protected List<Class<?>> getLafClassesForDefaultsLoading() {
        return null;
    }

    protected Properties getAdditionalDefaults() {
        return null;
    }

    private void initFonts(UIDefaults defaults) {
        FontUIResource uiFont = null;
        if (SystemInfo.IS_WINDOWS) {
            Font winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font");
            if (winFont != null) {
                uiFont = FlatLaf.createCompositeFont(winFont.getFamily(), winFont.getStyle(), winFont.getSize());
            }
        } else if (SystemInfo.IS_MAC) {
            String fontName = SystemInfo.IS_MAC_OS_10_11_EL_CAPITAN_OR_LATER ? ".SF NS Text" : "Lucida Grande";
            uiFont = FlatLaf.createCompositeFont(fontName, 0, 13);
        } else if (SystemInfo.IS_LINUX) {
            Font font = LinuxFontPolicy.getFont();
            FontUIResource fontUIResource = uiFont = font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
        }
        if (uiFont == null) {
            uiFont = FlatLaf.createCompositeFont("SansSerif", 0, 12);
        }
        uiFont = UIScale.applyCustomScaleFactor(uiFont);
        ActiveFont activeFont = new ActiveFont(1.0f);
        for (Object key : defaults.keySet()) {
            if (!(key instanceof String) || !((String)key).endsWith(".font") && !((String)key).endsWith("Font")) continue;
            defaults.put(key, activeFont);
        }
        defaults.put("ProgressBar.font", new ActiveFont(0.85f));
        defaults.put("defaultFont", uiFont);
    }

    static FontUIResource createCompositeFont(String family, int style, int size) {
        Font font = new StyleContext().getFont(family, style, size);
        return font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
    }

    public static void initIconColors(UIDefaults defaults, boolean dark) {
        defaults.put("Actions.Red", new ColorUIResource(!dark ? 14375008 : 13063248));
        defaults.put("Actions.Yellow", new ColorUIResource(!dark ? 15573504 : 15771442));
        defaults.put("Actions.Green", new ColorUIResource(!dark ? 5875817 : 4824148));
        defaults.put("Actions.Blue", new ColorUIResource(!dark ? 3710934 : 3510980));
        defaults.put("Actions.Grey", new ColorUIResource(!dark ? 0x6E6E6E : 11514291));
        defaults.put("Actions.GreyInline", new ColorUIResource(!dark ? 8358801 : 8358801));
        defaults.put("Objects.Grey", new ColorUIResource(10135472));
        defaults.put("Objects.Blue", new ColorUIResource(4241120));
        defaults.put("Objects.Green", new ColorUIResource(6468931));
        defaults.put("Objects.Yellow", new ColorUIResource(16035645));
        defaults.put("Objects.YellowDark", new ColorUIResource(14263107));
        defaults.put("Objects.Purple", new ColorUIResource(12164088));
        defaults.put("Objects.Pink", new ColorUIResource(16354206));
        defaults.put("Objects.Red", new ColorUIResource(15885602));
        defaults.put("Objects.RedStatus", new ColorUIResource(0xE05555));
        defaults.put("Objects.GreenAndroid", new ColorUIResource(10798649));
        defaults.put("Objects.BlackText", new ColorUIResource(2301728));
    }

    private void putAATextInfo(UIDefaults defaults) {
        if (SystemInfo.IS_JAVA_9_OR_LATER) {
            Map hints;
            Object aaHint;
            Object desktopHints = Toolkit.getDefaultToolkit().getDesktopProperty(DESKTOPFONTHINTS);
            if (desktopHints instanceof Map && (aaHint = (hints = (Map)desktopHints).get(RenderingHints.KEY_TEXT_ANTIALIASING)) != null && aaHint != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF && aaHint != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                defaults.put(RenderingHints.KEY_TEXT_ANTIALIASING, aaHint);
                defaults.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, hints.get(RenderingHints.KEY_TEXT_LCD_CONTRAST));
            }
        } else {
            try {
                Object key = Class.forName("sun.swing.SwingUtilities2").getField("AA_TEXT_PROPERTY_KEY").get(null);
                Object value = Class.forName("sun.swing.SwingUtilities2$AATextInfo").getMethod("getAATextInfo", Boolean.TYPE).invoke(null, true);
                defaults.put(key, value);
            }
            catch (Exception ex) {
                Logger.getLogger(FlatLaf.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    private void putDefaults(UIDefaults defaults, Object value, String ... keys) {
        for (String key : keys) {
            defaults.put(key, value);
        }
    }

    private static void reSetLookAndFeel() {
        EventQueue.invokeLater(() -> {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            try {
                UIManager.setLookAndFeel(lookAndFeel);
                PropertyChangeEvent e = new PropertyChangeEvent(UIManager.class, "lookAndFeel", lookAndFeel, lookAndFeel);
                for (PropertyChangeListener l : UIManager.getPropertyChangeListeners()) {
                    l.propertyChange(e);
                }
                FlatLaf.updateUI();
            }
            catch (UnsupportedLookAndFeelException ex) {
                LOG.log(Level.SEVERE, "FlatLaf: Failed to reinitialize look and feel '" + lookAndFeel.getClass().getName() + "'.", ex);
            }
        });
    }

    public static void updateUI() {
        for (Window w : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateUILater() {
        Class<FlatLaf> clazz = FlatLaf.class;
        synchronized (FlatLaf.class) {
            if (updateUIPending) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            updateUIPending = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            EventQueue.invokeLater(() -> {
                FlatLaf.updateUI();
                Class<FlatLaf> clazz = FlatLaf.class;
                synchronized (FlatLaf.class) {
                    updateUIPending = false;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
            });
            return;
        }
    }

    public static boolean isShowMnemonics() {
        return showMnemonics || !UIManager.getBoolean("Component.hideMnemonics");
    }

    private static void checkShowMnemonics(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (SystemInfo.IS_MAC) {
            if (keyCode == 17 || keyCode == 18) {
                FlatLaf.showMnemonics(e.getID() == 401 && e.isControlDown() && e.isAltDown(), e.getComponent());
            }
        } else if (keyCode == 18) {
            FlatLaf.showMnemonics(e.getID() == 401, e.getComponent());
        }
    }

    private static void showMnemonics(boolean show, Component c) {
        if (show == showMnemonics) {
            return;
        }
        showMnemonics = show;
        if (!UIManager.getBoolean("Component.hideMnemonics")) {
            return;
        }
        if (show) {
            JRootPane rootPane = SwingUtilities.getRootPane(c);
            if (rootPane == null) {
                return;
            }
            Window window = SwingUtilities.getWindowAncestor(rootPane);
            if (window == null) {
                return;
            }
            FlatLaf.repaintMnemonics(window);
            lastShowMnemonicWindow = new WeakReference<Window>(window);
        } else if (lastShowMnemonicWindow != null) {
            Window window = (Window)lastShowMnemonicWindow.get();
            if (window != null) {
                FlatLaf.repaintMnemonics(window);
            }
            lastShowMnemonicWindow = null;
        }
    }

    private static void repaintMnemonics(Container container) {
        for (Component c : container.getComponents()) {
            if (!c.isVisible()) continue;
            if (FlatLaf.hasMnemonic(c)) {
                c.repaint();
            }
            if (!(c instanceof Container)) continue;
            FlatLaf.repaintMnemonics((Container)c);
        }
    }

    private static boolean hasMnemonic(Component c) {
        if (c instanceof JLabel && ((JLabel)c).getDisplayedMnemonicIndex() >= 0) {
            return true;
        }
        if (c instanceof AbstractButton && ((AbstractButton)c).getDisplayedMnemonicIndex() >= 0) {
            return true;
        }
        if (c instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)c;
            int tabCount = tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (tabPane.getDisplayedMnemonicIndexAt(i) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static class ActiveFont
    implements UIDefaults.ActiveValue {
        private final float scaleFactor;
        private Font font;
        private Font lastDefaultFont;

        ActiveFont(float scaleFactor) {
            this.scaleFactor = scaleFactor;
        }

        @Override
        public Object createValue(UIDefaults table) {
            Font defaultFont = UIManager.getFont("defaultFont");
            if (this.lastDefaultFont != defaultFont) {
                this.lastDefaultFont = defaultFont;
                if (this.scaleFactor != 1.0f) {
                    int newFontSize = Math.round((float)defaultFont.getSize() * this.scaleFactor);
                    this.font = new FontUIResource(defaultFont.deriveFont((float)newFontSize));
                } else {
                    this.font = defaultFont instanceof UIResource ? defaultFont : new FontUIResource(defaultFont);
                }
            }
            return this.font;
        }
    }
}

