/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.UIManager;

public class FlatWindowResizer
extends JComponent
implements PropertyChangeListener,
WindowStateListener,
ComponentListener {
    private static final Integer WINDOW_RESIZER_LAYER = JLayeredPane.DRAG_LAYER + 1;
    private final JRootPane rootPane;
    private final int borderDragThickness = FlatUIUtils.getUIInt("RootPane.borderDragThickness", 5);
    private final int cornerDragWidth = FlatUIUtils.getUIInt("RootPane.cornerDragWidth", 16);
    private final boolean honorMinimumSizeOnResize = UIManager.getBoolean("RootPane.honorMinimumSizeOnResize");
    private Window window;

    public FlatWindowResizer(JRootPane rootPane) {
        this.rootPane = rootPane;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createDragBorderComponent(6, 8, 7), "North");
        this.add((Component)this.createDragBorderComponent(4, 9, 5), "South");
        this.add((Component)this.createDragBorderComponent(6, 10, 4), "West");
        this.add((Component)this.createDragBorderComponent(7, 11, 5), "East");
        rootPane.addComponentListener(this);
        rootPane.getLayeredPane().add((Component)this, WINDOW_RESIZER_LAYER);
        if (rootPane.isDisplayable()) {
            this.setBounds(0, 0, rootPane.getWidth(), rootPane.getHeight());
        }
    }

    protected DragBorderComponent createDragBorderComponent(int leadingResizeDir, int centerResizeDir, int trailingResizeDir) {
        return new DragBorderComponent(leadingResizeDir, centerResizeDir, trailingResizeDir);
    }

    public void uninstall() {
        this.rootPane.removeComponentListener(this);
        this.rootPane.getLayeredPane().remove(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container parent = this.rootPane.getParent();
        Window window = this.window = parent instanceof Window ? (Window)parent : null;
        if (this.window instanceof Frame) {
            this.window.addPropertyChangeListener("resizable", this);
            this.window.addWindowStateListener(this);
        }
        this.updateVisibility();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.window instanceof Frame) {
            this.window.removePropertyChangeListener("resizable", this);
            this.window.removeWindowStateListener(this);
        }
        this.window = null;
        this.updateVisibility();
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.window instanceof Dialog) {
            this.updateVisibility();
        }
    }

    private void updateVisibility() {
        boolean visible = this.isWindowResizable();
        if (visible == this.getComponent(0).isVisible()) {
            return;
        }
        for (Component c : this.getComponents()) {
            c.setVisible(visible);
        }
    }

    private boolean isWindowResizable() {
        if (this.window instanceof Frame) {
            return ((Frame)this.window).isResizable() && (((Frame)this.window).getExtendedState() & 6) == 0;
        }
        if (this.window instanceof Dialog) {
            return ((Dialog)this.window).isResizable();
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.updateVisibility();
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        this.updateVisibility();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setBounds(0, 0, this.rootPane.getWidth(), this.rootPane.getHeight());
        this.validate();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    protected class DragBorderComponent
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private final int leadingResizeDir;
        private final int centerResizeDir;
        private final int trailingResizeDir;
        private int resizeDir = -1;
        private int dragStartMouseX;
        private int dragStartMouseY;
        private Rectangle dragStartWindowBounds;

        protected DragBorderComponent(int leadingResizeDir, int centerResizeDir, int trailingResizeDir) {
            this.leadingResizeDir = leadingResizeDir;
            this.centerResizeDir = centerResizeDir;
            this.trailingResizeDir = trailingResizeDir;
            this.setResizeDir(centerResizeDir);
            this.setVisible(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        protected void setResizeDir(int resizeDir) {
            if (this.resizeDir == resizeDir) {
                return;
            }
            this.resizeDir = resizeDir;
            this.setCursor(Cursor.getPredefinedCursor(resizeDir));
        }

        @Override
        public Dimension getPreferredSize() {
            int thickness = UIScale.scale(FlatWindowResizer.this.borderDragThickness);
            return new Dimension(thickness, thickness);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (FlatWindowResizer.this.window == null) {
                return;
            }
            this.dragStartMouseX = e.getXOnScreen();
            this.dragStartMouseY = e.getYOnScreen();
            this.dragStartWindowBounds = FlatWindowResizer.this.window.getBounds();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dragStartWindowBounds = null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            boolean topBottom = this.centerResizeDir == 8 || this.centerResizeDir == 9;
            int xy = topBottom ? e.getX() : e.getY();
            int wh = topBottom ? this.getWidth() : this.getHeight();
            int cornerWH = UIScale.scale(FlatWindowResizer.this.cornerDragWidth - (topBottom ? 0 : FlatWindowResizer.this.borderDragThickness));
            this.setResizeDir(xy <= cornerWH ? this.leadingResizeDir : (xy >= wh - cornerWH ? this.trailingResizeDir : this.centerResizeDir));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Dimension minimumSize;
            if (this.dragStartWindowBounds == null) {
                return;
            }
            if (!FlatWindowResizer.this.isWindowResizable()) {
                return;
            }
            int mouseDeltaX = e.getXOnScreen() - this.dragStartMouseX;
            int mouseDeltaY = e.getYOnScreen() - this.dragStartMouseY;
            int deltaX = 0;
            int deltaY = 0;
            int deltaWidth = 0;
            int deltaHeight = 0;
            if (this.resizeDir == 8 || this.resizeDir == 6 || this.resizeDir == 7) {
                deltaY = mouseDeltaY;
                deltaHeight = -mouseDeltaY;
            }
            if (this.resizeDir == 9 || this.resizeDir == 4 || this.resizeDir == 5) {
                deltaHeight = mouseDeltaY;
            }
            if (this.resizeDir == 10 || this.resizeDir == 6 || this.resizeDir == 4) {
                deltaX = mouseDeltaX;
                deltaWidth = -mouseDeltaX;
            }
            if (this.resizeDir == 11 || this.resizeDir == 7 || this.resizeDir == 5) {
                deltaWidth = mouseDeltaX;
            }
            Rectangle newBounds = new Rectangle(this.dragStartWindowBounds);
            newBounds.x += deltaX;
            newBounds.y += deltaY;
            newBounds.width += deltaWidth;
            newBounds.height += deltaHeight;
            Dimension dimension = minimumSize = FlatWindowResizer.this.honorMinimumSizeOnResize ? FlatWindowResizer.this.window.getMinimumSize() : null;
            if (minimumSize == null) {
                minimumSize = UIScale.scale(new Dimension(150, 50));
            }
            if (newBounds.width < minimumSize.width) {
                if (deltaX != 0) {
                    newBounds.x -= minimumSize.width - newBounds.width;
                }
                newBounds.width = minimumSize.width;
            }
            if (newBounds.height < minimumSize.height) {
                if (deltaY != 0) {
                    newBounds.y -= minimumSize.height - newBounds.height;
                }
                newBounds.height = minimumSize.height;
            }
            if (!newBounds.equals(this.dragStartWindowBounds)) {
                FlatWindowResizer.this.window.setBounds(newBounds);
                FlatWindowResizer.this.setBounds(0, 0, newBounds.width, newBounds.height);
                FlatWindowResizer.this.validate();
                if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                    FlatWindowResizer.this.window.validate();
                    FlatWindowResizer.this.rootPane.repaint();
                }
            }
        }
    }
}

