/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.api;

import com.formkiq.client.invoker.ApiCallback;
import com.formkiq.client.invoker.ApiClient;
import com.formkiq.client.invoker.ApiException;
import com.formkiq.client.invoker.ApiResponse;
import com.formkiq.client.invoker.Configuration;
import com.formkiq.client.invoker.Pair;
import com.formkiq.client.model.DeleteIndicesResponse;
import com.formkiq.client.model.IndexFolderMoveRequest;
import com.formkiq.client.model.IndexFolderMoveResponse;
import com.formkiq.client.model.IndexSearchRequest;
import com.formkiq.client.model.IndexSearchResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CustomIndexApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CustomIndexApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomIndexApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteIndexCall(String indexKey, String indexType, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/indices/{indexType}/{indexKey}".replace("{indexKey}", this.localVarApiClient.escapeString(indexKey.toString())).replace("{indexType}", this.localVarApiClient.escapeString(indexType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIndexValidateBeforeCall(String indexKey, String indexType, String siteId, ApiCallback _callback) throws ApiException {
        if (indexKey == null) {
            throw new ApiException("Missing the required parameter 'indexKey' when calling deleteIndex(Async)");
        }
        if (indexType == null) {
            throw new ApiException("Missing the required parameter 'indexType' when calling deleteIndex(Async)");
        }
        return this.deleteIndexCall(indexKey, indexType, siteId, _callback);
    }

    public DeleteIndicesResponse deleteIndex(String indexKey, String indexType, String siteId) throws ApiException {
        ApiResponse<DeleteIndicesResponse> localVarResp = this.deleteIndexWithHttpInfo(indexKey, indexType, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteIndicesResponse> deleteIndexWithHttpInfo(String indexKey, String indexType, String siteId) throws ApiException {
        Call localVarCall = this.deleteIndexValidateBeforeCall(indexKey, indexType, siteId, null);
        Type localVarReturnType = new TypeToken<DeleteIndicesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteIndexAsync(String indexKey, String indexType, String siteId, ApiCallback<DeleteIndicesResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteIndexValidateBeforeCall(indexKey, indexType, siteId, _callback);
        Type localVarReturnType = new TypeToken<DeleteIndicesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call indexFolderMoveCall(String indexType, IndexFolderMoveRequest indexFolderMoveRequest, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IndexFolderMoveRequest localVarPostBody = indexFolderMoveRequest;
        String localVarPath = "/indices/{indexType}/move".replace("{indexType}", this.localVarApiClient.escapeString(indexType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call indexFolderMoveValidateBeforeCall(String indexType, IndexFolderMoveRequest indexFolderMoveRequest, String siteId, ApiCallback _callback) throws ApiException {
        if (indexType == null) {
            throw new ApiException("Missing the required parameter 'indexType' when calling indexFolderMove(Async)");
        }
        if (indexFolderMoveRequest == null) {
            throw new ApiException("Missing the required parameter 'indexFolderMoveRequest' when calling indexFolderMove(Async)");
        }
        return this.indexFolderMoveCall(indexType, indexFolderMoveRequest, siteId, _callback);
    }

    public IndexFolderMoveResponse indexFolderMove(String indexType, IndexFolderMoveRequest indexFolderMoveRequest, String siteId) throws ApiException {
        ApiResponse<IndexFolderMoveResponse> localVarResp = this.indexFolderMoveWithHttpInfo(indexType, indexFolderMoveRequest, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<IndexFolderMoveResponse> indexFolderMoveWithHttpInfo(String indexType, IndexFolderMoveRequest indexFolderMoveRequest, String siteId) throws ApiException {
        Call localVarCall = this.indexFolderMoveValidateBeforeCall(indexType, indexFolderMoveRequest, siteId, null);
        Type localVarReturnType = new TypeToken<IndexFolderMoveResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call indexFolderMoveAsync(String indexType, IndexFolderMoveRequest indexFolderMoveRequest, String siteId, ApiCallback<IndexFolderMoveResponse> _callback) throws ApiException {
        Call localVarCall = this.indexFolderMoveValidateBeforeCall(indexType, indexFolderMoveRequest, siteId, _callback);
        Type localVarReturnType = new TypeToken<IndexFolderMoveResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call indexSearchCall(IndexSearchRequest indexSearchRequest, String siteId, String limit, String next, String previous, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IndexSearchRequest localVarPostBody = indexSearchRequest;
        String localVarPath = "/indices/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (next != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next", next));
        }
        if (previous != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("previous", previous));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call indexSearchValidateBeforeCall(IndexSearchRequest indexSearchRequest, String siteId, String limit, String next, String previous, ApiCallback _callback) throws ApiException {
        if (indexSearchRequest == null) {
            throw new ApiException("Missing the required parameter 'indexSearchRequest' when calling indexSearch(Async)");
        }
        return this.indexSearchCall(indexSearchRequest, siteId, limit, next, previous, _callback);
    }

    public IndexSearchResponse indexSearch(IndexSearchRequest indexSearchRequest, String siteId, String limit, String next, String previous) throws ApiException {
        ApiResponse<IndexSearchResponse> localVarResp = this.indexSearchWithHttpInfo(indexSearchRequest, siteId, limit, next, previous);
        return localVarResp.getData();
    }

    public ApiResponse<IndexSearchResponse> indexSearchWithHttpInfo(IndexSearchRequest indexSearchRequest, String siteId, String limit, String next, String previous) throws ApiException {
        Call localVarCall = this.indexSearchValidateBeforeCall(indexSearchRequest, siteId, limit, next, previous, null);
        Type localVarReturnType = new TypeToken<IndexSearchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call indexSearchAsync(IndexSearchRequest indexSearchRequest, String siteId, String limit, String next, String previous, ApiCallback<IndexSearchResponse> _callback) throws ApiException {
        Call localVarCall = this.indexSearchValidateBeforeCall(indexSearchRequest, siteId, limit, next, previous, _callback);
        Type localVarReturnType = new TypeToken<IndexSearchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

