/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.api;

import com.formkiq.client.invoker.ApiCallback;
import com.formkiq.client.invoker.ApiClient;
import com.formkiq.client.invoker.ApiException;
import com.formkiq.client.invoker.ApiResponse;
import com.formkiq.client.invoker.Configuration;
import com.formkiq.client.invoker.Pair;
import com.formkiq.client.model.AddDocumentAttributesRequest;
import com.formkiq.client.model.AddResponse;
import com.formkiq.client.model.DeleteResponse;
import com.formkiq.client.model.GetDocumentAttributeResponse;
import com.formkiq.client.model.GetDocumentAttributeVersionsResponse;
import com.formkiq.client.model.GetDocumentAttributesResponse;
import com.formkiq.client.model.SetDocumentAttributeRequest;
import com.formkiq.client.model.SetDocumentAttributesRequest;
import com.formkiq.client.model.SetResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class DocumentAttributesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DocumentAttributesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DocumentAttributesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addDocumentAttributesCall(String documentId, AddDocumentAttributesRequest addDocumentAttributesRequest, String siteId, String ws, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddDocumentAttributesRequest localVarPostBody = addDocumentAttributesRequest;
        String localVarPath = "/documents/{documentId}/attributes".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (ws != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ws", ws));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addDocumentAttributesValidateBeforeCall(String documentId, AddDocumentAttributesRequest addDocumentAttributesRequest, String siteId, String ws, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling addDocumentAttributes(Async)");
        }
        if (addDocumentAttributesRequest == null) {
            throw new ApiException("Missing the required parameter 'addDocumentAttributesRequest' when calling addDocumentAttributes(Async)");
        }
        return this.addDocumentAttributesCall(documentId, addDocumentAttributesRequest, siteId, ws, _callback);
    }

    public AddResponse addDocumentAttributes(String documentId, AddDocumentAttributesRequest addDocumentAttributesRequest, String siteId, String ws) throws ApiException {
        ApiResponse<AddResponse> localVarResp = this.addDocumentAttributesWithHttpInfo(documentId, addDocumentAttributesRequest, siteId, ws);
        return localVarResp.getData();
    }

    public ApiResponse<AddResponse> addDocumentAttributesWithHttpInfo(String documentId, AddDocumentAttributesRequest addDocumentAttributesRequest, String siteId, String ws) throws ApiException {
        Call localVarCall = this.addDocumentAttributesValidateBeforeCall(documentId, addDocumentAttributesRequest, siteId, ws, null);
        Type localVarReturnType = new TypeToken<AddResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addDocumentAttributesAsync(String documentId, AddDocumentAttributesRequest addDocumentAttributesRequest, String siteId, String ws, ApiCallback<AddResponse> _callback) throws ApiException {
        Call localVarCall = this.addDocumentAttributesValidateBeforeCall(documentId, addDocumentAttributesRequest, siteId, ws, _callback);
        Type localVarReturnType = new TypeToken<AddResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteDocumentAttributeCall(String documentId, String attributeKey, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/attributes/{attributeKey}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString())).replace("{attributeKey}", this.localVarApiClient.escapeString(attributeKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDocumentAttributeValidateBeforeCall(String documentId, String attributeKey, String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteDocumentAttribute(Async)");
        }
        if (attributeKey == null) {
            throw new ApiException("Missing the required parameter 'attributeKey' when calling deleteDocumentAttribute(Async)");
        }
        return this.deleteDocumentAttributeCall(documentId, attributeKey, siteId, _callback);
    }

    public DeleteResponse deleteDocumentAttribute(String documentId, String attributeKey, String siteId) throws ApiException {
        ApiResponse<DeleteResponse> localVarResp = this.deleteDocumentAttributeWithHttpInfo(documentId, attributeKey, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteResponse> deleteDocumentAttributeWithHttpInfo(String documentId, String attributeKey, String siteId) throws ApiException {
        Call localVarCall = this.deleteDocumentAttributeValidateBeforeCall(documentId, attributeKey, siteId, null);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteDocumentAttributeAsync(String documentId, String attributeKey, String siteId, ApiCallback<DeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteDocumentAttributeValidateBeforeCall(documentId, attributeKey, siteId, _callback);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteDocumentAttributeAndValueCall(String documentId, String attributeKey, String attributeValue, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/attributes/{attributeKey}/{attributeValue}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString())).replace("{attributeKey}", this.localVarApiClient.escapeString(attributeKey.toString())).replace("{attributeValue}", this.localVarApiClient.escapeString(attributeValue.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDocumentAttributeAndValueValidateBeforeCall(String documentId, String attributeKey, String attributeValue, String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteDocumentAttributeAndValue(Async)");
        }
        if (attributeKey == null) {
            throw new ApiException("Missing the required parameter 'attributeKey' when calling deleteDocumentAttributeAndValue(Async)");
        }
        if (attributeValue == null) {
            throw new ApiException("Missing the required parameter 'attributeValue' when calling deleteDocumentAttributeAndValue(Async)");
        }
        return this.deleteDocumentAttributeAndValueCall(documentId, attributeKey, attributeValue, siteId, _callback);
    }

    public DeleteResponse deleteDocumentAttributeAndValue(String documentId, String attributeKey, String attributeValue, String siteId) throws ApiException {
        ApiResponse<DeleteResponse> localVarResp = this.deleteDocumentAttributeAndValueWithHttpInfo(documentId, attributeKey, attributeValue, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteResponse> deleteDocumentAttributeAndValueWithHttpInfo(String documentId, String attributeKey, String attributeValue, String siteId) throws ApiException {
        Call localVarCall = this.deleteDocumentAttributeAndValueValidateBeforeCall(documentId, attributeKey, attributeValue, siteId, null);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteDocumentAttributeAndValueAsync(String documentId, String attributeKey, String attributeValue, String siteId, ApiCallback<DeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteDocumentAttributeAndValueValidateBeforeCall(documentId, attributeKey, attributeValue, siteId, _callback);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentAttributeCall(String documentId, String attributeKey, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/attributes/{attributeKey}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString())).replace("{attributeKey}", this.localVarApiClient.escapeString(attributeKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentAttributeValidateBeforeCall(String documentId, String attributeKey, String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentAttribute(Async)");
        }
        if (attributeKey == null) {
            throw new ApiException("Missing the required parameter 'attributeKey' when calling getDocumentAttribute(Async)");
        }
        return this.getDocumentAttributeCall(documentId, attributeKey, siteId, _callback);
    }

    public GetDocumentAttributeResponse getDocumentAttribute(String documentId, String attributeKey, String siteId) throws ApiException {
        ApiResponse<GetDocumentAttributeResponse> localVarResp = this.getDocumentAttributeWithHttpInfo(documentId, attributeKey, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentAttributeResponse> getDocumentAttributeWithHttpInfo(String documentId, String attributeKey, String siteId) throws ApiException {
        Call localVarCall = this.getDocumentAttributeValidateBeforeCall(documentId, attributeKey, siteId, null);
        Type localVarReturnType = new TypeToken<GetDocumentAttributeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentAttributeAsync(String documentId, String attributeKey, String siteId, ApiCallback<GetDocumentAttributeResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentAttributeValidateBeforeCall(documentId, attributeKey, siteId, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentAttributeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentAttributeVersionsCall(String documentId, String attributeKey, String siteId, String limit, String next, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/attributes/{attributeKey}/versions".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString())).replace("{attributeKey}", this.localVarApiClient.escapeString(attributeKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (next != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next", next));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentAttributeVersionsValidateBeforeCall(String documentId, String attributeKey, String siteId, String limit, String next, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentAttributeVersions(Async)");
        }
        if (attributeKey == null) {
            throw new ApiException("Missing the required parameter 'attributeKey' when calling getDocumentAttributeVersions(Async)");
        }
        return this.getDocumentAttributeVersionsCall(documentId, attributeKey, siteId, limit, next, _callback);
    }

    public GetDocumentAttributeVersionsResponse getDocumentAttributeVersions(String documentId, String attributeKey, String siteId, String limit, String next) throws ApiException {
        ApiResponse<GetDocumentAttributeVersionsResponse> localVarResp = this.getDocumentAttributeVersionsWithHttpInfo(documentId, attributeKey, siteId, limit, next);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentAttributeVersionsResponse> getDocumentAttributeVersionsWithHttpInfo(String documentId, String attributeKey, String siteId, String limit, String next) throws ApiException {
        Call localVarCall = this.getDocumentAttributeVersionsValidateBeforeCall(documentId, attributeKey, siteId, limit, next, null);
        Type localVarReturnType = new TypeToken<GetDocumentAttributeVersionsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentAttributeVersionsAsync(String documentId, String attributeKey, String siteId, String limit, String next, ApiCallback<GetDocumentAttributeVersionsResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentAttributeVersionsValidateBeforeCall(documentId, attributeKey, siteId, limit, next, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentAttributeVersionsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentAttributesCall(String documentId, String siteId, String limit, String next, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/attributes".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (next != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next", next));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentAttributesValidateBeforeCall(String documentId, String siteId, String limit, String next, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentAttributes(Async)");
        }
        return this.getDocumentAttributesCall(documentId, siteId, limit, next, _callback);
    }

    public GetDocumentAttributesResponse getDocumentAttributes(String documentId, String siteId, String limit, String next) throws ApiException {
        ApiResponse<GetDocumentAttributesResponse> localVarResp = this.getDocumentAttributesWithHttpInfo(documentId, siteId, limit, next);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentAttributesResponse> getDocumentAttributesWithHttpInfo(String documentId, String siteId, String limit, String next) throws ApiException {
        Call localVarCall = this.getDocumentAttributesValidateBeforeCall(documentId, siteId, limit, next, null);
        Type localVarReturnType = new TypeToken<GetDocumentAttributesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentAttributesAsync(String documentId, String siteId, String limit, String next, ApiCallback<GetDocumentAttributesResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentAttributesValidateBeforeCall(documentId, siteId, limit, next, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentAttributesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setDocumentAttributeValueCall(String documentId, String attributeKey, SetDocumentAttributeRequest setDocumentAttributeRequest, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SetDocumentAttributeRequest localVarPostBody = setDocumentAttributeRequest;
        String localVarPath = "/documents/{documentId}/attributes/{attributeKey}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString())).replace("{attributeKey}", this.localVarApiClient.escapeString(attributeKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setDocumentAttributeValueValidateBeforeCall(String documentId, String attributeKey, SetDocumentAttributeRequest setDocumentAttributeRequest, String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling setDocumentAttributeValue(Async)");
        }
        if (attributeKey == null) {
            throw new ApiException("Missing the required parameter 'attributeKey' when calling setDocumentAttributeValue(Async)");
        }
        if (setDocumentAttributeRequest == null) {
            throw new ApiException("Missing the required parameter 'setDocumentAttributeRequest' when calling setDocumentAttributeValue(Async)");
        }
        return this.setDocumentAttributeValueCall(documentId, attributeKey, setDocumentAttributeRequest, siteId, _callback);
    }

    public SetResponse setDocumentAttributeValue(String documentId, String attributeKey, SetDocumentAttributeRequest setDocumentAttributeRequest, String siteId) throws ApiException {
        ApiResponse<SetResponse> localVarResp = this.setDocumentAttributeValueWithHttpInfo(documentId, attributeKey, setDocumentAttributeRequest, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<SetResponse> setDocumentAttributeValueWithHttpInfo(String documentId, String attributeKey, SetDocumentAttributeRequest setDocumentAttributeRequest, String siteId) throws ApiException {
        Call localVarCall = this.setDocumentAttributeValueValidateBeforeCall(documentId, attributeKey, setDocumentAttributeRequest, siteId, null);
        Type localVarReturnType = new TypeToken<SetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setDocumentAttributeValueAsync(String documentId, String attributeKey, SetDocumentAttributeRequest setDocumentAttributeRequest, String siteId, ApiCallback<SetResponse> _callback) throws ApiException {
        Call localVarCall = this.setDocumentAttributeValueValidateBeforeCall(documentId, attributeKey, setDocumentAttributeRequest, siteId, _callback);
        Type localVarReturnType = new TypeToken<SetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setDocumentAttributesCall(String documentId, SetDocumentAttributesRequest setDocumentAttributesRequest, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SetDocumentAttributesRequest localVarPostBody = setDocumentAttributesRequest;
        String localVarPath = "/documents/{documentId}/attributes".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setDocumentAttributesValidateBeforeCall(String documentId, SetDocumentAttributesRequest setDocumentAttributesRequest, String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling setDocumentAttributes(Async)");
        }
        if (setDocumentAttributesRequest == null) {
            throw new ApiException("Missing the required parameter 'setDocumentAttributesRequest' when calling setDocumentAttributes(Async)");
        }
        return this.setDocumentAttributesCall(documentId, setDocumentAttributesRequest, siteId, _callback);
    }

    public SetResponse setDocumentAttributes(String documentId, SetDocumentAttributesRequest setDocumentAttributesRequest, String siteId) throws ApiException {
        ApiResponse<SetResponse> localVarResp = this.setDocumentAttributesWithHttpInfo(documentId, setDocumentAttributesRequest, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<SetResponse> setDocumentAttributesWithHttpInfo(String documentId, SetDocumentAttributesRequest setDocumentAttributesRequest, String siteId) throws ApiException {
        Call localVarCall = this.setDocumentAttributesValidateBeforeCall(documentId, setDocumentAttributesRequest, siteId, null);
        Type localVarReturnType = new TypeToken<SetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setDocumentAttributesAsync(String documentId, SetDocumentAttributesRequest setDocumentAttributesRequest, String siteId, ApiCallback<SetResponse> _callback) throws ApiException {
        Call localVarCall = this.setDocumentAttributesValidateBeforeCall(documentId, setDocumentAttributesRequest, siteId, _callback);
        Type localVarReturnType = new TypeToken<SetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

