/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.api;

import com.formkiq.client.invoker.ApiCallback;
import com.formkiq.client.invoker.ApiClient;
import com.formkiq.client.invoker.ApiException;
import com.formkiq.client.invoker.ApiResponse;
import com.formkiq.client.invoker.Configuration;
import com.formkiq.client.invoker.Pair;
import com.formkiq.client.model.AddFolderRequest;
import com.formkiq.client.model.AddFolderResponse;
import com.formkiq.client.model.DeleteFolderResponse;
import com.formkiq.client.model.GetFoldersResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class DocumentFoldersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DocumentFoldersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DocumentFoldersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addFolderCall(AddFolderRequest addFolderRequest, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddFolderRequest localVarPostBody = addFolderRequest;
        String localVarPath = "/folders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addFolderValidateBeforeCall(AddFolderRequest addFolderRequest, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        if (addFolderRequest == null) {
            throw new ApiException("Missing the required parameter 'addFolderRequest' when calling addFolder(Async)");
        }
        return this.addFolderCall(addFolderRequest, siteId, shareKey, _callback);
    }

    public AddFolderResponse addFolder(AddFolderRequest addFolderRequest, String siteId, String shareKey) throws ApiException {
        ApiResponse<AddFolderResponse> localVarResp = this.addFolderWithHttpInfo(addFolderRequest, siteId, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<AddFolderResponse> addFolderWithHttpInfo(AddFolderRequest addFolderRequest, String siteId, String shareKey) throws ApiException {
        Call localVarCall = this.addFolderValidateBeforeCall(addFolderRequest, siteId, shareKey, null);
        Type localVarReturnType = new TypeToken<AddFolderResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addFolderAsync(AddFolderRequest addFolderRequest, String siteId, String shareKey, ApiCallback<AddFolderResponse> _callback) throws ApiException {
        Call localVarCall = this.addFolderValidateBeforeCall(addFolderRequest, siteId, shareKey, _callback);
        Type localVarReturnType = new TypeToken<AddFolderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteFolderCall(String indexKey, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/folders/{indexKey}".replace("{indexKey}", this.localVarApiClient.escapeString(indexKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFolderValidateBeforeCall(String indexKey, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        if (indexKey == null) {
            throw new ApiException("Missing the required parameter 'indexKey' when calling deleteFolder(Async)");
        }
        return this.deleteFolderCall(indexKey, siteId, shareKey, _callback);
    }

    public DeleteFolderResponse deleteFolder(String indexKey, String siteId, String shareKey) throws ApiException {
        ApiResponse<DeleteFolderResponse> localVarResp = this.deleteFolderWithHttpInfo(indexKey, siteId, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteFolderResponse> deleteFolderWithHttpInfo(String indexKey, String siteId, String shareKey) throws ApiException {
        Call localVarCall = this.deleteFolderValidateBeforeCall(indexKey, siteId, shareKey, null);
        Type localVarReturnType = new TypeToken<DeleteFolderResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteFolderAsync(String indexKey, String siteId, String shareKey, ApiCallback<DeleteFolderResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteFolderValidateBeforeCall(indexKey, siteId, shareKey, _callback);
        Type localVarReturnType = new TypeToken<DeleteFolderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFolderDocumentsCall(String siteId, String indexKey, String path, String limit, String shareKey, String next, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/folders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (indexKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("indexKey", indexKey));
        }
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if (next != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next", next));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFolderDocumentsValidateBeforeCall(String siteId, String indexKey, String path, String limit, String shareKey, String next, ApiCallback _callback) throws ApiException {
        return this.getFolderDocumentsCall(siteId, indexKey, path, limit, shareKey, next, _callback);
    }

    public GetFoldersResponse getFolderDocuments(String siteId, String indexKey, String path, String limit, String shareKey, String next) throws ApiException {
        ApiResponse<GetFoldersResponse> localVarResp = this.getFolderDocumentsWithHttpInfo(siteId, indexKey, path, limit, shareKey, next);
        return localVarResp.getData();
    }

    public ApiResponse<GetFoldersResponse> getFolderDocumentsWithHttpInfo(String siteId, String indexKey, String path, String limit, String shareKey, String next) throws ApiException {
        Call localVarCall = this.getFolderDocumentsValidateBeforeCall(siteId, indexKey, path, limit, shareKey, next, null);
        Type localVarReturnType = new TypeToken<GetFoldersResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFolderDocumentsAsync(String siteId, String indexKey, String path, String limit, String shareKey, String next, ApiCallback<GetFoldersResponse> _callback) throws ApiException {
        Call localVarCall = this.getFolderDocumentsValidateBeforeCall(siteId, indexKey, path, limit, shareKey, next, _callback);
        Type localVarReturnType = new TypeToken<GetFoldersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

