/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.api;

import com.formkiq.client.invoker.ApiCallback;
import com.formkiq.client.invoker.ApiClient;
import com.formkiq.client.invoker.ApiException;
import com.formkiq.client.invoker.ApiResponse;
import com.formkiq.client.invoker.Configuration;
import com.formkiq.client.invoker.Pair;
import com.formkiq.client.model.DeleteResponse;
import com.formkiq.client.model.GetDocumentVersionsResponse;
import com.formkiq.client.model.SetDocumentVersionRequest;
import com.formkiq.client.model.SetDocumentVersionResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class DocumentVersionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DocumentVersionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DocumentVersionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteDocumentVersionCall(String documentId, String versionKey, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/versions/{versionKey}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString())).replace("{versionKey}", this.localVarApiClient.escapeString(versionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDocumentVersionValidateBeforeCall(String documentId, String versionKey, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteDocumentVersion(Async)");
        }
        if (versionKey == null) {
            throw new ApiException("Missing the required parameter 'versionKey' when calling deleteDocumentVersion(Async)");
        }
        return this.deleteDocumentVersionCall(documentId, versionKey, siteId, shareKey, _callback);
    }

    public DeleteResponse deleteDocumentVersion(String documentId, String versionKey, String siteId, String shareKey) throws ApiException {
        ApiResponse<DeleteResponse> localVarResp = this.deleteDocumentVersionWithHttpInfo(documentId, versionKey, siteId, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteResponse> deleteDocumentVersionWithHttpInfo(String documentId, String versionKey, String siteId, String shareKey) throws ApiException {
        Call localVarCall = this.deleteDocumentVersionValidateBeforeCall(documentId, versionKey, siteId, shareKey, null);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteDocumentVersionAsync(String documentId, String versionKey, String siteId, String shareKey, ApiCallback<DeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteDocumentVersionValidateBeforeCall(documentId, versionKey, siteId, shareKey, _callback);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentVersionsCall(String documentId, String siteId, String limit, String shareKey, String next, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/versions".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if (next != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next", next));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentVersionsValidateBeforeCall(String documentId, String siteId, String limit, String shareKey, String next, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentVersions(Async)");
        }
        return this.getDocumentVersionsCall(documentId, siteId, limit, shareKey, next, _callback);
    }

    public GetDocumentVersionsResponse getDocumentVersions(String documentId, String siteId, String limit, String shareKey, String next) throws ApiException {
        ApiResponse<GetDocumentVersionsResponse> localVarResp = this.getDocumentVersionsWithHttpInfo(documentId, siteId, limit, shareKey, next);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentVersionsResponse> getDocumentVersionsWithHttpInfo(String documentId, String siteId, String limit, String shareKey, String next) throws ApiException {
        Call localVarCall = this.getDocumentVersionsValidateBeforeCall(documentId, siteId, limit, shareKey, next, null);
        Type localVarReturnType = new TypeToken<GetDocumentVersionsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentVersionsAsync(String documentId, String siteId, String limit, String shareKey, String next, ApiCallback<GetDocumentVersionsResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentVersionsValidateBeforeCall(documentId, siteId, limit, shareKey, next, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentVersionsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setDocumentVersionCall(String documentId, SetDocumentVersionRequest setDocumentVersionRequest, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SetDocumentVersionRequest localVarPostBody = setDocumentVersionRequest;
        String localVarPath = "/documents/{documentId}/versions".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setDocumentVersionValidateBeforeCall(String documentId, SetDocumentVersionRequest setDocumentVersionRequest, String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling setDocumentVersion(Async)");
        }
        if (setDocumentVersionRequest == null) {
            throw new ApiException("Missing the required parameter 'setDocumentVersionRequest' when calling setDocumentVersion(Async)");
        }
        return this.setDocumentVersionCall(documentId, setDocumentVersionRequest, siteId, _callback);
    }

    public SetDocumentVersionResponse setDocumentVersion(String documentId, SetDocumentVersionRequest setDocumentVersionRequest, String siteId) throws ApiException {
        ApiResponse<SetDocumentVersionResponse> localVarResp = this.setDocumentVersionWithHttpInfo(documentId, setDocumentVersionRequest, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<SetDocumentVersionResponse> setDocumentVersionWithHttpInfo(String documentId, SetDocumentVersionRequest setDocumentVersionRequest, String siteId) throws ApiException {
        Call localVarCall = this.setDocumentVersionValidateBeforeCall(documentId, setDocumentVersionRequest, siteId, null);
        Type localVarReturnType = new TypeToken<SetDocumentVersionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setDocumentVersionAsync(String documentId, SetDocumentVersionRequest setDocumentVersionRequest, String siteId, ApiCallback<SetDocumentVersionResponse> _callback) throws ApiException {
        Call localVarCall = this.setDocumentVersionValidateBeforeCall(documentId, setDocumentVersionRequest, siteId, _callback);
        Type localVarReturnType = new TypeToken<SetDocumentVersionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

