/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.api;

import com.formkiq.client.invoker.ApiCallback;
import com.formkiq.client.invoker.ApiClient;
import com.formkiq.client.invoker.ApiException;
import com.formkiq.client.invoker.ApiResponse;
import com.formkiq.client.invoker.Configuration;
import com.formkiq.client.invoker.Pair;
import com.formkiq.client.model.AddDocumentRequest;
import com.formkiq.client.model.AddDocumentResponse;
import com.formkiq.client.model.AddDocumentUploadRequest;
import com.formkiq.client.model.DeleteResponse;
import com.formkiq.client.model.DocumentsCompressRequest;
import com.formkiq.client.model.DocumentsCompressResponse;
import com.formkiq.client.model.GetDocumentContentResponse;
import com.formkiq.client.model.GetDocumentResponse;
import com.formkiq.client.model.GetDocumentSyncResponse;
import com.formkiq.client.model.GetDocumentUrlResponse;
import com.formkiq.client.model.GetDocumentsResponse;
import com.formkiq.client.model.SetDocumentRestoreResponse;
import com.formkiq.client.model.UpdateDocumentRequest;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class DocumentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DocumentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addDocumentCall(AddDocumentRequest addDocumentRequest, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddDocumentRequest localVarPostBody = addDocumentRequest;
        String localVarPath = "/documents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addDocumentValidateBeforeCall(AddDocumentRequest addDocumentRequest, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        if (addDocumentRequest == null) {
            throw new ApiException("Missing the required parameter 'addDocumentRequest' when calling addDocument(Async)");
        }
        return this.addDocumentCall(addDocumentRequest, siteId, shareKey, _callback);
    }

    public AddDocumentResponse addDocument(AddDocumentRequest addDocumentRequest, String siteId, String shareKey) throws ApiException {
        ApiResponse<AddDocumentResponse> localVarResp = this.addDocumentWithHttpInfo(addDocumentRequest, siteId, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<AddDocumentResponse> addDocumentWithHttpInfo(AddDocumentRequest addDocumentRequest, String siteId, String shareKey) throws ApiException {
        Call localVarCall = this.addDocumentValidateBeforeCall(addDocumentRequest, siteId, shareKey, null);
        Type localVarReturnType = new TypeToken<AddDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addDocumentAsync(AddDocumentRequest addDocumentRequest, String siteId, String shareKey, ApiCallback<AddDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.addDocumentValidateBeforeCall(addDocumentRequest, siteId, shareKey, _callback);
        Type localVarReturnType = new TypeToken<AddDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call addDocumentUploadCall(AddDocumentUploadRequest addDocumentUploadRequest, String siteId, Integer contentLength, Integer duration, String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddDocumentUploadRequest localVarPostBody = addDocumentUploadRequest;
        String localVarPath = "/documents/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (contentLength != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contentLength", contentLength));
        }
        if (duration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("duration", duration));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addDocumentUploadValidateBeforeCall(AddDocumentUploadRequest addDocumentUploadRequest, String siteId, Integer contentLength, Integer duration, String shareKey, ApiCallback _callback) throws ApiException {
        if (addDocumentUploadRequest == null) {
            throw new ApiException("Missing the required parameter 'addDocumentUploadRequest' when calling addDocumentUpload(Async)");
        }
        return this.addDocumentUploadCall(addDocumentUploadRequest, siteId, contentLength, duration, shareKey, _callback);
    }

    public GetDocumentUrlResponse addDocumentUpload(AddDocumentUploadRequest addDocumentUploadRequest, String siteId, Integer contentLength, Integer duration, String shareKey) throws ApiException {
        ApiResponse<GetDocumentUrlResponse> localVarResp = this.addDocumentUploadWithHttpInfo(addDocumentUploadRequest, siteId, contentLength, duration, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentUrlResponse> addDocumentUploadWithHttpInfo(AddDocumentUploadRequest addDocumentUploadRequest, String siteId, Integer contentLength, Integer duration, String shareKey) throws ApiException {
        Call localVarCall = this.addDocumentUploadValidateBeforeCall(addDocumentUploadRequest, siteId, contentLength, duration, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addDocumentUploadAsync(AddDocumentUploadRequest addDocumentUploadRequest, String siteId, Integer contentLength, Integer duration, String shareKey, ApiCallback<GetDocumentUrlResponse> _callback) throws ApiException {
        Call localVarCall = this.addDocumentUploadValidateBeforeCall(addDocumentUploadRequest, siteId, contentLength, duration, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call compressDocumentsCall(DocumentsCompressRequest documentsCompressRequest, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        DocumentsCompressRequest localVarPostBody = documentsCompressRequest;
        String localVarPath = "/documents/compress";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call compressDocumentsValidateBeforeCall(DocumentsCompressRequest documentsCompressRequest, String siteId, ApiCallback _callback) throws ApiException {
        if (documentsCompressRequest == null) {
            throw new ApiException("Missing the required parameter 'documentsCompressRequest' when calling compressDocuments(Async)");
        }
        return this.compressDocumentsCall(documentsCompressRequest, siteId, _callback);
    }

    public DocumentsCompressResponse compressDocuments(DocumentsCompressRequest documentsCompressRequest, String siteId) throws ApiException {
        ApiResponse<DocumentsCompressResponse> localVarResp = this.compressDocumentsWithHttpInfo(documentsCompressRequest, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentsCompressResponse> compressDocumentsWithHttpInfo(DocumentsCompressRequest documentsCompressRequest, String siteId) throws ApiException {
        Call localVarCall = this.compressDocumentsValidateBeforeCall(documentsCompressRequest, siteId, null);
        Type localVarReturnType = new TypeToken<DocumentsCompressResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call compressDocumentsAsync(DocumentsCompressRequest documentsCompressRequest, String siteId, ApiCallback<DocumentsCompressResponse> _callback) throws ApiException {
        Call localVarCall = this.compressDocumentsValidateBeforeCall(documentsCompressRequest, siteId, _callback);
        Type localVarReturnType = new TypeToken<DocumentsCompressResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteDocumentCall(String documentId, String siteId, Boolean softDelete, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (softDelete != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("softDelete", softDelete));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDocumentValidateBeforeCall(String documentId, String siteId, Boolean softDelete, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteDocument(Async)");
        }
        return this.deleteDocumentCall(documentId, siteId, softDelete, _callback);
    }

    public DeleteResponse deleteDocument(String documentId, String siteId, Boolean softDelete) throws ApiException {
        ApiResponse<DeleteResponse> localVarResp = this.deleteDocumentWithHttpInfo(documentId, siteId, softDelete);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteResponse> deleteDocumentWithHttpInfo(String documentId, String siteId, Boolean softDelete) throws ApiException {
        Call localVarCall = this.deleteDocumentValidateBeforeCall(documentId, siteId, softDelete, null);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteDocumentAsync(String documentId, String siteId, Boolean softDelete, ApiCallback<DeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteDocumentValidateBeforeCall(documentId, siteId, softDelete, _callback);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deletePublishedDocumentContentCall(String documentId, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/publications/{documentId}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePublishedDocumentContentValidateBeforeCall(String documentId, String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deletePublishedDocumentContent(Async)");
        }
        return this.deletePublishedDocumentContentCall(documentId, siteId, _callback);
    }

    public DeleteResponse deletePublishedDocumentContent(String documentId, String siteId) throws ApiException {
        ApiResponse<DeleteResponse> localVarResp = this.deletePublishedDocumentContentWithHttpInfo(documentId, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteResponse> deletePublishedDocumentContentWithHttpInfo(String documentId, String siteId) throws ApiException {
        Call localVarCall = this.deletePublishedDocumentContentValidateBeforeCall(documentId, siteId, null);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deletePublishedDocumentContentAsync(String documentId, String siteId, ApiCallback<DeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deletePublishedDocumentContentValidateBeforeCall(documentId, siteId, _callback);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentCall(String documentId, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentValidateBeforeCall(String documentId, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocument(Async)");
        }
        return this.getDocumentCall(documentId, siteId, shareKey, _callback);
    }

    public GetDocumentResponse getDocument(String documentId, String siteId, String shareKey) throws ApiException {
        ApiResponse<GetDocumentResponse> localVarResp = this.getDocumentWithHttpInfo(documentId, siteId, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentResponse> getDocumentWithHttpInfo(String documentId, String siteId, String shareKey) throws ApiException {
        Call localVarCall = this.getDocumentValidateBeforeCall(documentId, siteId, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentAsync(String documentId, String siteId, String shareKey, ApiCallback<GetDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentValidateBeforeCall(documentId, siteId, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentContentCall(String documentId, String siteId, String versionKey, String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/content".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (versionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionKey", versionKey));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentContentValidateBeforeCall(String documentId, String siteId, String versionKey, String shareKey, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentContent(Async)");
        }
        return this.getDocumentContentCall(documentId, siteId, versionKey, shareKey, _callback);
    }

    public GetDocumentContentResponse getDocumentContent(String documentId, String siteId, String versionKey, String shareKey) throws ApiException {
        ApiResponse<GetDocumentContentResponse> localVarResp = this.getDocumentContentWithHttpInfo(documentId, siteId, versionKey, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentContentResponse> getDocumentContentWithHttpInfo(String documentId, String siteId, String versionKey, String shareKey) throws ApiException {
        Call localVarCall = this.getDocumentContentValidateBeforeCall(documentId, siteId, versionKey, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentContentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentContentAsync(String documentId, String siteId, String versionKey, String shareKey, ApiCallback<GetDocumentContentResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentContentValidateBeforeCall(documentId, siteId, versionKey, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentContentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentIdUploadCall(String documentId, String siteId, String checksumType, String checksum, Integer contentLength, Integer duration, String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/upload".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (checksumType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checksumType", checksumType));
        }
        if (checksum != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checksum", checksum));
        }
        if (contentLength != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contentLength", contentLength));
        }
        if (duration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("duration", duration));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentIdUploadValidateBeforeCall(String documentId, String siteId, String checksumType, String checksum, Integer contentLength, Integer duration, String shareKey, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentIdUpload(Async)");
        }
        return this.getDocumentIdUploadCall(documentId, siteId, checksumType, checksum, contentLength, duration, shareKey, _callback);
    }

    public GetDocumentUrlResponse getDocumentIdUpload(String documentId, String siteId, String checksumType, String checksum, Integer contentLength, Integer duration, String shareKey) throws ApiException {
        ApiResponse<GetDocumentUrlResponse> localVarResp = this.getDocumentIdUploadWithHttpInfo(documentId, siteId, checksumType, checksum, contentLength, duration, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentUrlResponse> getDocumentIdUploadWithHttpInfo(String documentId, String siteId, String checksumType, String checksum, Integer contentLength, Integer duration, String shareKey) throws ApiException {
        Call localVarCall = this.getDocumentIdUploadValidateBeforeCall(documentId, siteId, checksumType, checksum, contentLength, duration, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentIdUploadAsync(String documentId, String siteId, String checksumType, String checksum, Integer contentLength, Integer duration, String shareKey, ApiCallback<GetDocumentUrlResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentIdUploadValidateBeforeCall(documentId, siteId, checksumType, checksum, contentLength, duration, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentSyncsCall(String documentId, String siteId, String limit, String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/syncs".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentSyncsValidateBeforeCall(String documentId, String siteId, String limit, String shareKey, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentSyncs(Async)");
        }
        return this.getDocumentSyncsCall(documentId, siteId, limit, shareKey, _callback);
    }

    public GetDocumentSyncResponse getDocumentSyncs(String documentId, String siteId, String limit, String shareKey) throws ApiException {
        ApiResponse<GetDocumentSyncResponse> localVarResp = this.getDocumentSyncsWithHttpInfo(documentId, siteId, limit, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentSyncResponse> getDocumentSyncsWithHttpInfo(String documentId, String siteId, String limit, String shareKey) throws ApiException {
        Call localVarCall = this.getDocumentSyncsValidateBeforeCall(documentId, siteId, limit, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentSyncResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentSyncsAsync(String documentId, String siteId, String limit, String shareKey, ApiCallback<GetDocumentSyncResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentSyncsValidateBeforeCall(documentId, siteId, limit, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentSyncResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentUploadCall(String path, String siteId, String checksumType, String checksum, Integer contentLength, Integer duration, String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (checksumType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checksumType", checksumType));
        }
        if (checksum != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checksum", checksum));
        }
        if (contentLength != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contentLength", contentLength));
        }
        if (duration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("duration", duration));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentUploadValidateBeforeCall(String path, String siteId, String checksumType, String checksum, Integer contentLength, Integer duration, String shareKey, ApiCallback _callback) throws ApiException {
        return this.getDocumentUploadCall(path, siteId, checksumType, checksum, contentLength, duration, shareKey, _callback);
    }

    public GetDocumentUrlResponse getDocumentUpload(String path, String siteId, String checksumType, String checksum, Integer contentLength, Integer duration, String shareKey) throws ApiException {
        ApiResponse<GetDocumentUrlResponse> localVarResp = this.getDocumentUploadWithHttpInfo(path, siteId, checksumType, checksum, contentLength, duration, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentUrlResponse> getDocumentUploadWithHttpInfo(String path, String siteId, String checksumType, String checksum, Integer contentLength, Integer duration, String shareKey) throws ApiException {
        Call localVarCall = this.getDocumentUploadValidateBeforeCall(path, siteId, checksumType, checksum, contentLength, duration, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentUploadAsync(String path, String siteId, String checksumType, String checksum, Integer contentLength, Integer duration, String shareKey, ApiCallback<GetDocumentUrlResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentUploadValidateBeforeCall(path, siteId, checksumType, checksum, contentLength, duration, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentUrlCall(String documentId, String siteId, String versionKey, Integer duration, String shareKey, Boolean inline, Boolean bypassWatermark, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/url".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (versionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionKey", versionKey));
        }
        if (duration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("duration", duration));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if (inline != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("inline", inline));
        }
        if (bypassWatermark != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bypassWatermark", bypassWatermark));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentUrlValidateBeforeCall(String documentId, String siteId, String versionKey, Integer duration, String shareKey, Boolean inline, Boolean bypassWatermark, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentUrl(Async)");
        }
        return this.getDocumentUrlCall(documentId, siteId, versionKey, duration, shareKey, inline, bypassWatermark, _callback);
    }

    public GetDocumentUrlResponse getDocumentUrl(String documentId, String siteId, String versionKey, Integer duration, String shareKey, Boolean inline, Boolean bypassWatermark) throws ApiException {
        ApiResponse<GetDocumentUrlResponse> localVarResp = this.getDocumentUrlWithHttpInfo(documentId, siteId, versionKey, duration, shareKey, inline, bypassWatermark);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentUrlResponse> getDocumentUrlWithHttpInfo(String documentId, String siteId, String versionKey, Integer duration, String shareKey, Boolean inline, Boolean bypassWatermark) throws ApiException {
        Call localVarCall = this.getDocumentUrlValidateBeforeCall(documentId, siteId, versionKey, duration, shareKey, inline, bypassWatermark, null);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentUrlAsync(String documentId, String siteId, String versionKey, Integer duration, String shareKey, Boolean inline, Boolean bypassWatermark, ApiCallback<GetDocumentUrlResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentUrlValidateBeforeCall(documentId, siteId, versionKey, duration, shareKey, inline, bypassWatermark, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentsCall(String siteId, String actionStatus, Boolean deleted, String date, String tz, String next, String previous, String limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (actionStatus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("actionStatus", actionStatus));
        }
        if (deleted != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deleted", deleted));
        }
        if (date != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date", date));
        }
        if (tz != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tz", tz));
        }
        if (next != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next", next));
        }
        if (previous != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("previous", previous));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentsValidateBeforeCall(String siteId, String actionStatus, Boolean deleted, String date, String tz, String next, String previous, String limit, ApiCallback _callback) throws ApiException {
        return this.getDocumentsCall(siteId, actionStatus, deleted, date, tz, next, previous, limit, _callback);
    }

    public GetDocumentsResponse getDocuments(String siteId, String actionStatus, Boolean deleted, String date, String tz, String next, String previous, String limit) throws ApiException {
        ApiResponse<GetDocumentsResponse> localVarResp = this.getDocumentsWithHttpInfo(siteId, actionStatus, deleted, date, tz, next, previous, limit);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentsResponse> getDocumentsWithHttpInfo(String siteId, String actionStatus, Boolean deleted, String date, String tz, String next, String previous, String limit) throws ApiException {
        Call localVarCall = this.getDocumentsValidateBeforeCall(siteId, actionStatus, deleted, date, tz, next, previous, limit, null);
        Type localVarReturnType = new TypeToken<GetDocumentsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentsAsync(String siteId, String actionStatus, Boolean deleted, String date, String tz, String next, String previous, String limit, ApiCallback<GetDocumentsResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentsValidateBeforeCall(siteId, actionStatus, deleted, date, tz, next, previous, limit, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPublishedDocumentContentCall(String documentId, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/publications/{documentId}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPublishedDocumentContentValidateBeforeCall(String documentId, String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getPublishedDocumentContent(Async)");
        }
        return this.getPublishedDocumentContentCall(documentId, siteId, _callback);
    }

    public void getPublishedDocumentContent(String documentId, String siteId) throws ApiException {
        this.getPublishedDocumentContentWithHttpInfo(documentId, siteId);
    }

    public ApiResponse<Void> getPublishedDocumentContentWithHttpInfo(String documentId, String siteId) throws ApiException {
        Call localVarCall = this.getPublishedDocumentContentValidateBeforeCall(documentId, siteId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call getPublishedDocumentContentAsync(String documentId, String siteId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getPublishedDocumentContentValidateBeforeCall(documentId, siteId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call purgeDocumentCall(String documentId, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/purge".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call purgeDocumentValidateBeforeCall(String documentId, String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling purgeDocument(Async)");
        }
        return this.purgeDocumentCall(documentId, siteId, _callback);
    }

    public DeleteResponse purgeDocument(String documentId, String siteId) throws ApiException {
        ApiResponse<DeleteResponse> localVarResp = this.purgeDocumentWithHttpInfo(documentId, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteResponse> purgeDocumentWithHttpInfo(String documentId, String siteId) throws ApiException {
        Call localVarCall = this.purgeDocumentValidateBeforeCall(documentId, siteId, null);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call purgeDocumentAsync(String documentId, String siteId, ApiCallback<DeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.purgeDocumentValidateBeforeCall(documentId, siteId, _callback);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setDocumentRestoreCall(String documentId, String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/restore".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setDocumentRestoreValidateBeforeCall(String documentId, String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling setDocumentRestore(Async)");
        }
        return this.setDocumentRestoreCall(documentId, siteId, _callback);
    }

    public SetDocumentRestoreResponse setDocumentRestore(String documentId, String siteId) throws ApiException {
        ApiResponse<SetDocumentRestoreResponse> localVarResp = this.setDocumentRestoreWithHttpInfo(documentId, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<SetDocumentRestoreResponse> setDocumentRestoreWithHttpInfo(String documentId, String siteId) throws ApiException {
        Call localVarCall = this.setDocumentRestoreValidateBeforeCall(documentId, siteId, null);
        Type localVarReturnType = new TypeToken<SetDocumentRestoreResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setDocumentRestoreAsync(String documentId, String siteId, ApiCallback<SetDocumentRestoreResponse> _callback) throws ApiException {
        Call localVarCall = this.setDocumentRestoreValidateBeforeCall(documentId, siteId, _callback);
        Type localVarReturnType = new TypeToken<SetDocumentRestoreResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateDocumentCall(String documentId, UpdateDocumentRequest updateDocumentRequest, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateDocumentRequest localVarPostBody = updateDocumentRequest;
        String localVarPath = "/documents/{documentId}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDocumentValidateBeforeCall(String documentId, UpdateDocumentRequest updateDocumentRequest, String siteId, String shareKey, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling updateDocument(Async)");
        }
        if (updateDocumentRequest == null) {
            throw new ApiException("Missing the required parameter 'updateDocumentRequest' when calling updateDocument(Async)");
        }
        return this.updateDocumentCall(documentId, updateDocumentRequest, siteId, shareKey, _callback);
    }

    public AddDocumentResponse updateDocument(String documentId, UpdateDocumentRequest updateDocumentRequest, String siteId, String shareKey) throws ApiException {
        ApiResponse<AddDocumentResponse> localVarResp = this.updateDocumentWithHttpInfo(documentId, updateDocumentRequest, siteId, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<AddDocumentResponse> updateDocumentWithHttpInfo(String documentId, UpdateDocumentRequest updateDocumentRequest, String siteId, String shareKey) throws ApiException {
        Call localVarCall = this.updateDocumentValidateBeforeCall(documentId, updateDocumentRequest, siteId, shareKey, null);
        Type localVarReturnType = new TypeToken<AddDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateDocumentAsync(String documentId, UpdateDocumentRequest updateDocumentRequest, String siteId, String shareKey, ApiCallback<AddDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.updateDocumentValidateBeforeCall(documentId, updateDocumentRequest, siteId, shareKey, _callback);
        Type localVarReturnType = new TypeToken<AddDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

