/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum CaseStatus {
    NEW("NEW"),
    ASSIGNED("ASSIGNED"),
    IN_PROGRESS("IN_PROGRESS"),
    ON_HOLD("ON_HOLD"),
    ESCALATED("ESCALATED"),
    RESOLVED("RESOLVED"),
    CLOSED("CLOSED"),
    UNDER_REVIEW("UNDER_REVIEW"),
    AWAITING_CLIENT_RESPONSE("AWAITING_CLIENT_RESPONSE");

    private String value;

    private CaseStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CaseStatus fromValue(String value) {
        for (CaseStatus b : CaseStatus.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        CaseStatus.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<CaseStatus> {
        public void write(JsonWriter jsonWriter, CaseStatus enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public CaseStatus read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return CaseStatus.fromValue(value);
        }
    }
}

