/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.model;

import com.formkiq.client.invoker.JSON;
import com.formkiq.client.model.DocumentFulltextSearch;
import com.formkiq.client.model.SearchResponseFields;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentFulltextRequest {
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    @Nonnull
    private DocumentFulltextSearch query;
    public static final String SERIALIZED_NAME_RESPONSE_FIELDS = "responseFields";
    @SerializedName(value="responseFields")
    @Nullable
    private SearchResponseFields responseFields;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public DocumentFulltextRequest query(@Nonnull DocumentFulltextSearch query) {
        this.query = query;
        return this;
    }

    @Nonnull
    public DocumentFulltextSearch getQuery() {
        return this.query;
    }

    public void setQuery(@Nonnull DocumentFulltextSearch query) {
        this.query = query;
    }

    public DocumentFulltextRequest responseFields(@Nullable SearchResponseFields responseFields) {
        this.responseFields = responseFields;
        return this;
    }

    @Nullable
    public SearchResponseFields getResponseFields() {
        return this.responseFields;
    }

    public void setResponseFields(@Nullable SearchResponseFields responseFields) {
        this.responseFields = responseFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFulltextRequest documentFulltextRequest = (DocumentFulltextRequest)o;
        return Objects.equals(this.query, documentFulltextRequest.query) && Objects.equals(this.responseFields, documentFulltextRequest.responseFields);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.responseFields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentFulltextRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    responseFields: ").append(this.toIndentedString(this.responseFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in DocumentFulltextRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DocumentFulltextRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        DocumentFulltextSearch.validateJsonElement(jsonObj.get(SERIALIZED_NAME_QUERY));
        if (jsonObj.get(SERIALIZED_NAME_RESPONSE_FIELDS) != null && !jsonObj.get(SERIALIZED_NAME_RESPONSE_FIELDS).isJsonNull()) {
            SearchResponseFields.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESPONSE_FIELDS));
        }
    }

    public static DocumentFulltextRequest fromJson(String jsonString) throws IOException {
        return (DocumentFulltextRequest)JSON.getGson().fromJson(jsonString, DocumentFulltextRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_QUERY);
        openapiFields.add(SERIALIZED_NAME_RESPONSE_FIELDS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_QUERY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DocumentFulltextRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DocumentFulltextRequest.class));
            return new TypeAdapter<DocumentFulltextRequest>(){

                public void write(JsonWriter out, DocumentFulltextRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DocumentFulltextRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    DocumentFulltextRequest.validateJsonElement(jsonElement);
                    return (DocumentFulltextRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

