/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.api;

import com.formkiq.client.invoker.ApiCallback;
import com.formkiq.client.invoker.ApiClient;
import com.formkiq.client.invoker.ApiException;
import com.formkiq.client.invoker.ApiResponse;
import com.formkiq.client.invoker.Configuration;
import com.formkiq.client.invoker.Pair;
import com.formkiq.client.model.AddDocumentAttributesRequest;
import com.formkiq.client.model.AddResponse;
import com.formkiq.client.model.DeleteResponse;
import com.formkiq.client.model.GetDocumentAttributeResponse;
import com.formkiq.client.model.GetDocumentAttributeVersionsResponse;
import com.formkiq.client.model.GetDocumentAttributesResponse;
import com.formkiq.client.model.SetDocumentAttributeRequest;
import com.formkiq.client.model.SetDocumentAttributesRequest;
import com.formkiq.client.model.SetResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class DocumentAttributesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DocumentAttributesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DocumentAttributesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addDocumentAttributesCall(@Nonnull String documentId, @Nonnull AddDocumentAttributesRequest addDocumentAttributesRequest, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddDocumentAttributesRequest localVarPostBody = addDocumentAttributesRequest;
        String localVarPath = "/documents/{documentId}/attributes".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addDocumentAttributesValidateBeforeCall(@Nonnull String documentId, @Nonnull AddDocumentAttributesRequest addDocumentAttributesRequest, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling addDocumentAttributes(Async)");
        }
        if (addDocumentAttributesRequest == null) {
            throw new ApiException("Missing the required parameter 'addDocumentAttributesRequest' when calling addDocumentAttributes(Async)");
        }
        return this.addDocumentAttributesCall(documentId, addDocumentAttributesRequest, siteId, _callback);
    }

    public AddResponse addDocumentAttributes(@Nonnull String documentId, @Nonnull AddDocumentAttributesRequest addDocumentAttributesRequest, @Nullable String siteId) throws ApiException {
        ApiResponse<AddResponse> localVarResp = this.addDocumentAttributesWithHttpInfo(documentId, addDocumentAttributesRequest, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<AddResponse> addDocumentAttributesWithHttpInfo(@Nonnull String documentId, @Nonnull AddDocumentAttributesRequest addDocumentAttributesRequest, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.addDocumentAttributesValidateBeforeCall(documentId, addDocumentAttributesRequest, siteId, null);
        Type localVarReturnType = new TypeToken<AddResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addDocumentAttributesAsync(@Nonnull String documentId, @Nonnull AddDocumentAttributesRequest addDocumentAttributesRequest, @Nullable String siteId, ApiCallback<AddResponse> _callback) throws ApiException {
        Call localVarCall = this.addDocumentAttributesValidateBeforeCall(documentId, addDocumentAttributesRequest, siteId, _callback);
        Type localVarReturnType = new TypeToken<AddResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteDocumentAttributeCall(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/attributes/{attributeKey}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString())).replace("{attributeKey}", this.localVarApiClient.escapeString(attributeKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDocumentAttributeValidateBeforeCall(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteDocumentAttribute(Async)");
        }
        if (attributeKey == null) {
            throw new ApiException("Missing the required parameter 'attributeKey' when calling deleteDocumentAttribute(Async)");
        }
        return this.deleteDocumentAttributeCall(documentId, attributeKey, siteId, _callback);
    }

    public DeleteResponse deleteDocumentAttribute(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId) throws ApiException {
        ApiResponse<DeleteResponse> localVarResp = this.deleteDocumentAttributeWithHttpInfo(documentId, attributeKey, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteResponse> deleteDocumentAttributeWithHttpInfo(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.deleteDocumentAttributeValidateBeforeCall(documentId, attributeKey, siteId, null);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteDocumentAttributeAsync(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId, ApiCallback<DeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteDocumentAttributeValidateBeforeCall(documentId, attributeKey, siteId, _callback);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteDocumentAttributeAndValueCall(@Nonnull String documentId, @Nonnull String attributeKey, @Nonnull String attributeValue, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/attributes/{attributeKey}/{attributeValue}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString())).replace("{attributeKey}", this.localVarApiClient.escapeString(attributeKey.toString())).replace("{attributeValue}", this.localVarApiClient.escapeString(attributeValue.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDocumentAttributeAndValueValidateBeforeCall(@Nonnull String documentId, @Nonnull String attributeKey, @Nonnull String attributeValue, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteDocumentAttributeAndValue(Async)");
        }
        if (attributeKey == null) {
            throw new ApiException("Missing the required parameter 'attributeKey' when calling deleteDocumentAttributeAndValue(Async)");
        }
        if (attributeValue == null) {
            throw new ApiException("Missing the required parameter 'attributeValue' when calling deleteDocumentAttributeAndValue(Async)");
        }
        return this.deleteDocumentAttributeAndValueCall(documentId, attributeKey, attributeValue, siteId, _callback);
    }

    public DeleteResponse deleteDocumentAttributeAndValue(@Nonnull String documentId, @Nonnull String attributeKey, @Nonnull String attributeValue, @Nullable String siteId) throws ApiException {
        ApiResponse<DeleteResponse> localVarResp = this.deleteDocumentAttributeAndValueWithHttpInfo(documentId, attributeKey, attributeValue, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteResponse> deleteDocumentAttributeAndValueWithHttpInfo(@Nonnull String documentId, @Nonnull String attributeKey, @Nonnull String attributeValue, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.deleteDocumentAttributeAndValueValidateBeforeCall(documentId, attributeKey, attributeValue, siteId, null);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteDocumentAttributeAndValueAsync(@Nonnull String documentId, @Nonnull String attributeKey, @Nonnull String attributeValue, @Nullable String siteId, ApiCallback<DeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteDocumentAttributeAndValueValidateBeforeCall(documentId, attributeKey, attributeValue, siteId, _callback);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentAttributeCall(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/attributes/{attributeKey}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString())).replace("{attributeKey}", this.localVarApiClient.escapeString(attributeKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentAttributeValidateBeforeCall(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentAttribute(Async)");
        }
        if (attributeKey == null) {
            throw new ApiException("Missing the required parameter 'attributeKey' when calling getDocumentAttribute(Async)");
        }
        return this.getDocumentAttributeCall(documentId, attributeKey, siteId, _callback);
    }

    public GetDocumentAttributeResponse getDocumentAttribute(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId) throws ApiException {
        ApiResponse<GetDocumentAttributeResponse> localVarResp = this.getDocumentAttributeWithHttpInfo(documentId, attributeKey, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentAttributeResponse> getDocumentAttributeWithHttpInfo(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.getDocumentAttributeValidateBeforeCall(documentId, attributeKey, siteId, null);
        Type localVarReturnType = new TypeToken<GetDocumentAttributeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentAttributeAsync(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId, ApiCallback<GetDocumentAttributeResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentAttributeValidateBeforeCall(documentId, attributeKey, siteId, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentAttributeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentAttributeVersionsCall(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId, @Nullable String limit, @Nullable String next, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/attributes/{attributeKey}/versions".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString())).replace("{attributeKey}", this.localVarApiClient.escapeString(attributeKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (next != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next", next));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentAttributeVersionsValidateBeforeCall(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId, @Nullable String limit, @Nullable String next, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentAttributeVersions(Async)");
        }
        if (attributeKey == null) {
            throw new ApiException("Missing the required parameter 'attributeKey' when calling getDocumentAttributeVersions(Async)");
        }
        return this.getDocumentAttributeVersionsCall(documentId, attributeKey, siteId, limit, next, _callback);
    }

    public GetDocumentAttributeVersionsResponse getDocumentAttributeVersions(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId, @Nullable String limit, @Nullable String next) throws ApiException {
        ApiResponse<GetDocumentAttributeVersionsResponse> localVarResp = this.getDocumentAttributeVersionsWithHttpInfo(documentId, attributeKey, siteId, limit, next);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentAttributeVersionsResponse> getDocumentAttributeVersionsWithHttpInfo(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId, @Nullable String limit, @Nullable String next) throws ApiException {
        Call localVarCall = this.getDocumentAttributeVersionsValidateBeforeCall(documentId, attributeKey, siteId, limit, next, null);
        Type localVarReturnType = new TypeToken<GetDocumentAttributeVersionsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentAttributeVersionsAsync(@Nonnull String documentId, @Nonnull String attributeKey, @Nullable String siteId, @Nullable String limit, @Nullable String next, ApiCallback<GetDocumentAttributeVersionsResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentAttributeVersionsValidateBeforeCall(documentId, attributeKey, siteId, limit, next, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentAttributeVersionsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentAttributesCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String limit, @Nullable String next, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/attributes".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (next != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next", next));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentAttributesValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String limit, @Nullable String next, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentAttributes(Async)");
        }
        return this.getDocumentAttributesCall(documentId, siteId, limit, next, _callback);
    }

    public GetDocumentAttributesResponse getDocumentAttributes(@Nonnull String documentId, @Nullable String siteId, @Nullable String limit, @Nullable String next) throws ApiException {
        ApiResponse<GetDocumentAttributesResponse> localVarResp = this.getDocumentAttributesWithHttpInfo(documentId, siteId, limit, next);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentAttributesResponse> getDocumentAttributesWithHttpInfo(@Nonnull String documentId, @Nullable String siteId, @Nullable String limit, @Nullable String next) throws ApiException {
        Call localVarCall = this.getDocumentAttributesValidateBeforeCall(documentId, siteId, limit, next, null);
        Type localVarReturnType = new TypeToken<GetDocumentAttributesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentAttributesAsync(@Nonnull String documentId, @Nullable String siteId, @Nullable String limit, @Nullable String next, ApiCallback<GetDocumentAttributesResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentAttributesValidateBeforeCall(documentId, siteId, limit, next, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentAttributesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setDocumentAttributeValueCall(@Nonnull String documentId, @Nonnull String attributeKey, @Nonnull SetDocumentAttributeRequest setDocumentAttributeRequest, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SetDocumentAttributeRequest localVarPostBody = setDocumentAttributeRequest;
        String localVarPath = "/documents/{documentId}/attributes/{attributeKey}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString())).replace("{attributeKey}", this.localVarApiClient.escapeString(attributeKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setDocumentAttributeValueValidateBeforeCall(@Nonnull String documentId, @Nonnull String attributeKey, @Nonnull SetDocumentAttributeRequest setDocumentAttributeRequest, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling setDocumentAttributeValue(Async)");
        }
        if (attributeKey == null) {
            throw new ApiException("Missing the required parameter 'attributeKey' when calling setDocumentAttributeValue(Async)");
        }
        if (setDocumentAttributeRequest == null) {
            throw new ApiException("Missing the required parameter 'setDocumentAttributeRequest' when calling setDocumentAttributeValue(Async)");
        }
        return this.setDocumentAttributeValueCall(documentId, attributeKey, setDocumentAttributeRequest, siteId, _callback);
    }

    public SetResponse setDocumentAttributeValue(@Nonnull String documentId, @Nonnull String attributeKey, @Nonnull SetDocumentAttributeRequest setDocumentAttributeRequest, @Nullable String siteId) throws ApiException {
        ApiResponse<SetResponse> localVarResp = this.setDocumentAttributeValueWithHttpInfo(documentId, attributeKey, setDocumentAttributeRequest, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<SetResponse> setDocumentAttributeValueWithHttpInfo(@Nonnull String documentId, @Nonnull String attributeKey, @Nonnull SetDocumentAttributeRequest setDocumentAttributeRequest, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.setDocumentAttributeValueValidateBeforeCall(documentId, attributeKey, setDocumentAttributeRequest, siteId, null);
        Type localVarReturnType = new TypeToken<SetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setDocumentAttributeValueAsync(@Nonnull String documentId, @Nonnull String attributeKey, @Nonnull SetDocumentAttributeRequest setDocumentAttributeRequest, @Nullable String siteId, ApiCallback<SetResponse> _callback) throws ApiException {
        Call localVarCall = this.setDocumentAttributeValueValidateBeforeCall(documentId, attributeKey, setDocumentAttributeRequest, siteId, _callback);
        Type localVarReturnType = new TypeToken<SetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setDocumentAttributesCall(@Nonnull String documentId, @Nonnull SetDocumentAttributesRequest setDocumentAttributesRequest, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SetDocumentAttributesRequest localVarPostBody = setDocumentAttributesRequest;
        String localVarPath = "/documents/{documentId}/attributes".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setDocumentAttributesValidateBeforeCall(@Nonnull String documentId, @Nonnull SetDocumentAttributesRequest setDocumentAttributesRequest, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling setDocumentAttributes(Async)");
        }
        if (setDocumentAttributesRequest == null) {
            throw new ApiException("Missing the required parameter 'setDocumentAttributesRequest' when calling setDocumentAttributes(Async)");
        }
        return this.setDocumentAttributesCall(documentId, setDocumentAttributesRequest, siteId, _callback);
    }

    public SetResponse setDocumentAttributes(@Nonnull String documentId, @Nonnull SetDocumentAttributesRequest setDocumentAttributesRequest, @Nullable String siteId) throws ApiException {
        ApiResponse<SetResponse> localVarResp = this.setDocumentAttributesWithHttpInfo(documentId, setDocumentAttributesRequest, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<SetResponse> setDocumentAttributesWithHttpInfo(@Nonnull String documentId, @Nonnull SetDocumentAttributesRequest setDocumentAttributesRequest, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.setDocumentAttributesValidateBeforeCall(documentId, setDocumentAttributesRequest, siteId, null);
        Type localVarReturnType = new TypeToken<SetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setDocumentAttributesAsync(@Nonnull String documentId, @Nonnull SetDocumentAttributesRequest setDocumentAttributesRequest, @Nullable String siteId, ApiCallback<SetResponse> _callback) throws ApiException {
        Call localVarCall = this.setDocumentAttributesValidateBeforeCall(documentId, setDocumentAttributesRequest, siteId, _callback);
        Type localVarReturnType = new TypeToken<SetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

