/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.api;

import com.formkiq.client.invoker.ApiCallback;
import com.formkiq.client.invoker.ApiClient;
import com.formkiq.client.invoker.ApiException;
import com.formkiq.client.invoker.ApiResponse;
import com.formkiq.client.invoker.Configuration;
import com.formkiq.client.invoker.Pair;
import com.formkiq.client.model.AddDocumentRequest;
import com.formkiq.client.model.AddDocumentResponse;
import com.formkiq.client.model.AddDocumentSyncRequest;
import com.formkiq.client.model.AddDocumentUploadRequest;
import com.formkiq.client.model.AddResponse;
import com.formkiq.client.model.DeleteResponse;
import com.formkiq.client.model.DocumentsCompressRequest;
import com.formkiq.client.model.DocumentsCompressResponse;
import com.formkiq.client.model.GetDocumentContentResponse;
import com.formkiq.client.model.GetDocumentResponse;
import com.formkiq.client.model.GetDocumentSyncResponse;
import com.formkiq.client.model.GetDocumentUrlResponse;
import com.formkiq.client.model.GetDocumentsResponse;
import com.formkiq.client.model.SetDocumentRestoreResponse;
import com.formkiq.client.model.UpdateDocumentRequest;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class DocumentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DocumentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addDocumentCall(@Nonnull AddDocumentRequest addDocumentRequest, @Nullable String siteId, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddDocumentRequest localVarPostBody = addDocumentRequest;
        String localVarPath = "/documents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addDocumentValidateBeforeCall(@Nonnull AddDocumentRequest addDocumentRequest, @Nullable String siteId, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        if (addDocumentRequest == null) {
            throw new ApiException("Missing the required parameter 'addDocumentRequest' when calling addDocument(Async)");
        }
        return this.addDocumentCall(addDocumentRequest, siteId, shareKey, _callback);
    }

    public AddDocumentResponse addDocument(@Nonnull AddDocumentRequest addDocumentRequest, @Nullable String siteId, @Nullable String shareKey) throws ApiException {
        ApiResponse<AddDocumentResponse> localVarResp = this.addDocumentWithHttpInfo(addDocumentRequest, siteId, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<AddDocumentResponse> addDocumentWithHttpInfo(@Nonnull AddDocumentRequest addDocumentRequest, @Nullable String siteId, @Nullable String shareKey) throws ApiException {
        Call localVarCall = this.addDocumentValidateBeforeCall(addDocumentRequest, siteId, shareKey, null);
        Type localVarReturnType = new TypeToken<AddDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addDocumentAsync(@Nonnull AddDocumentRequest addDocumentRequest, @Nullable String siteId, @Nullable String shareKey, ApiCallback<AddDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.addDocumentValidateBeforeCall(addDocumentRequest, siteId, shareKey, _callback);
        Type localVarReturnType = new TypeToken<AddDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call addDocumentSyncCall(@Nonnull String documentId, @Nullable String siteId, @Nullable AddDocumentSyncRequest addDocumentSyncRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddDocumentSyncRequest localVarPostBody = addDocumentSyncRequest;
        String localVarPath = "/documents/{documentId}/syncs".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addDocumentSyncValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, @Nullable AddDocumentSyncRequest addDocumentSyncRequest, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling addDocumentSync(Async)");
        }
        return this.addDocumentSyncCall(documentId, siteId, addDocumentSyncRequest, _callback);
    }

    public AddResponse addDocumentSync(@Nonnull String documentId, @Nullable String siteId, @Nullable AddDocumentSyncRequest addDocumentSyncRequest) throws ApiException {
        ApiResponse<AddResponse> localVarResp = this.addDocumentSyncWithHttpInfo(documentId, siteId, addDocumentSyncRequest);
        return localVarResp.getData();
    }

    public ApiResponse<AddResponse> addDocumentSyncWithHttpInfo(@Nonnull String documentId, @Nullable String siteId, @Nullable AddDocumentSyncRequest addDocumentSyncRequest) throws ApiException {
        Call localVarCall = this.addDocumentSyncValidateBeforeCall(documentId, siteId, addDocumentSyncRequest, null);
        Type localVarReturnType = new TypeToken<AddResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addDocumentSyncAsync(@Nonnull String documentId, @Nullable String siteId, @Nullable AddDocumentSyncRequest addDocumentSyncRequest, ApiCallback<AddResponse> _callback) throws ApiException {
        Call localVarCall = this.addDocumentSyncValidateBeforeCall(documentId, siteId, addDocumentSyncRequest, _callback);
        Type localVarReturnType = new TypeToken<AddResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call addDocumentUploadCall(@Nonnull AddDocumentUploadRequest addDocumentUploadRequest, @Nullable String siteId, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddDocumentUploadRequest localVarPostBody = addDocumentUploadRequest;
        String localVarPath = "/documents/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (contentLength != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contentLength", contentLength));
        }
        if (duration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("duration", duration));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addDocumentUploadValidateBeforeCall(@Nonnull AddDocumentUploadRequest addDocumentUploadRequest, @Nullable String siteId, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        if (addDocumentUploadRequest == null) {
            throw new ApiException("Missing the required parameter 'addDocumentUploadRequest' when calling addDocumentUpload(Async)");
        }
        return this.addDocumentUploadCall(addDocumentUploadRequest, siteId, contentLength, duration, shareKey, _callback);
    }

    public GetDocumentUrlResponse addDocumentUpload(@Nonnull AddDocumentUploadRequest addDocumentUploadRequest, @Nullable String siteId, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey) throws ApiException {
        ApiResponse<GetDocumentUrlResponse> localVarResp = this.addDocumentUploadWithHttpInfo(addDocumentUploadRequest, siteId, contentLength, duration, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentUrlResponse> addDocumentUploadWithHttpInfo(@Nonnull AddDocumentUploadRequest addDocumentUploadRequest, @Nullable String siteId, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey) throws ApiException {
        Call localVarCall = this.addDocumentUploadValidateBeforeCall(addDocumentUploadRequest, siteId, contentLength, duration, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addDocumentUploadAsync(@Nonnull AddDocumentUploadRequest addDocumentUploadRequest, @Nullable String siteId, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey, ApiCallback<GetDocumentUrlResponse> _callback) throws ApiException {
        Call localVarCall = this.addDocumentUploadValidateBeforeCall(addDocumentUploadRequest, siteId, contentLength, duration, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call compressDocumentsCall(@Nonnull DocumentsCompressRequest documentsCompressRequest, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        DocumentsCompressRequest localVarPostBody = documentsCompressRequest;
        String localVarPath = "/documents/compress";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call compressDocumentsValidateBeforeCall(@Nonnull DocumentsCompressRequest documentsCompressRequest, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentsCompressRequest == null) {
            throw new ApiException("Missing the required parameter 'documentsCompressRequest' when calling compressDocuments(Async)");
        }
        return this.compressDocumentsCall(documentsCompressRequest, siteId, _callback);
    }

    public DocumentsCompressResponse compressDocuments(@Nonnull DocumentsCompressRequest documentsCompressRequest, @Nullable String siteId) throws ApiException {
        ApiResponse<DocumentsCompressResponse> localVarResp = this.compressDocumentsWithHttpInfo(documentsCompressRequest, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentsCompressResponse> compressDocumentsWithHttpInfo(@Nonnull DocumentsCompressRequest documentsCompressRequest, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.compressDocumentsValidateBeforeCall(documentsCompressRequest, siteId, null);
        Type localVarReturnType = new TypeToken<DocumentsCompressResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call compressDocumentsAsync(@Nonnull DocumentsCompressRequest documentsCompressRequest, @Nullable String siteId, ApiCallback<DocumentsCompressResponse> _callback) throws ApiException {
        Call localVarCall = this.compressDocumentsValidateBeforeCall(documentsCompressRequest, siteId, _callback);
        Type localVarReturnType = new TypeToken<DocumentsCompressResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteDocumentCall(@Nonnull String documentId, @Nullable String siteId, @Nullable Boolean softDelete, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (softDelete != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("softDelete", softDelete));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDocumentValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, @Nullable Boolean softDelete, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteDocument(Async)");
        }
        return this.deleteDocumentCall(documentId, siteId, softDelete, _callback);
    }

    public DeleteResponse deleteDocument(@Nonnull String documentId, @Nullable String siteId, @Nullable Boolean softDelete) throws ApiException {
        ApiResponse<DeleteResponse> localVarResp = this.deleteDocumentWithHttpInfo(documentId, siteId, softDelete);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteResponse> deleteDocumentWithHttpInfo(@Nonnull String documentId, @Nullable String siteId, @Nullable Boolean softDelete) throws ApiException {
        Call localVarCall = this.deleteDocumentValidateBeforeCall(documentId, siteId, softDelete, null);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteDocumentAsync(@Nonnull String documentId, @Nullable String siteId, @Nullable Boolean softDelete, ApiCallback<DeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteDocumentValidateBeforeCall(documentId, siteId, softDelete, _callback);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deletePublishedDocumentContentCall(@Nonnull String documentId, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/publications/{documentId}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePublishedDocumentContentValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deletePublishedDocumentContent(Async)");
        }
        return this.deletePublishedDocumentContentCall(documentId, siteId, _callback);
    }

    public DeleteResponse deletePublishedDocumentContent(@Nonnull String documentId, @Nullable String siteId) throws ApiException {
        ApiResponse<DeleteResponse> localVarResp = this.deletePublishedDocumentContentWithHttpInfo(documentId, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteResponse> deletePublishedDocumentContentWithHttpInfo(@Nonnull String documentId, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.deletePublishedDocumentContentValidateBeforeCall(documentId, siteId, null);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deletePublishedDocumentContentAsync(@Nonnull String documentId, @Nullable String siteId, ApiCallback<DeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deletePublishedDocumentContentValidateBeforeCall(documentId, siteId, _callback);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocument(Async)");
        }
        return this.getDocumentCall(documentId, siteId, shareKey, _callback);
    }

    public GetDocumentResponse getDocument(@Nonnull String documentId, @Nullable String siteId, @Nullable String shareKey) throws ApiException {
        ApiResponse<GetDocumentResponse> localVarResp = this.getDocumentWithHttpInfo(documentId, siteId, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentResponse> getDocumentWithHttpInfo(@Nonnull String documentId, @Nullable String siteId, @Nullable String shareKey) throws ApiException {
        Call localVarCall = this.getDocumentValidateBeforeCall(documentId, siteId, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentAsync(@Nonnull String documentId, @Nullable String siteId, @Nullable String shareKey, ApiCallback<GetDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentValidateBeforeCall(documentId, siteId, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentContentCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String versionKey, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/content".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (versionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionKey", versionKey));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentContentValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String versionKey, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentContent(Async)");
        }
        return this.getDocumentContentCall(documentId, siteId, versionKey, shareKey, _callback);
    }

    public GetDocumentContentResponse getDocumentContent(@Nonnull String documentId, @Nullable String siteId, @Nullable String versionKey, @Nullable String shareKey) throws ApiException {
        ApiResponse<GetDocumentContentResponse> localVarResp = this.getDocumentContentWithHttpInfo(documentId, siteId, versionKey, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentContentResponse> getDocumentContentWithHttpInfo(@Nonnull String documentId, @Nullable String siteId, @Nullable String versionKey, @Nullable String shareKey) throws ApiException {
        Call localVarCall = this.getDocumentContentValidateBeforeCall(documentId, siteId, versionKey, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentContentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentContentAsync(@Nonnull String documentId, @Nullable String siteId, @Nullable String versionKey, @Nullable String shareKey, ApiCallback<GetDocumentContentResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentContentValidateBeforeCall(documentId, siteId, versionKey, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentContentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentIdUploadCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String checksumType, @Nullable String checksum, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/upload".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (checksumType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checksumType", checksumType));
        }
        if (checksum != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checksum", checksum));
        }
        if (contentLength != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contentLength", contentLength));
        }
        if (duration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("duration", duration));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentIdUploadValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String checksumType, @Nullable String checksum, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentIdUpload(Async)");
        }
        return this.getDocumentIdUploadCall(documentId, siteId, checksumType, checksum, contentLength, duration, shareKey, _callback);
    }

    public GetDocumentUrlResponse getDocumentIdUpload(@Nonnull String documentId, @Nullable String siteId, @Nullable String checksumType, @Nullable String checksum, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey) throws ApiException {
        ApiResponse<GetDocumentUrlResponse> localVarResp = this.getDocumentIdUploadWithHttpInfo(documentId, siteId, checksumType, checksum, contentLength, duration, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentUrlResponse> getDocumentIdUploadWithHttpInfo(@Nonnull String documentId, @Nullable String siteId, @Nullable String checksumType, @Nullable String checksum, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey) throws ApiException {
        Call localVarCall = this.getDocumentIdUploadValidateBeforeCall(documentId, siteId, checksumType, checksum, contentLength, duration, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentIdUploadAsync(@Nonnull String documentId, @Nullable String siteId, @Nullable String checksumType, @Nullable String checksum, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey, ApiCallback<GetDocumentUrlResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentIdUploadValidateBeforeCall(documentId, siteId, checksumType, checksum, contentLength, duration, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentSyncsCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String limit, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/syncs".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentSyncsValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String limit, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentSyncs(Async)");
        }
        return this.getDocumentSyncsCall(documentId, siteId, limit, shareKey, _callback);
    }

    public GetDocumentSyncResponse getDocumentSyncs(@Nonnull String documentId, @Nullable String siteId, @Nullable String limit, @Nullable String shareKey) throws ApiException {
        ApiResponse<GetDocumentSyncResponse> localVarResp = this.getDocumentSyncsWithHttpInfo(documentId, siteId, limit, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentSyncResponse> getDocumentSyncsWithHttpInfo(@Nonnull String documentId, @Nullable String siteId, @Nullable String limit, @Nullable String shareKey) throws ApiException {
        Call localVarCall = this.getDocumentSyncsValidateBeforeCall(documentId, siteId, limit, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentSyncResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentSyncsAsync(@Nonnull String documentId, @Nullable String siteId, @Nullable String limit, @Nullable String shareKey, ApiCallback<GetDocumentSyncResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentSyncsValidateBeforeCall(documentId, siteId, limit, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentSyncResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentUploadCall(@Nullable String path, @Nullable String siteId, @Nullable String checksumType, @Nullable String checksum, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (checksumType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checksumType", checksumType));
        }
        if (checksum != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checksum", checksum));
        }
        if (contentLength != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contentLength", contentLength));
        }
        if (duration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("duration", duration));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentUploadValidateBeforeCall(@Nullable String path, @Nullable String siteId, @Nullable String checksumType, @Nullable String checksum, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        return this.getDocumentUploadCall(path, siteId, checksumType, checksum, contentLength, duration, shareKey, _callback);
    }

    public GetDocumentUrlResponse getDocumentUpload(@Nullable String path, @Nullable String siteId, @Nullable String checksumType, @Nullable String checksum, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey) throws ApiException {
        ApiResponse<GetDocumentUrlResponse> localVarResp = this.getDocumentUploadWithHttpInfo(path, siteId, checksumType, checksum, contentLength, duration, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentUrlResponse> getDocumentUploadWithHttpInfo(@Nullable String path, @Nullable String siteId, @Nullable String checksumType, @Nullable String checksum, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey) throws ApiException {
        Call localVarCall = this.getDocumentUploadValidateBeforeCall(path, siteId, checksumType, checksum, contentLength, duration, shareKey, null);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentUploadAsync(@Nullable String path, @Nullable String siteId, @Nullable String checksumType, @Nullable String checksum, @Nullable Integer contentLength, @Nullable Integer duration, @Nullable String shareKey, ApiCallback<GetDocumentUrlResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentUploadValidateBeforeCall(path, siteId, checksumType, checksum, contentLength, duration, shareKey, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentUrlCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String versionKey, @Nullable Integer duration, @Nullable String shareKey, @Nullable Boolean inline, @Nullable Boolean bypassWatermark, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/url".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (versionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionKey", versionKey));
        }
        if (duration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("duration", duration));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if (inline != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("inline", inline));
        }
        if (bypassWatermark != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bypassWatermark", bypassWatermark));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentUrlValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, @Nullable String versionKey, @Nullable Integer duration, @Nullable String shareKey, @Nullable Boolean inline, @Nullable Boolean bypassWatermark, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocumentUrl(Async)");
        }
        return this.getDocumentUrlCall(documentId, siteId, versionKey, duration, shareKey, inline, bypassWatermark, _callback);
    }

    public GetDocumentUrlResponse getDocumentUrl(@Nonnull String documentId, @Nullable String siteId, @Nullable String versionKey, @Nullable Integer duration, @Nullable String shareKey, @Nullable Boolean inline, @Nullable Boolean bypassWatermark) throws ApiException {
        ApiResponse<GetDocumentUrlResponse> localVarResp = this.getDocumentUrlWithHttpInfo(documentId, siteId, versionKey, duration, shareKey, inline, bypassWatermark);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentUrlResponse> getDocumentUrlWithHttpInfo(@Nonnull String documentId, @Nullable String siteId, @Nullable String versionKey, @Nullable Integer duration, @Nullable String shareKey, @Nullable Boolean inline, @Nullable Boolean bypassWatermark) throws ApiException {
        Call localVarCall = this.getDocumentUrlValidateBeforeCall(documentId, siteId, versionKey, duration, shareKey, inline, bypassWatermark, null);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentUrlAsync(@Nonnull String documentId, @Nullable String siteId, @Nullable String versionKey, @Nullable Integer duration, @Nullable String shareKey, @Nullable Boolean inline, @Nullable Boolean bypassWatermark, ApiCallback<GetDocumentUrlResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentUrlValidateBeforeCall(documentId, siteId, versionKey, duration, shareKey, inline, bypassWatermark, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentUrlResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDocumentsCall(@Nullable String siteId, @Nullable String actionStatus, @Nullable String syncStatus, @Nullable Boolean deleted, @Nullable String date, @Nullable String tz, @Nullable String next, @Nullable String previous, @Nullable String limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (actionStatus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("actionStatus", actionStatus));
        }
        if (syncStatus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("syncStatus", syncStatus));
        }
        if (deleted != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deleted", deleted));
        }
        if (date != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date", date));
        }
        if (tz != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tz", tz));
        }
        if (next != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next", next));
        }
        if (previous != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("previous", previous));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocumentsValidateBeforeCall(@Nullable String siteId, @Nullable String actionStatus, @Nullable String syncStatus, @Nullable Boolean deleted, @Nullable String date, @Nullable String tz, @Nullable String next, @Nullable String previous, @Nullable String limit, ApiCallback _callback) throws ApiException {
        return this.getDocumentsCall(siteId, actionStatus, syncStatus, deleted, date, tz, next, previous, limit, _callback);
    }

    public GetDocumentsResponse getDocuments(@Nullable String siteId, @Nullable String actionStatus, @Nullable String syncStatus, @Nullable Boolean deleted, @Nullable String date, @Nullable String tz, @Nullable String next, @Nullable String previous, @Nullable String limit) throws ApiException {
        ApiResponse<GetDocumentsResponse> localVarResp = this.getDocumentsWithHttpInfo(siteId, actionStatus, syncStatus, deleted, date, tz, next, previous, limit);
        return localVarResp.getData();
    }

    public ApiResponse<GetDocumentsResponse> getDocumentsWithHttpInfo(@Nullable String siteId, @Nullable String actionStatus, @Nullable String syncStatus, @Nullable Boolean deleted, @Nullable String date, @Nullable String tz, @Nullable String next, @Nullable String previous, @Nullable String limit) throws ApiException {
        Call localVarCall = this.getDocumentsValidateBeforeCall(siteId, actionStatus, syncStatus, deleted, date, tz, next, previous, limit, null);
        Type localVarReturnType = new TypeToken<GetDocumentsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentsAsync(@Nullable String siteId, @Nullable String actionStatus, @Nullable String syncStatus, @Nullable Boolean deleted, @Nullable String date, @Nullable String tz, @Nullable String next, @Nullable String previous, @Nullable String limit, ApiCallback<GetDocumentsResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentsValidateBeforeCall(siteId, actionStatus, syncStatus, deleted, date, tz, next, previous, limit, _callback);
        Type localVarReturnType = new TypeToken<GetDocumentsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPublishedDocumentContentCall(@Nonnull String documentId, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/publications/{documentId}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPublishedDocumentContentValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getPublishedDocumentContent(Async)");
        }
        return this.getPublishedDocumentContentCall(documentId, siteId, _callback);
    }

    public void getPublishedDocumentContent(@Nonnull String documentId, @Nullable String siteId) throws ApiException {
        this.getPublishedDocumentContentWithHttpInfo(documentId, siteId);
    }

    public ApiResponse<Void> getPublishedDocumentContentWithHttpInfo(@Nonnull String documentId, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.getPublishedDocumentContentValidateBeforeCall(documentId, siteId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call getPublishedDocumentContentAsync(@Nonnull String documentId, @Nullable String siteId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getPublishedDocumentContentValidateBeforeCall(documentId, siteId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call purgeDocumentCall(@Nonnull String documentId, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/purge".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call purgeDocumentValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling purgeDocument(Async)");
        }
        return this.purgeDocumentCall(documentId, siteId, _callback);
    }

    public DeleteResponse purgeDocument(@Nonnull String documentId, @Nullable String siteId) throws ApiException {
        ApiResponse<DeleteResponse> localVarResp = this.purgeDocumentWithHttpInfo(documentId, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteResponse> purgeDocumentWithHttpInfo(@Nonnull String documentId, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.purgeDocumentValidateBeforeCall(documentId, siteId, null);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call purgeDocumentAsync(@Nonnull String documentId, @Nullable String siteId, ApiCallback<DeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.purgeDocumentValidateBeforeCall(documentId, siteId, _callback);
        Type localVarReturnType = new TypeToken<DeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setDocumentRestoreCall(@Nonnull String documentId, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/documents/{documentId}/restore".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setDocumentRestoreValidateBeforeCall(@Nonnull String documentId, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling setDocumentRestore(Async)");
        }
        return this.setDocumentRestoreCall(documentId, siteId, _callback);
    }

    public SetDocumentRestoreResponse setDocumentRestore(@Nonnull String documentId, @Nullable String siteId) throws ApiException {
        ApiResponse<SetDocumentRestoreResponse> localVarResp = this.setDocumentRestoreWithHttpInfo(documentId, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<SetDocumentRestoreResponse> setDocumentRestoreWithHttpInfo(@Nonnull String documentId, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.setDocumentRestoreValidateBeforeCall(documentId, siteId, null);
        Type localVarReturnType = new TypeToken<SetDocumentRestoreResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setDocumentRestoreAsync(@Nonnull String documentId, @Nullable String siteId, ApiCallback<SetDocumentRestoreResponse> _callback) throws ApiException {
        Call localVarCall = this.setDocumentRestoreValidateBeforeCall(documentId, siteId, _callback);
        Type localVarReturnType = new TypeToken<SetDocumentRestoreResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateDocumentCall(@Nonnull String documentId, @Nonnull UpdateDocumentRequest updateDocumentRequest, @Nullable String siteId, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateDocumentRequest localVarPostBody = updateDocumentRequest;
        String localVarPath = "/documents/{documentId}".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if (shareKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shareKey", shareKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDocumentValidateBeforeCall(@Nonnull String documentId, @Nonnull UpdateDocumentRequest updateDocumentRequest, @Nullable String siteId, @Nullable String shareKey, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling updateDocument(Async)");
        }
        if (updateDocumentRequest == null) {
            throw new ApiException("Missing the required parameter 'updateDocumentRequest' when calling updateDocument(Async)");
        }
        return this.updateDocumentCall(documentId, updateDocumentRequest, siteId, shareKey, _callback);
    }

    public AddDocumentResponse updateDocument(@Nonnull String documentId, @Nonnull UpdateDocumentRequest updateDocumentRequest, @Nullable String siteId, @Nullable String shareKey) throws ApiException {
        ApiResponse<AddDocumentResponse> localVarResp = this.updateDocumentWithHttpInfo(documentId, updateDocumentRequest, siteId, shareKey);
        return localVarResp.getData();
    }

    public ApiResponse<AddDocumentResponse> updateDocumentWithHttpInfo(@Nonnull String documentId, @Nonnull UpdateDocumentRequest updateDocumentRequest, @Nullable String siteId, @Nullable String shareKey) throws ApiException {
        Call localVarCall = this.updateDocumentValidateBeforeCall(documentId, updateDocumentRequest, siteId, shareKey, null);
        Type localVarReturnType = new TypeToken<AddDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateDocumentAsync(@Nonnull String documentId, @Nonnull UpdateDocumentRequest updateDocumentRequest, @Nullable String siteId, @Nullable String shareKey, ApiCallback<AddDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.updateDocumentValidateBeforeCall(documentId, updateDocumentRequest, siteId, shareKey, _callback);
        Type localVarReturnType = new TypeToken<AddDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

