/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.api;

import com.formkiq.client.invoker.ApiCallback;
import com.formkiq.client.invoker.ApiClient;
import com.formkiq.client.invoker.ApiException;
import com.formkiq.client.invoker.ApiResponse;
import com.formkiq.client.invoker.Configuration;
import com.formkiq.client.invoker.Pair;
import com.formkiq.client.model.AddGoogleDocumentExportRequest;
import com.formkiq.client.model.AddGoogleDocumentExportResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class GoogleIntegrationApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public GoogleIntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GoogleIntegrationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addGoogleDocumentExportCall(@Nonnull String documentId, @Nonnull AddGoogleDocumentExportRequest addGoogleDocumentExportRequest, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddGoogleDocumentExportRequest localVarPostBody = addGoogleDocumentExportRequest;
        String localVarPath = "/integrations/google/drive/documents/{documentId}/export".replace("{documentId}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("siteId", siteId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"AWS4Auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addGoogleDocumentExportValidateBeforeCall(@Nonnull String documentId, @Nonnull AddGoogleDocumentExportRequest addGoogleDocumentExportRequest, @Nullable String siteId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling addGoogleDocumentExport(Async)");
        }
        if (addGoogleDocumentExportRequest == null) {
            throw new ApiException("Missing the required parameter 'addGoogleDocumentExportRequest' when calling addGoogleDocumentExport(Async)");
        }
        return this.addGoogleDocumentExportCall(documentId, addGoogleDocumentExportRequest, siteId, _callback);
    }

    public AddGoogleDocumentExportResponse addGoogleDocumentExport(@Nonnull String documentId, @Nonnull AddGoogleDocumentExportRequest addGoogleDocumentExportRequest, @Nullable String siteId) throws ApiException {
        ApiResponse<AddGoogleDocumentExportResponse> localVarResp = this.addGoogleDocumentExportWithHttpInfo(documentId, addGoogleDocumentExportRequest, siteId);
        return localVarResp.getData();
    }

    public ApiResponse<AddGoogleDocumentExportResponse> addGoogleDocumentExportWithHttpInfo(@Nonnull String documentId, @Nonnull AddGoogleDocumentExportRequest addGoogleDocumentExportRequest, @Nullable String siteId) throws ApiException {
        Call localVarCall = this.addGoogleDocumentExportValidateBeforeCall(documentId, addGoogleDocumentExportRequest, siteId, null);
        Type localVarReturnType = new TypeToken<AddGoogleDocumentExportResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addGoogleDocumentExportAsync(@Nonnull String documentId, @Nonnull AddGoogleDocumentExportRequest addGoogleDocumentExportRequest, @Nullable String siteId, ApiCallback<AddGoogleDocumentExportResponse> _callback) throws ApiException {
        Call localVarCall = this.addGoogleDocumentExportValidateBeforeCall(documentId, addGoogleDocumentExportRequest, siteId, _callback);
        Type localVarReturnType = new TypeToken<AddGoogleDocumentExportResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

