/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.invoker.auth;

import com.formkiq.client.invoker.ApiException;
import com.formkiq.client.invoker.Pair;
import com.formkiq.client.invoker.auth.Authentication;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public class AWS4Auth
implements Authentication {
    private AwsCredentials credentials = AnonymousCredentialsProvider.create().resolveCredentials();
    private String region;
    private String service;

    public void setCredentials(String accessKey, String secretKey) {
        this.credentials = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
    }

    public void setCredentials(String accessKey, String secretKey, String sessionToken) {
        this.credentials = AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)sessionToken);
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setService(String service) {
        this.service = service;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, final String payload, String method, URI uri) throws ApiException {
        SdkHttpFullRequest.Builder requestBuilder = SdkHttpFullRequest.builder().uri(uri).method(SdkHttpMethod.fromValue((String)method));
        ContentStreamProvider provider = new ContentStreamProvider(){

            public InputStream newStream() {
                ByteArrayInputStream is = new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8));
                return is;
            }
        };
        requestBuilder = requestBuilder.contentStreamProvider(provider);
        SdkHttpFullRequest signableRequest = this.sign(requestBuilder);
        Map<String, String> headers = signableRequest.headers().entrySet().stream().collect(Collectors.toMap(s -> (String)s.getKey(), e -> (String)((List)e.getValue()).get(0)));
        headerParams.putAll(headers);
    }

    private SdkHttpFullRequest sign(SdkHttpFullRequest.Builder request) {
        SdkHttpFullRequest req = request.build();
        if (this.service != null && this.region != null && this.credentials != null) {
            Aws4SignerParams params = Aws4SignerParams.builder().signingName(this.service).signingRegion(Region.of((String)this.region)).awsCredentials(this.credentials).build();
            Aws4Signer signer = Aws4Signer.create();
            req = signer.sign(req, params);
        }
        return req;
    }
}

