/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum AttributeDataType {
    STRING("STRING"),
    NUMBER("NUMBER"),
    BOOLEAN("BOOLEAN"),
    KEY_ONLY("KEY_ONLY"),
    PUBLICATION("PUBLICATION"),
    WATERMARK("WATERMARK");

    private String value;

    private AttributeDataType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttributeDataType fromValue(String value) {
        for (AttributeDataType b : AttributeDataType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        AttributeDataType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<AttributeDataType> {
        public void write(JsonWriter jsonWriter, AttributeDataType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public AttributeDataType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return AttributeDataType.fromValue(value);
        }
    }
}

