/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.model;

import com.formkiq.client.invoker.JSON;
import com.formkiq.client.model.DocumentSearch;
import com.formkiq.client.model.SearchResponseFields;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentSearchRequest {
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    @Nonnull
    private DocumentSearch query;
    public static final String SERIALIZED_NAME_RESPONSE_FIELDS = "responseFields";
    @SerializedName(value="responseFields")
    @Nullable
    private SearchResponseFields responseFields;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public DocumentSearchRequest query(@Nonnull DocumentSearch query) {
        this.query = query;
        return this;
    }

    @Nonnull
    public DocumentSearch getQuery() {
        return this.query;
    }

    public void setQuery(@Nonnull DocumentSearch query) {
        this.query = query;
    }

    public DocumentSearchRequest responseFields(@Nullable SearchResponseFields responseFields) {
        this.responseFields = responseFields;
        return this;
    }

    @Nullable
    public SearchResponseFields getResponseFields() {
        return this.responseFields;
    }

    public void setResponseFields(@Nullable SearchResponseFields responseFields) {
        this.responseFields = responseFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentSearchRequest documentSearchRequest = (DocumentSearchRequest)o;
        return Objects.equals(this.query, documentSearchRequest.query) && Objects.equals(this.responseFields, documentSearchRequest.responseFields);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.responseFields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentSearchRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    responseFields: ").append(this.toIndentedString(this.responseFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in DocumentSearchRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DocumentSearchRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        DocumentSearch.validateJsonElement(jsonObj.get(SERIALIZED_NAME_QUERY));
        if (jsonObj.get(SERIALIZED_NAME_RESPONSE_FIELDS) != null && !jsonObj.get(SERIALIZED_NAME_RESPONSE_FIELDS).isJsonNull()) {
            SearchResponseFields.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESPONSE_FIELDS));
        }
    }

    public static DocumentSearchRequest fromJson(String jsonString) throws IOException {
        return (DocumentSearchRequest)JSON.getGson().fromJson(jsonString, DocumentSearchRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_QUERY);
        openapiFields.add(SERIALIZED_NAME_RESPONSE_FIELDS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_QUERY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DocumentSearchRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DocumentSearchRequest.class));
            return new TypeAdapter<DocumentSearchRequest>(){

                public void write(JsonWriter out, DocumentSearchRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DocumentSearchRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    DocumentSearchRequest.validateJsonElement(jsonElement);
                    return (DocumentSearchRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

