/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.client.model;

import com.formkiq.client.invoker.JSON;
import com.formkiq.client.model.SiteConfig;
import com.formkiq.client.model.SiteGroupPermissions;
import com.formkiq.client.model.SiteStatus;
import com.formkiq.client.model.SiteUsage;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class Site {
    public static final String SERIALIZED_NAME_SITE_ID = "siteId";
    @SerializedName(value="siteId")
    @Nullable
    private String siteId;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    @Nullable
    private String title;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nullable
    private SiteStatus status;
    public static final String SERIALIZED_NAME_PERMISSION = "permission";
    @SerializedName(value="permission")
    @Nullable
    private PermissionEnum permission;
    public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
    @SerializedName(value="permissions")
    @Nullable
    private List<SiteGroupPermissions> permissions = new ArrayList<SiteGroupPermissions>();
    public static final String SERIALIZED_NAME_UPLOAD_EMAIL = "uploadEmail";
    @SerializedName(value="uploadEmail")
    @Nullable
    private String uploadEmail;
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    @Nullable
    private SiteConfig config;
    public static final String SERIALIZED_NAME_USAGE = "usage";
    @SerializedName(value="usage")
    @Nullable
    private SiteUsage usage;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Site siteId(@Nullable String siteId) {
        this.siteId = siteId;
        return this;
    }

    @Nullable
    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(@Nullable String siteId) {
        this.siteId = siteId;
    }

    public Site title(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public Site status(@Nullable SiteStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    public SiteStatus getStatus() {
        return this.status;
    }

    public void setStatus(@Nullable SiteStatus status) {
        this.status = status;
    }

    public Site permission(@Nullable PermissionEnum permission) {
        this.permission = permission;
        return this;
    }

    @Nullable
    public PermissionEnum getPermission() {
        return this.permission;
    }

    public void setPermission(@Nullable PermissionEnum permission) {
        this.permission = permission;
    }

    public Site permissions(@Nullable List<SiteGroupPermissions> permissions) {
        this.permissions = permissions;
        return this;
    }

    public Site addPermissionsItem(SiteGroupPermissions permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<SiteGroupPermissions>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nullable
    public List<SiteGroupPermissions> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(@Nullable List<SiteGroupPermissions> permissions) {
        this.permissions = permissions;
    }

    public Site uploadEmail(@Nullable String uploadEmail) {
        this.uploadEmail = uploadEmail;
        return this;
    }

    @Nullable
    public String getUploadEmail() {
        return this.uploadEmail;
    }

    public void setUploadEmail(@Nullable String uploadEmail) {
        this.uploadEmail = uploadEmail;
    }

    public Site config(@Nullable SiteConfig config) {
        this.config = config;
        return this;
    }

    @Nullable
    public SiteConfig getConfig() {
        return this.config;
    }

    public void setConfig(@Nullable SiteConfig config) {
        this.config = config;
    }

    public Site usage(@Nullable SiteUsage usage) {
        this.usage = usage;
        return this;
    }

    @Nullable
    public SiteUsage getUsage() {
        return this.usage;
    }

    public void setUsage(@Nullable SiteUsage usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Site site = (Site)o;
        return Objects.equals(this.siteId, site.siteId) && Objects.equals(this.title, site.title) && Objects.equals((Object)this.status, (Object)site.status) && Objects.equals((Object)this.permission, (Object)site.permission) && Objects.equals(this.permissions, site.permissions) && Objects.equals(this.uploadEmail, site.uploadEmail) && Objects.equals(this.config, site.config) && Objects.equals(this.usage, site.usage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.siteId, this.title, this.status, this.permission, this.permissions, this.uploadEmail, this.config, this.usage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Site {\n");
        sb.append("    siteId: ").append(this.toIndentedString(this.siteId)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString((Object)this.permission)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    uploadEmail: ").append(this.toIndentedString(this.uploadEmail)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Site is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Site` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_SITE_ID) != null && !jsonObj.get(SERIALIZED_NAME_SITE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SITE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `siteId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SITE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            SiteStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PERMISSION) != null && !jsonObj.get(SERIALIZED_NAME_PERMISSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PERMISSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `permission` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PERMISSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PERMISSION) != null && !jsonObj.get(SERIALIZED_NAME_PERMISSION).isJsonNull()) {
            PermissionEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PERMISSION));
        }
        if (jsonObj.get(SERIALIZED_NAME_PERMISSIONS) != null && !jsonObj.get(SERIALIZED_NAME_PERMISSIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PERMISSIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `permissions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PERMISSIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UPLOAD_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_UPLOAD_EMAIL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UPLOAD_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uploadEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UPLOAD_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonNull()) {
            SiteConfig.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_USAGE) != null && !jsonObj.get(SERIALIZED_NAME_USAGE).isJsonNull()) {
            SiteUsage.validateJsonElement(jsonObj.get(SERIALIZED_NAME_USAGE));
        }
    }

    public static Site fromJson(String jsonString) throws IOException {
        return (Site)JSON.getGson().fromJson(jsonString, Site.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SITE_ID);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_PERMISSION);
        openapiFields.add(SERIALIZED_NAME_PERMISSIONS);
        openapiFields.add(SERIALIZED_NAME_UPLOAD_EMAIL);
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_USAGE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Site.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Site.class));
            return new TypeAdapter<Site>(){

                public void write(JsonWriter out, Site value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Site read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Site.validateJsonElement(jsonElement);
                    return (Site)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PermissionEnum {
        READ_WRITE("READ_WRITE"),
        READ_ONLY("READ_ONLY");

        private String value;

        private PermissionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PermissionEnum fromValue(String value) {
            for (PermissionEnum b : PermissionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            PermissionEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<PermissionEnum> {
            public void write(JsonWriter jsonWriter, PermissionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PermissionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PermissionEnum.fromValue(value);
            }
        }
    }
}

