/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.graalvm.processors;

import com.formkiq.graalvm.annotations.Reflectable;
import com.formkiq.graalvm.annotations.ReflectableClass;
import com.formkiq.graalvm.annotations.ReflectableClasses;
import com.formkiq.graalvm.annotations.ReflectableField;
import com.formkiq.graalvm.annotations.ReflectableImport;
import com.formkiq.graalvm.processors.Reflect;
import com.google.auto.service.AutoService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.formkiq.graalvm.annotations.Reflectable", "com.formkiq.graalvm.annotations.ReflectableImport", "com.formkiq.graalvm.annotations.ReflectableClasses", "com.formkiq.graalvm.annotations.ReflectableClass", "com.formkiq.graalvm.annotations.ReflectableClass.ReflectableClasses"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@AutoService(value={Processor.class})
public class GraalvmReflectAnnontationProcessor
extends AbstractProcessor {
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final Logger LOGGER = Logger.getLogger(GraalvmReflectAnnontationProcessor.class.getName());
    private static final Level LOGLEVEL = Level.INFO;
    private static final char PACKAGE_SEPARATOR = '.';
    private Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private Map<String, Reflect> reflects = new HashMap<String, Reflect>();

    private TypeElement asTypeElement(TypeMirror typeMirror) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        return (TypeElement)typeUtils.asElement(typeMirror);
    }

    private List<String> findClasses(Element element, String key) {
        ArrayList<String> classNames = new ArrayList<String>();
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                String simpleNameKey = entry.getKey().getSimpleName().toString();
                Object value = entry.getValue().getValue();
                if (!key.equals(simpleNameKey)) continue;
                List typeMirrors = (List)value;
                for (AnnotationValue val : typeMirrors) {
                    String clazz = ((TypeMirror)val.getValue()).toString();
                    LOGGER.log(LOGLEVEL, "processing ImportedClass " + clazz);
                    this.processImportedClass(clazz);
                }
            }
        }
        return classNames;
    }

    private Class<?> forName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = name.substring(0, lastDotIndex) + "$" + name.substring(lastDotIndex + 1);
                return this.forName(innerClassName);
            }
            throw e;
        }
    }

    String generateReflectConfigPath(Set<String> keys) {
        Set strings = keys.stream().map(m -> this.removePartsContainingDotFollowedByCapital((String)m)).filter(m -> m != null && m.length() > 1).collect(Collectors.toSet());
        if (strings.isEmpty()) {
            strings.add("default");
        }
        int shortestLength = strings.stream().mapToInt(String::length).min().getAsInt();
        List list = strings.stream().filter(s -> s.length() == shortestLength).sorted().collect(Collectors.toList());
        return (String)list.get(0);
    }

    private String getClassNameByType(Element element) {
        Object className = null;
        switch (element.getKind()) {
            case FIELD: 
            case CONSTRUCTOR: 
            case METHOD: {
                className = ((TypeElement)element.getEnclosingElement()).getQualifiedName().toString();
                break;
            }
            case ENUM: 
            case CLASS: {
                String e;
                int pos;
                TypeElement te = (TypeElement)element;
                ArrayList<String> simpleNames = new ArrayList<String>();
                for (Element result = element; result != null && ElementKind.CLASS.equals((Object)result.getKind()); result = result.getEnclosingElement()) {
                    simpleNames.add(0, result.getSimpleName().toString());
                }
                className = te.getQualifiedName().toString();
                if (simpleNames.isEmpty() || (pos = (e = element.getEnclosingElement().toString()).indexOf((String)simpleNames.get(0))) <= 0) break;
                className = e.substring(0, pos) + simpleNames.stream().collect(Collectors.joining("$"));
                break;
            }
        }
        return className;
    }

    private Reflect getReflect(String className) {
        Reflect reflect = this.reflects.getOrDefault(className, null);
        if (reflect == null) {
            reflect = new Reflect();
            this.reflects.put(className, reflect);
            LOGGER.log(LOGLEVEL, "creating new Element");
        } else {
            LOGGER.log(LOGLEVEL, "appending to previous Element");
        }
        reflect.name(className);
        return reflect;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.writeOutput();
        } else {
            this.processingReflectableImports(roundEnv);
            this.processingReflectable(roundEnv);
            this.processReflectableClasses(roundEnv);
        }
        return true;
    }

    private Reflect processClass(Reflect reflect, Reflectable reflectable) {
        LOGGER.log(LOGLEVEL, "processClass " + reflect.name());
        reflect.allDeclaredConstructors(reflectable.allDeclaredConstructors()).allDeclaredFields(reflectable.allDeclaredFields()).allDeclaredMethods(reflectable.allDeclaredMethods()).allPublicConstructors(reflectable.allPublicConstructors()).allPublicFields(reflectable.allPublicFields()).allPublicMethods(reflectable.allPublicMethods());
        return reflect;
    }

    private Reflect processClass(Reflect reflect, ReflectableClass reflectable) {
        LOGGER.log(LOGLEVEL, "processClass " + reflect.name());
        reflect.allDeclaredConstructors(reflectable.allDeclaredConstructors()).allDeclaredFields(reflectable.allDeclaredFields()).allDeclaredMethods(reflectable.allDeclaredMethods()).allPublicConstructors(reflectable.allPublicConstructors()).allPublicFields(reflectable.allPublicFields()).allPublicMethods(reflectable.allPublicMethods());
        return reflect;
    }

    private void processImportedClass(String clazz) {
        try {
            Reflectable reflection;
            Class<?> forName = Class.forName(clazz);
            Reflectable reflectable = forName.getAnnotation(Reflectable.class);
            Reflect reflect = this.getReflect(clazz);
            if (reflectable != null) {
                this.processClass(reflect, reflectable);
            }
            for (Field field : forName.getDeclaredFields()) {
                reflection = field.getAnnotation(Reflectable.class);
                if (reflection == null) continue;
                LOGGER.log(LOGLEVEL, "adding Field " + field.getName() + " to " + clazz);
                reflect.addField(field.getName(), reflection.allowWrite(), false);
            }
            for (AccessibleObject accessibleObject : forName.getMethods()) {
                reflection = ((Method)accessibleObject).getAnnotation(Reflectable.class);
                if (reflection == null) continue;
                List<String> parameterTypes = Arrays.asList(((Executable)accessibleObject).getParameters()).stream().map(p -> p.getParameterizedType().getTypeName()).collect(Collectors.toList());
                LOGGER.log(LOGLEVEL, "adding Method " + ((Method)accessibleObject).getName() + " to " + clazz);
                reflect.addMethod(((Method)accessibleObject).getName(), parameterTypes);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void processImportedClasses(Element element) {
        List<String> classNames = this.findClasses(element, "classes");
        for (String clazz : classNames) {
            LOGGER.log(LOGLEVEL, "processing ImportedClass " + clazz);
            this.processImportedClass(clazz);
        }
    }

    private void processImportFiles(Element element) {
        ReflectableImport[] reflectImports;
        for (ReflectableImport reflectImport : reflectImports = (ReflectableImport[])element.getAnnotationsByType(ReflectableImport.class)) {
            for (String file : reflectImport.files()) {
                if (file.length() <= 0) continue;
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    URL resource = classLoader.getResource(file);
                    String data = Files.readString(new File(resource.getFile()).toPath());
                    List list = (List)this.gson.fromJson(data, List.class);
                    for (Map map : list) {
                        Reflect reflect = this.getReflect(map.get("name").toString());
                        reflect.data(map);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void processingReflectable(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Reflectable.class)) {
            String className = this.getClassNameByType(element);
            LOGGER.log(LOGLEVEL, "processing 'Reflectable' annotation on class " + className);
            Reflectable[] reflectables = (Reflectable[])element.getAnnotationsByType(Reflectable.class);
            Reflect reflect = this.getReflect(className);
            block6: for (Reflectable reflectable : reflectables) {
                switch (element.getKind()) {
                    case FIELD: {
                        String fieldName = element.getSimpleName().toString();
                        LOGGER.log(LOGLEVEL, "adding Field " + fieldName + " to " + className);
                        reflect.addField(fieldName, reflectable.allowWrite(), false);
                        continue block6;
                    }
                    case CONSTRUCTOR: 
                    case METHOD: {
                        String methodName = element.getSimpleName().toString();
                        List<String> parameterTypes = ((ExecutableElement)element).getParameters().stream().map(param -> param.asType().toString()).collect(Collectors.toList());
                        LOGGER.log(LOGLEVEL, "adding Method " + methodName + " to " + className);
                        reflect.addMethod(methodName, parameterTypes);
                        continue block6;
                    }
                    case ENUM: 
                    case CLASS: {
                        reflect = this.processClass(reflect, reflectable);
                        continue block6;
                    }
                }
            }
        }
    }

    private void processingReflectableImports(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(ReflectableImport.class)) {
            this.processImportedClasses(element);
            this.processImportFiles(element);
        }
    }

    private void processReflectableClass(ReflectableClass reflectable) {
        String className = null;
        try {
            reflectable.className();
        }
        catch (MirroredTypeException e) {
            TypeMirror typeMirror = e.getTypeMirror();
            TypeElement asTypeElement = this.asTypeElement(typeMirror);
            className = asTypeElement.getQualifiedName().toString();
            try {
                className = this.forName(className).getName();
            }
            catch (ClassNotFoundException ee) {
                LOGGER.log(Level.WARNING, "cannot find class " + className);
            }
        }
        Reflect reflect = this.getReflect(className);
        reflect = this.processClass(reflect, reflectable);
        for (ReflectableField reflectableField : reflectable.fields()) {
            LOGGER.log(LOGLEVEL, "adding Field " + reflectableField.name() + " to " + className);
            reflect.addField(reflectableField.name(), reflectableField.allowWrite(), reflectableField.allowUnsafeAccess());
        }
        for (ReflectableField reflectableField : reflectable.methods()) {
            LOGGER.log(LOGLEVEL, "adding Method " + reflectableField.name() + " to " + className);
            reflect.addMethod(reflectableField.name(), Arrays.asList(reflectableField.parameterTypes()));
        }
    }

    private void processReflectableClasses(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(ReflectableClasses.class)) {
            ReflectableClasses[] reflectables;
            String string = this.getClassNameByType(element);
            LOGGER.log(LOGLEVEL, "processing 'ReflectableClasses' annotation on class " + string);
            for (ReflectableClasses reflectable : reflectables = (ReflectableClasses[])element.getAnnotationsByType(ReflectableClasses.class)) {
                ReflectableClass[] classes;
                for (ReflectableClass clazz : classes = reflectable.value()) {
                    this.processReflectableClass(clazz);
                }
            }
        }
        Set<? extends Element> reflectableClasses = roundEnv.getElementsAnnotatedWithAny(Set.of(ReflectableClass.class, ReflectableClass.ReflectableClasses.class));
        for (Element element : reflectableClasses) {
            ReflectableClass[] reflectables;
            String className = this.getClassNameByType(element);
            LOGGER.log(LOGLEVEL, "processing 'ReflectableClasses' annotation on class " + className);
            for (ReflectableClass clazz : reflectables = (ReflectableClass[])element.getAnnotationsByType(ReflectableClass.class)) {
                this.processReflectableClass(clazz);
            }
        }
    }

    private String removePartsContainingDotFollowedByCapital(String input) {
        return Arrays.stream(input.split("\\.")).filter(part -> !part.matches("\\p{Upper}.*")).collect(Collectors.joining("."));
    }

    private void writeOutput() {
        try {
            String name = this.generateReflectConfigPath(this.reflects.keySet());
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/native-image/" + name + "/reflect-config.json", new Element[0]);
            List data = this.reflects.values().stream().map(r -> r.data()).collect(Collectors.toList());
            try (OutputStreamWriter w = new OutputStreamWriter(file.openOutputStream(), "UTF-8");){
                w.write(this.gson.toJson(data));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

