/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.stacks.client;

import com.formkiq.stacks.client.HttpService;
import com.formkiq.stacks.client.HttpServiceJava;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.regions.Region;

public class FormKiqClientConnection {
    private String apiRestUrl;
    private Optional<Region> awsregion = Optional.empty();
    private Optional<AwsCredentials> awscredentials = Optional.empty();
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public FormKiqClientConnection(String restUrl) {
        this.apiRestUrl = restUrl;
    }

    public FormKiqClientConnection cognitoIdToken(String token) {
        this.headers.put("Authorization", Arrays.asList(token));
        return this;
    }

    public FormKiqClientConnection region(Region region) {
        this.awsregion = Optional.of(region);
        return this;
    }

    public FormKiqClientConnection credentials(AwsCredentials credentials) {
        this.awscredentials = Optional.of(credentials);
        return this;
    }

    public HttpService build() {
        HttpServiceJava http = new HttpServiceJava().headers(this.headers);
        this.awsregion.ifPresent(r -> http.signingRegion((Region)r));
        this.awscredentials.ifPresent(c -> http.credentials((AwsCredentials)c));
        return http;
    }

    public FormKiqClientConnection header(String key, List<String> values) {
        this.headers.put(key, values);
        return this;
    }

    public String apiRestUrl() {
        return this.apiRestUrl;
    }
}

