/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.stacks.client.requests;

import com.formkiq.stacks.client.ApiRequest;
import com.formkiq.stacks.client.Validate;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DeleteDocumentTagRequest
implements ApiRequest {
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> paths = new HashMap<String, String>();

    @Override
    public void addQueryParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public DeleteDocumentTagRequest documentId(String documentId) {
        this.paths.put("documentId", documentId);
        return this;
    }

    @Override
    public Optional<Map<String, List<String>>> getHttpHeaders() {
        return Optional.empty();
    }

    @Override
    public Map<String, String> getQueryParameters() {
        return this.parameters;
    }

    @Override
    public String getUrlPath() throws IOException {
        String url = "documents/" + this.paths.get("documentId") + "/tags/" + this.encodeValue(this.paths.get("tagKey"));
        if (this.paths.containsKey("tagValue")) {
            url = url + "/" + this.encodeValue(this.paths.get("tagValue"));
        }
        return url;
    }

    public DeleteDocumentTagRequest siteId(String siteId) {
        this.parameters.put("siteId", siteId);
        return this;
    }

    public DeleteDocumentTagRequest tagKey(String tagKey) {
        this.paths.put("tagKey", tagKey);
        return this;
    }

    public DeleteDocumentTagRequest tagValue(String tagValue) {
        this.paths.put("tagValue", tagValue);
        return this;
    }

    @Override
    public void validate() {
        Validate.notNull(this.paths.get("documentId"), "DocumentId is required.", new Object[0]);
        Validate.notNull(this.paths.get("tagKey"), "TagKey is required.", new Object[0]);
    }

    public DeleteDocumentTagRequest webnotify(boolean webnotify) {
        this.parameters.put("webnotify", String.valueOf(webnotify));
        return this;
    }
}

