/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.stacks.client.requests;

import com.formkiq.stacks.client.ApiRequest;
import com.formkiq.stacks.client.Validate;
import com.formkiq.stacks.client.models.DocumentSearchQuery;
import com.formkiq.stacks.client.models.DocumentSearchResponseFields;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SearchDocumentsRequest
implements ApiRequest {
    private Map<String, String> parameters = new HashMap<String, String>();
    private DocumentSearchQuery query = null;
    private DocumentSearchResponseFields responseFields = null;

    @Override
    public void addQueryParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    @Override
    public Optional<Map<String, List<String>>> getHttpHeaders() {
        return Optional.empty();
    }

    @Override
    public Map<String, String> getQueryParameters() {
        return this.parameters;
    }

    @Override
    public String getUrlPath() {
        return "search";
    }

    public SearchDocumentsRequest limit(int limit) {
        this.parameters.put("limit", "" + limit);
        return this;
    }

    public SearchDocumentsRequest next(String next) {
        this.parameters.put("next", next);
        return this;
    }

    public SearchDocumentsRequest previous(String previous) {
        this.parameters.put("previous", previous);
        return this;
    }

    public DocumentSearchQuery query() {
        return this.query;
    }

    public SearchDocumentsRequest query(DocumentSearchQuery searchQuery) {
        this.query = searchQuery;
        return this;
    }

    public DocumentSearchResponseFields responseFields() {
        return this.responseFields;
    }

    public SearchDocumentsRequest responseFields(DocumentSearchResponseFields response) {
        this.responseFields = response;
        return this;
    }

    public SearchDocumentsRequest siteId(String siteId) {
        this.parameters.put("siteId", siteId);
        return this;
    }

    @Override
    public void validate() {
        Validate.notNull(this.query, "Query is required.", new Object[0]);
    }
}

