/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.stacks.client;

import com.formkiq.stacks.client.FormKiqClient;
import com.formkiq.stacks.client.FormKiqClientConnection;
import com.formkiq.stacks.client.HttpService;
import com.formkiq.stacks.client.models.AddDocumentResponse;
import com.formkiq.stacks.client.models.AddTagSchemaResponse;
import com.formkiq.stacks.client.models.AddWebhookResponse;
import com.formkiq.stacks.client.models.DocumentActions;
import com.formkiq.stacks.client.models.DocumentContent;
import com.formkiq.stacks.client.models.DocumentFulltext;
import com.formkiq.stacks.client.models.DocumentOcr;
import com.formkiq.stacks.client.models.DocumentSearchQuery;
import com.formkiq.stacks.client.models.DocumentTag;
import com.formkiq.stacks.client.models.DocumentTags;
import com.formkiq.stacks.client.models.DocumentUrl;
import com.formkiq.stacks.client.models.DocumentVersions;
import com.formkiq.stacks.client.models.DocumentWithChildren;
import com.formkiq.stacks.client.models.Documents;
import com.formkiq.stacks.client.models.FulltextDocuments;
import com.formkiq.stacks.client.models.Sites;
import com.formkiq.stacks.client.models.TagSchema;
import com.formkiq.stacks.client.models.TagSchemaSummaries;
import com.formkiq.stacks.client.models.UpdateDocumentResponse;
import com.formkiq.stacks.client.models.Version;
import com.formkiq.stacks.client.models.WebhookTags;
import com.formkiq.stacks.client.models.Webhooks;
import com.formkiq.stacks.client.requests.AddDocumentOcrRequest;
import com.formkiq.stacks.client.requests.AddDocumentRequest;
import com.formkiq.stacks.client.requests.AddDocumentTagRequest;
import com.formkiq.stacks.client.requests.AddLargeDocumentRequest;
import com.formkiq.stacks.client.requests.AddTagSchemaRequest;
import com.formkiq.stacks.client.requests.AddWebhookRequest;
import com.formkiq.stacks.client.requests.AddWebhookTagRequest;
import com.formkiq.stacks.client.requests.DeleteDocumentFulltextRequest;
import com.formkiq.stacks.client.requests.DeleteDocumentOcrRequest;
import com.formkiq.stacks.client.requests.DeleteDocumentRequest;
import com.formkiq.stacks.client.requests.DeleteDocumentTagRequest;
import com.formkiq.stacks.client.requests.DeleteFulltextTagsRequest;
import com.formkiq.stacks.client.requests.DeleteTagSchemaRequest;
import com.formkiq.stacks.client.requests.DeleteWebhookRequest;
import com.formkiq.stacks.client.requests.DocumentFormatSearchRequest;
import com.formkiq.stacks.client.requests.GetDocumentActionsRequest;
import com.formkiq.stacks.client.requests.GetDocumentContentRequest;
import com.formkiq.stacks.client.requests.GetDocumentContentUrlRequest;
import com.formkiq.stacks.client.requests.GetDocumentFulltextRequest;
import com.formkiq.stacks.client.requests.GetDocumentOcrRequest;
import com.formkiq.stacks.client.requests.GetDocumentRequest;
import com.formkiq.stacks.client.requests.GetDocumentTagsKeyRequest;
import com.formkiq.stacks.client.requests.GetDocumentTagsRequest;
import com.formkiq.stacks.client.requests.GetDocumentUploadRequest;
import com.formkiq.stacks.client.requests.GetDocumentVersionsRequest;
import com.formkiq.stacks.client.requests.GetDocumentsRequest;
import com.formkiq.stacks.client.requests.GetTagSchemaRequest;
import com.formkiq.stacks.client.requests.GetTagSchemasRequest;
import com.formkiq.stacks.client.requests.GetWebhookTagsRequest;
import com.formkiq.stacks.client.requests.GetWebhooksRequest;
import com.formkiq.stacks.client.requests.OcrParseType;
import com.formkiq.stacks.client.requests.OptionsDocumentContentRequest;
import com.formkiq.stacks.client.requests.OptionsDocumentContentUrlRequest;
import com.formkiq.stacks.client.requests.OptionsDocumentFormatRequest;
import com.formkiq.stacks.client.requests.OptionsDocumentRequest;
import com.formkiq.stacks.client.requests.OptionsDocumentTagsKeyRequest;
import com.formkiq.stacks.client.requests.OptionsDocumentTagsRequest;
import com.formkiq.stacks.client.requests.OptionsDocumentUploadRequest;
import com.formkiq.stacks.client.requests.OptionsDocumentVersionsRequest;
import com.formkiq.stacks.client.requests.OptionsWebhookRequest;
import com.formkiq.stacks.client.requests.OptionsWebhookTagsRequest;
import com.formkiq.stacks.client.requests.SearchDocumentsRequest;
import com.formkiq.stacks.client.requests.SearchFulltextRequest;
import com.formkiq.stacks.client.requests.SetDocumentAntivirusRequest;
import com.formkiq.stacks.client.requests.SetDocumentFulltextRequest;
import com.formkiq.stacks.client.requests.SetDocumentOcrRequest;
import com.formkiq.stacks.client.requests.SitesRequest;
import com.formkiq.stacks.client.requests.UpdateDocumentFulltextRequest;
import com.formkiq.stacks.client.requests.UpdateDocumentRequest;
import com.formkiq.stacks.client.requests.UpdateDocumentTagKeyRequest;
import com.formkiq.stacks.client.requests.VersionRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import software.amazon.awssdk.core.sync.RequestBody;

public class FormKiqClientV1
implements FormKiqClient {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final int HTTP_STATUS_MULTIPLE_CHOICES = 300;
    private static final int HTTP_STATUS_OK = 200;
    private String apiRestUrl;
    private HttpService client;
    private Gson gson;

    public FormKiqClientV1(FormKiqClientConnection connection) {
        this.client = connection.build();
        this.apiRestUrl = connection.apiRestUrl().replaceAll("/$", "");
        this.gson = new GsonBuilder().disableHtmlEscaping().setDateFormat(DATE_FORMAT).create();
    }

    @Override
    public AddDocumentResponse addDocument(AddDocumentRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.addDocumentAsHttpResponse(request);
        this.checkStatusCode(response);
        return (AddDocumentResponse)this.gson.fromJson(response.body(), AddDocumentResponse.class);
    }

    public HttpResponse<String> addDocumentAsHttpResponse(AddDocumentRequest request) throws IOException, InterruptedException {
        String body = this.gson.toJson((Object)request.document());
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.post(u, this.createHttpHeaders("POST", this.buildHeaders(request.document().contentType())), RequestBody.fromString((String)body));
    }

    public HttpResponse<String> addDocumentFormatAsHttpResponse(DocumentFormatSearchRequest request) throws IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mime", request.mime());
        if (request.versionId() != null) {
            map.put("versionId", request.versionId());
        }
        String contents = this.gson.toJson(map);
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.post(u, this.createHttpHeaders("POST", Optional.empty()), RequestBody.fromString((String)contents));
    }

    public HttpResponse<String> addDocumentFulltextAsHttpResponse(SetDocumentFulltextRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contentType", request.document().contentType());
        map.put("content", request.document().content());
        map.put("contentUrls", request.document().contentUrls());
        String contents = this.gson.toJson(map);
        return this.client.put(u, this.createHttpHeaders("PUT", Optional.empty()), RequestBody.fromString((String)contents));
    }

    @Override
    public void addDocumentOcr(AddDocumentOcrRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.addDocumentOcrAsHttpResponse(request);
        this.checkStatusCode(response);
    }

    public HttpResponse<String> addDocumentOcrAsHttpResponse(AddDocumentOcrRequest request) throws IOException, InterruptedException {
        HashMap<String, List<OcrParseType>> map = new HashMap<String, List<OcrParseType>>();
        if (request.parseTypes() != null) {
            map.put("parseTypes", request.parseTypes());
        }
        String contents = this.gson.toJson(map);
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.post(u, this.createHttpHeaders("POST", Optional.empty()), RequestBody.fromString((String)contents));
    }

    public HttpResponse<String> addDocumentOcrAsHttpResponse(SetDocumentOcrRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contentType", request.document().contentType());
        map.put("content", request.document().content());
        String contents = this.gson.toJson(map);
        return this.client.put(u, this.createHttpHeaders("PUT", Optional.empty()), RequestBody.fromString((String)contents));
    }

    @Override
    public boolean addDocumentTag(AddDocumentTagRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.addDocumentTagAsHttpResponse(request);
        return this.checkStatusCodeBoolean(response);
    }

    public HttpResponse<String> addDocumentTagAsHttpResponse(AddDocumentTagRequest request) throws IOException, InterruptedException {
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (!request.tags().isEmpty()) {
            body.put("tags", request.tags());
        } else {
            body.put("key", request.tagKey());
            body.put("value", request.tagValue());
            body.put("values", request.tagValues());
        }
        String contents = this.gson.toJson(body);
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.post(u, this.createHttpHeaders("POST", Optional.empty()), RequestBody.fromString((String)contents));
    }

    @Override
    public DocumentUrl addLargeDocument(AddLargeDocumentRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.addLargeDocumentAsHttpResponse(request);
        this.checkStatusCode(response);
        return (DocumentUrl)this.gson.fromJson(response.body(), DocumentUrl.class);
    }

    public HttpResponse<String> addLargeDocumentAsHttpResponse(AddLargeDocumentRequest request) throws IOException, InterruptedException {
        String body = this.gson.toJson((Object)request.document());
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.post(u, this.createHttpHeaders("POST", Optional.empty()), RequestBody.fromString((String)body));
    }

    @Override
    public AddTagSchemaResponse addTagSchema(AddTagSchemaRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.addTagSchemaAsHttpResponse(request);
        this.checkStatusCode(response);
        return (AddTagSchemaResponse)this.gson.fromJson(response.body(), AddTagSchemaResponse.class);
    }

    public HttpResponse<String> addTagSchemaAsHttpResponse(AddTagSchemaRequest request) throws IOException, InterruptedException {
        String body = this.gson.toJson((Object)request.tagSchema());
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.post(u, this.createHttpHeaders("POST", Optional.empty()), RequestBody.fromString((String)body));
    }

    @Override
    public AddWebhookResponse addWebhook(AddWebhookRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.addWebhookAsHttpResponse(request);
        this.checkStatusCode(response);
        return (AddWebhookResponse)this.gson.fromJson(response.body(), AddWebhookResponse.class);
    }

    public HttpResponse<String> addWebhookAsHttpResponse(AddWebhookRequest request) throws IOException, InterruptedException {
        String body = this.gson.toJson(Map.of("name", request.name(), "enabled", request.enabled()));
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.post(u, Optional.empty(), RequestBody.fromString((String)body));
    }

    @Override
    public boolean addWebhookTag(AddWebhookTagRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.addWebhookTagAsHttpResponse(request);
        return this.checkStatusCodeBoolean(response);
    }

    public HttpResponse<String> addWebhookTagAsHttpResponse(AddWebhookTagRequest request) throws IOException, InterruptedException {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("key", request.tagKey());
        body.put("value", request.tagValue());
        String contents = this.gson.toJson(body);
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.post(u, this.createHttpHeaders("POST", Optional.empty()), RequestBody.fromString((String)contents));
    }

    private Optional<Map<String, List<String>>> buildHeaders(String contentType) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (contentType != null) {
            headers.put("Content-Type", Arrays.asList(contentType));
        }
        return !headers.isEmpty() ? Optional.of(headers) : Optional.empty();
    }

    private void checkStatusCode(HttpResponse<?> response) throws IOException {
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            throw new IOException("unexpected response code: " + response.statusCode());
        }
    }

    private boolean checkStatusCodeBoolean(HttpResponse<String> response) {
        try {
            this.checkStatusCode(response);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private Optional<HttpHeaders> createHttpHeaders(String method, Optional<Map<String, List<String>>> additionalHeaders) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        additionalHeaders.ifPresent(h -> h.entrySet().forEach(e -> headers.put((String)e.getKey(), (List)e.getValue())));
        return headers.size() > 0 ? Optional.of(HttpHeaders.of(headers, new BiPredicate<String, String>(){

            @Override
            public boolean test(String t, String u) {
                return true;
            }
        })) : Optional.empty();
    }

    @Override
    public boolean deleteDocument(DeleteDocumentRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.deleteDocumentAsHttpResponse(request);
        return this.checkStatusCodeBoolean(response);
    }

    public HttpResponse<String> deleteDocumentAsHttpResponse(DeleteDocumentRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.delete(u, this.createHttpHeaders("DELETE", Optional.empty()));
    }

    @Override
    public boolean deleteDocumentFulltext(DeleteDocumentFulltextRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.deleteDocumentFulltextAsHttpResponse(request);
        return this.checkStatusCodeBoolean(response);
    }

    public HttpResponse<String> deleteDocumentFulltextAsHttpResponse(DeleteDocumentFulltextRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.delete(u, this.createHttpHeaders("DELETE", Optional.empty()));
    }

    @Override
    public boolean deleteDocumentOcr(DeleteDocumentOcrRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.deleteDocumentOcrAsHttpResponse(request);
        return this.checkStatusCodeBoolean(response);
    }

    public HttpResponse<String> deleteDocumentOcrAsHttpResponse(DeleteDocumentOcrRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.delete(u, this.createHttpHeaders("DELETE", Optional.empty()));
    }

    @Override
    public boolean deleteDocumentTag(DeleteDocumentTagRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.deleteDocumentTagAsHttpResponse(request);
        return this.checkStatusCodeBoolean(response);
    }

    public HttpResponse<String> deleteDocumentTagAsHttpResponse(DeleteDocumentTagRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.delete(u, this.createHttpHeaders("DELETE", Optional.empty()));
    }

    @Override
    public boolean deleteFulltextTags(DeleteFulltextTagsRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.deleteFulltextTagsAsHttpResponse(request);
        return this.checkStatusCodeBoolean(response);
    }

    public HttpResponse<String> deleteFulltextTagsAsHttpResponse(DeleteFulltextTagsRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.delete(u, this.createHttpHeaders("DELETE", Optional.empty()));
    }

    @Override
    public boolean deleteTagSchema(DeleteTagSchemaRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.deleteTagSchemaAsHttpResponse(request);
        return this.checkStatusCodeBoolean(response);
    }

    public HttpResponse<String> deleteTagSchemaAsHttpResponse(DeleteTagSchemaRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.delete(u, this.createHttpHeaders("DELETE", Optional.empty()));
    }

    @Override
    public boolean deleteWebhook(DeleteWebhookRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.deleteWebhookAsHttpResponse(request);
        return this.checkStatusCodeBoolean(response);
    }

    public HttpResponse<String> deleteWebhookAsHttpResponse(DeleteWebhookRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.delete(u, this.createHttpHeaders("DELETE", Optional.empty()));
    }

    @Override
    public DocumentWithChildren getDocument(GetDocumentRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getDocumentAsHttpResponse(request);
        this.checkStatusCode(response);
        return (DocumentWithChildren)this.gson.fromJson(response.body(), DocumentWithChildren.class);
    }

    @Override
    public DocumentActions getDocumentActions(GetDocumentActionsRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getDocumentActionsAsHttpResponse(request);
        this.checkStatusCode(response);
        return (DocumentActions)this.gson.fromJson(response.body(), DocumentActions.class);
    }

    public HttpResponse<String> getDocumentActionsAsHttpResponse(GetDocumentActionsRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", request.getHttpHeaders()));
    }

    public HttpResponse<String> getDocumentAsHttpResponse(GetDocumentRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    public DocumentContent getDocumentContent(GetDocumentContentRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getDocumentContentAsHttpResponse(request);
        this.checkStatusCode(response);
        return (DocumentContent)this.gson.fromJson(response.body(), DocumentContent.class);
    }

    public HttpResponse<String> getDocumentContentAsHttpResponse(GetDocumentContentRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", request.getHttpHeaders()));
    }

    @Override
    public DocumentUrl getDocumentContentUrl(GetDocumentContentUrlRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getDocumentContentUrlAsHttpResponse(request);
        this.checkStatusCode(response);
        return (DocumentUrl)this.gson.fromJson(response.body(), DocumentUrl.class);
    }

    public HttpResponse<String> getDocumentContentUrlAsHttpResponse(GetDocumentContentUrlRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public DocumentFulltext getDocumentFulltext(GetDocumentFulltextRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getDocumentFulltextAsHttpResponse(request);
        this.checkStatusCode(response);
        return (DocumentFulltext)this.gson.fromJson(response.body(), DocumentFulltext.class);
    }

    public HttpResponse<String> getDocumentFulltextAsHttpResponse(GetDocumentFulltextRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public DocumentOcr getDocumentOcr(GetDocumentOcrRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getDocumentOcrAsHttpResponse(request);
        this.checkStatusCode(response);
        return (DocumentOcr)this.gson.fromJson(response.body(), DocumentOcr.class);
    }

    public HttpResponse<String> getDocumentOcrAsHttpResponse(GetDocumentOcrRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public Documents getDocuments(GetDocumentsRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getDocumentsAsHttpResponse(request);
        this.checkStatusCode(response);
        return (Documents)this.gson.fromJson(response.body(), Documents.class);
    }

    public HttpResponse<String> getDocumentsAsHttpResponse(GetDocumentsRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public DocumentTag getDocumentTag(GetDocumentTagsKeyRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getDocumentTagAsHttpResponse(request);
        this.checkStatusCode(response);
        return (DocumentTag)this.gson.fromJson(response.body(), DocumentTag.class);
    }

    public HttpResponse<String> getDocumentTagAsHttpResponse(GetDocumentTagsKeyRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public DocumentTags getDocumentTags(GetDocumentTagsRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getDocumentTagsAsHttpResponse(request);
        this.checkStatusCode(response);
        return (DocumentTags)this.gson.fromJson(response.body(), DocumentTags.class);
    }

    public HttpResponse<String> getDocumentTagsAsHttpResponse(GetDocumentTagsRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public DocumentUrl getDocumentUpload(GetDocumentUploadRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getDocumentUploadAsHttpResponse(request);
        this.checkStatusCode(response);
        return (DocumentUrl)this.gson.fromJson(response.body(), DocumentUrl.class);
    }

    public HttpResponse<String> getDocumentUploadAsHttpResponse(GetDocumentUploadRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public DocumentVersions getDocumentVersions(GetDocumentVersionsRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getDocumentVersionsAsHttpResponse(request);
        this.checkStatusCode(response);
        return (DocumentVersions)this.gson.fromJson(response.body(), DocumentVersions.class);
    }

    public HttpResponse<String> getDocumentVersionsAsHttpResponse(GetDocumentVersionsRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public Sites getSites() throws IOException, InterruptedException {
        HttpResponse<String> response = this.getSitesAsHttpResponse();
        this.checkStatusCode(response);
        return (Sites)this.gson.fromJson(response.body(), Sites.class);
    }

    public HttpResponse<String> getSitesAsHttpResponse() throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + new SitesRequest().buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public TagSchema getTagSchema(GetTagSchemaRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getTagSchemaAsHttpResponse(request);
        this.checkStatusCode(response);
        return (TagSchema)this.gson.fromJson(response.body(), TagSchema.class);
    }

    public HttpResponse<String> getTagSchemaAsHttpResponse(GetTagSchemaRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public TagSchemaSummaries getTagSchemas(GetTagSchemasRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getTagSchemasAsHttpResponse(request);
        this.checkStatusCode(response);
        return (TagSchemaSummaries)this.gson.fromJson(response.body(), TagSchemaSummaries.class);
    }

    public HttpResponse<String> getTagSchemasAsHttpResponse(GetTagSchemasRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public Version getVersion() throws IOException, InterruptedException {
        HttpResponse<String> response = this.getVersionAsHttpResponse();
        this.checkStatusCode(response);
        return (Version)this.gson.fromJson(response.body(), Version.class);
    }

    public HttpResponse<String> getVersionAsHttpResponse() throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + new VersionRequest().buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public Webhooks getWebhooks(GetWebhooksRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getWebhooksAsHttpResponse(request);
        this.checkStatusCode(response);
        return (Webhooks)this.gson.fromJson(response.body(), Webhooks.class);
    }

    public HttpResponse<String> getWebhooksAsHttpResponse(GetWebhooksRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    @Override
    public WebhookTags getWebhookTags(GetWebhookTagsRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.getWebhookTagsAsHttpResponse(request);
        this.checkStatusCode(response);
        return (WebhookTags)this.gson.fromJson(response.body(), WebhookTags.class);
    }

    public HttpResponse<String> getWebhookTagsAsHttpResponse(GetWebhookTagsRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.get(u, this.createHttpHeaders("GET", Optional.empty()));
    }

    public HttpResponse<String> optionsDocument(OptionsDocumentRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsDocumentContent(OptionsDocumentContentRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsDocumentContentUrl(OptionsDocumentContentUrlRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsDocumentFormats(OptionsDocumentFormatRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsDocuments() throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + new GetDocumentsRequest().buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsDocumentTag(OptionsDocumentTagsKeyRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsDocumentTags(OptionsDocumentTagsRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsDocumentUpload() throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + new OptionsDocumentUploadRequest().buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsDocumentUpload(OptionsDocumentUploadRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsDocumentVersions(OptionsDocumentVersionsRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsSearch() throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + new SearchDocumentsRequest().query(new DocumentSearchQuery()).buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsSites() throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + new SitesRequest().buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsVersion() throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + new VersionRequest().buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsWebhooks() throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + new GetWebhooksRequest().buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsWebhooks(OptionsWebhookRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    public HttpResponse<String> optionsWebhookTags(OptionsWebhookTagsRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.options(u, this.createHttpHeaders("OPTIONS", Optional.empty()));
    }

    @Override
    public Documents search(SearchDocumentsRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.searchAsHttpResponse(request);
        this.checkStatusCode(response);
        return (Documents)this.gson.fromJson(response.body(), Documents.class);
    }

    public HttpResponse<String> searchAsFulltextHttpResponse(SearchFulltextRequest request) throws IOException, InterruptedException {
        request.validate();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("query", request.query());
        map.put("responseFields", request.responseFields());
        String contents = this.gson.toJson(map);
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.post(u, this.createHttpHeaders("POST", Optional.empty()), RequestBody.fromString((String)contents));
    }

    public HttpResponse<String> searchAsHttpResponse(SearchDocumentsRequest request) throws IOException, InterruptedException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("query", request.query());
        map.put("responseFields", request.responseFields());
        String contents = this.gson.toJson(map);
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.post(u, this.createHttpHeaders("POST", Optional.empty()), RequestBody.fromString((String)contents));
    }

    @Override
    public FulltextDocuments searchFulltext(SearchFulltextRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.searchAsFulltextHttpResponse(request);
        this.checkStatusCode(response);
        return (FulltextDocuments)this.gson.fromJson(response.body(), FulltextDocuments.class);
    }

    @Override
    public void setDocumentAntivirus(SetDocumentAntivirusRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.setDocumentAntivirusAsHttpResponse(request);
        this.checkStatusCode(response);
    }

    public HttpResponse<String> setDocumentAntivirusAsHttpResponse(SetDocumentAntivirusRequest request) throws IOException, InterruptedException {
        HashMap map = new HashMap();
        String contents = this.gson.toJson(map);
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.put(u, this.createHttpHeaders("PUT", Optional.empty()), RequestBody.fromString((String)contents));
    }

    @Override
    public void setDocumentFulltext(SetDocumentFulltextRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.addDocumentFulltextAsHttpResponse(request);
        this.checkStatusCode(response);
    }

    @Override
    public void setDocumentOcr(SetDocumentOcrRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.addDocumentOcrAsHttpResponse(request);
        this.checkStatusCode(response);
    }

    @Override
    public UpdateDocumentResponse updateDocument(UpdateDocumentRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.updateDocumentAsHttpResponse(request);
        this.checkStatusCode(response);
        return (UpdateDocumentResponse)this.gson.fromJson(response.body(), UpdateDocumentResponse.class);
    }

    public HttpResponse<String> updateDocumentAsHttpResponse(UpdateDocumentRequest request) throws IOException, InterruptedException {
        String body = this.gson.toJson((Object)request.document());
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.patch(u, this.createHttpHeaders("PATCH", this.buildHeaders(request.document().contentType())), RequestBody.fromString((String)body));
    }

    @Override
    public boolean updateDocumentFulltext(UpdateDocumentFulltextRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.updateDocumentFulltextAsHttpResponse(request);
        return this.checkStatusCodeBoolean(response);
    }

    public HttpResponse<String> updateDocumentFulltextAsHttpResponse(UpdateDocumentFulltextRequest request) throws IOException, InterruptedException {
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        String contents = this.gson.toJson((Object)request.document());
        return this.client.patch(u, this.createHttpHeaders("PATCH", Optional.empty()), RequestBody.fromString((String)contents));
    }

    @Override
    public boolean updateDocumentTag(UpdateDocumentTagKeyRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.updateDocumentTagAsHttpResponse(request);
        return this.checkStatusCodeBoolean(response);
    }

    public HttpResponse<String> updateDocumentTagAsHttpResponse(UpdateDocumentTagKeyRequest request) throws IOException, InterruptedException {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("value", request.tagValue());
        String contents = this.gson.toJson(body);
        String u = this.apiRestUrl + "/" + request.buildRequestUrl();
        return this.client.put(u, this.createHttpHeaders("PUT", Optional.empty()), RequestBody.fromString((String)contents));
    }
}

