/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.stacks.client;

import com.formkiq.stacks.client.HttpService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public class HttpServiceJava
implements HttpService {
    private static final Set<String> NOT_ALLOWED_HEADERS = Set.of("connection", "content-length", "date", "expect", "from", "host", "upgrade", "via", "warning");
    private HttpClient client;
    private Optional<Region> signingRegion = Optional.empty();
    private Optional<AwsCredentials> credentials = Optional.empty();
    private Map<String, List<String>> defaultHeaders = new HashMap<String, List<String>>();

    public HttpServiceJava() {
        this.client = HttpClient.newHttpClient();
    }

    private SdkHttpFullRequest.Builder buildRequest(String uri, SdkHttpMethod method, Optional<HttpHeaders> headers, Optional<RequestBody> payload) throws IOException {
        SdkHttpFullRequest.Builder requestBuilder = SdkHttpFullRequest.builder().uri(this.toUri(uri)).method(method);
        if (headers.isPresent()) {
            for (Map.Entry<String, List<String>> e : headers.get().map().entrySet()) {
                requestBuilder = requestBuilder.appendHeader(e.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)e.getValue()));
            }
        }
        for (Map.Entry<String, List<String>> e : this.defaultHeaders.entrySet()) {
            requestBuilder = requestBuilder.appendHeader(e.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)e.getValue()));
        }
        if (payload.isPresent()) {
            requestBuilder = requestBuilder.contentStreamProvider(payload.get().contentStreamProvider());
        }
        return requestBuilder;
    }

    @Override
    public Optional<AwsCredentials> credentials() {
        return this.credentials;
    }

    @Override
    public HttpServiceJava credentials(AwsCredentials cred) {
        this.credentials = cred != null ? Optional.of(cred) : Optional.empty();
        return this;
    }

    @Override
    public HttpResponse<String> delete(String uri, Optional<HttpHeaders> headers) throws IOException, InterruptedException {
        SdkHttpFullRequest.Builder request = this.buildRequest(uri, SdkHttpMethod.DELETE, headers, Optional.empty());
        SdkHttpFullRequest req = this.sign(request);
        return this.execute(req);
    }

    private HttpResponse<String> execute(SdkHttpFullRequest request) throws IOException, InterruptedException {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(request.getUri()).timeout(Duration.ofMinutes(1L));
        Map headers = request.headers();
        for (Map.Entry e : headers.entrySet()) {
            if (NOT_ALLOWED_HEADERS.contains(((String)e.getKey()).toLowerCase())) continue;
            String value = String.join((CharSequence)",", (Iterable)e.getValue());
            builder = builder.setHeader((String)e.getKey(), value);
        }
        switch (request.method()) {
            case GET: {
                builder = builder.GET();
                break;
            }
            case POST: 
            case PUT: 
            case PATCH: {
                InputStream is = ((ContentStreamProvider)request.contentStreamProvider().get()).newStream();
                builder = builder.method(request.method().name(), HttpRequest.BodyPublishers.ofInputStream(() -> is));
                break;
            }
            case DELETE: {
                builder = builder.DELETE();
                break;
            }
            default: {
                builder = builder.method(request.method().name(), HttpRequest.BodyPublishers.noBody());
            }
        }
        return this.client.send(builder.build(), HttpResponse.BodyHandlers.ofString());
    }

    @Override
    public HttpResponse<String> get(String uri, Optional<HttpHeaders> headers) throws IOException, InterruptedException {
        SdkHttpFullRequest.Builder request = this.buildRequest(uri, SdkHttpMethod.GET, headers, Optional.empty());
        SdkHttpFullRequest req = this.sign(request);
        return this.execute(req);
    }

    public HttpServiceJava headers(Map<String, List<String>> headers) {
        this.defaultHeaders = headers;
        return this;
    }

    @Override
    public HttpResponse<String> options(String uri, Optional<HttpHeaders> headers) throws IOException, InterruptedException {
        SdkHttpFullRequest.Builder request = this.buildRequest(uri, SdkHttpMethod.OPTIONS, headers, Optional.empty());
        SdkHttpFullRequest req = this.sign(request);
        return this.execute(req);
    }

    @Override
    public HttpResponse<String> patch(String uri, Optional<HttpHeaders> headers, RequestBody payload) throws IOException, InterruptedException {
        SdkHttpFullRequest.Builder request = this.buildRequest(uri, SdkHttpMethod.PATCH, headers, Optional.of(payload));
        SdkHttpFullRequest req = this.sign(request);
        return this.execute(req);
    }

    @Override
    public HttpResponse<String> post(String uri, Optional<HttpHeaders> headers, RequestBody payload) throws IOException, InterruptedException {
        SdkHttpFullRequest.Builder request = this.buildRequest(uri, SdkHttpMethod.POST, headers, Optional.of(payload));
        SdkHttpFullRequest req = this.sign(request);
        return this.execute(req);
    }

    @Override
    public HttpResponse<String> put(String uri, Optional<HttpHeaders> headers, RequestBody payload) throws IOException, InterruptedException {
        SdkHttpFullRequest.Builder request = this.buildRequest(uri, SdkHttpMethod.PUT, headers, Optional.of(payload));
        SdkHttpFullRequest req = this.sign(request);
        return this.execute(req);
    }

    private SdkHttpFullRequest sign(SdkHttpFullRequest.Builder request) {
        SdkHttpFullRequest req = request.build();
        if (this.signingRegion.isPresent() && this.credentials.isPresent()) {
            Aws4SignerParams params = Aws4SignerParams.builder().signingName("execute-api").signingRegion(this.signingRegion.get()).awsCredentials(this.credentials.get()).build();
            Aws4Signer signer = Aws4Signer.create();
            req = signer.sign(req, params);
        }
        return req;
    }

    @Override
    public Optional<Region> signingRegion() {
        return this.signingRegion;
    }

    @Override
    public HttpServiceJava signingRegion(Region region) {
        this.signingRegion = region != null ? Optional.of(region) : Optional.empty();
        return this;
    }

    private URI toUri(String uri) throws IOException {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }
}

