/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.stacks.client.requests;

import com.formkiq.stacks.client.ApiRequest;
import com.formkiq.stacks.client.Validate;
import com.formkiq.stacks.client.models.AddDocumentTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AddDocumentTagRequest
implements ApiRequest {
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> paths = new HashMap<String, String>();
    private AddDocumentTag tag = new AddDocumentTag();
    private List<AddDocumentTag> tags = new ArrayList<AddDocumentTag>();

    @Override
    public void addQueryParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public AddDocumentTagRequest documentId(String documentId) {
        this.paths.put("documentId", documentId);
        return this;
    }

    @Override
    public Optional<Map<String, List<String>>> getHttpHeaders() {
        return Optional.empty();
    }

    @Override
    public Map<String, String> getQueryParameters() {
        return this.parameters;
    }

    @Override
    public String getUrlPath() {
        return "documents/" + this.paths.get("documentId") + "/tags";
    }

    public AddDocumentTagRequest siteId(String siteId) {
        this.parameters.put("siteId", siteId);
        return this;
    }

    public String tagKey() {
        return this.tag.key();
    }

    public AddDocumentTagRequest tagKey(String s) {
        this.tag.key(s);
        return this;
    }

    public List<AddDocumentTag> tags() {
        return this.tags;
    }

    public AddDocumentTagRequest tags(List<AddDocumentTag> list) {
        this.tags = list;
        return this;
    }

    public String tagValue() {
        return this.tag.value();
    }

    public AddDocumentTagRequest tagValue(String s) {
        this.tag.value(s);
        return this;
    }

    public List<String> tagValues() {
        return this.tag.values();
    }

    public AddDocumentTagRequest tagValues(List<String> list) {
        this.tag.values(list);
        return this;
    }

    @Override
    public void validate() {
        Validate.notNull(this.paths.get("documentId"), "DocumentId is required.", new Object[0]);
        if (this.tags.isEmpty()) {
            Validate.notNull(this.tag.key(), "TagKey is required.", new Object[0]);
        } else {
            this.tags.forEach(t -> Validate.notNull(t.key(), "TagKey is required.", new Object[0]));
        }
    }

    public AddDocumentTagRequest webnotify(boolean webnotify) {
        this.parameters.put("webnotify", String.valueOf(webnotify));
        return this;
    }
}

