/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.stacks.client.requests;

import com.formkiq.stacks.client.ApiRequest;
import com.formkiq.stacks.client.Validate;
import com.formkiq.stacks.client.models.AddDocument;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AddDocumentRequest
implements ApiRequest {
    private AddDocument document;
    private boolean enablePublicEndpoint;
    private Map<String, String> parameters = new HashMap<String, String>();

    @Override
    public void addQueryParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public AddDocument document() {
        return this.document;
    }

    public AddDocumentRequest document(AddDocument addDocument) {
        this.document = addDocument;
        return this;
    }

    public boolean enablePublicEndpoint() {
        return this.enablePublicEndpoint;
    }

    public AddDocumentRequest enablePublicEndpoint(boolean enable) {
        this.enablePublicEndpoint = enable;
        return this;
    }

    @Override
    public Optional<Map<String, List<String>>> getHttpHeaders() {
        return Optional.empty();
    }

    @Override
    public Map<String, String> getQueryParameters() {
        return this.parameters;
    }

    @Override
    public String getUrlPath() {
        return this.enablePublicEndpoint ? "public/documents" : "documents";
    }

    public AddDocumentRequest siteId(String siteId) {
        this.parameters.put("siteId", siteId);
        return this;
    }

    @Override
    public void validate() {
        Validate.notNull(this.document, "Document is required.", new Object[0]);
    }

    public AddDocumentRequest webnotify(boolean webnotify) {
        this.parameters.put("webnotify", String.valueOf(webnotify));
        return this;
    }
}

