/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.stacks.client.requests;

import com.formkiq.stacks.client.ApiRequest;
import com.formkiq.stacks.client.Validate;
import com.formkiq.stacks.client.models.DeleteFulltextTag;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.utils.StringUtils;

public class DeleteFulltextTagsRequest
implements ApiRequest {
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> paths = new HashMap<String, String>();
    private DeleteFulltextTag tag;

    @Override
    public void addQueryParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public DeleteFulltextTagsRequest documentId(String documentId) {
        this.paths.put("documentId", documentId);
        return this;
    }

    @Override
    public Optional<Map<String, List<String>>> getHttpHeaders() {
        return Optional.empty();
    }

    @Override
    public Map<String, String> getQueryParameters() {
        return this.parameters;
    }

    @Override
    public String getUrlPath() throws IOException {
        return !StringUtils.isEmpty((CharSequence)this.tag.value()) ? String.format("documents/%s/fulltext/tags/%s/%s", this.paths.get("documentId"), this.encodeValue(this.tag.key()), this.encodeValue(this.tag.value())) : String.format("documents/%s/fulltext/tags/%s", this.paths.get("documentId"), this.encodeValue(this.tag.key()));
    }

    public DeleteFulltextTagsRequest siteId(String siteId) {
        this.parameters.put("siteId", siteId);
        return this;
    }

    public DeleteFulltextTagsRequest tag(DeleteFulltextTag deleteTag) {
        this.tag = deleteTag;
        return this;
    }

    @Override
    public void validate() {
        Validate.notNull(this.paths.get("documentId"), "DocumentId is required.", new Object[0]);
        Validate.notNull(this.tag, "DocumentTag is required.", new Object[0]);
    }
}

