/*
 * Decompiled with CFR 0.152.
 */
package com.formkiq.stacks.client.requests;

import com.formkiq.stacks.client.ApiRequest;
import com.formkiq.stacks.client.Validate;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UpdateDocumentTagKeyRequest
implements ApiRequest {
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> paths = new HashMap<String, String>();
    private String tagValue;
    private List<String> tagValues;

    @Override
    public void addQueryParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public UpdateDocumentTagKeyRequest documentId(String documentId) {
        this.paths.put("documentId", documentId);
        return this;
    }

    @Override
    public Optional<Map<String, List<String>>> getHttpHeaders() {
        return Optional.empty();
    }

    @Override
    public Map<String, String> getQueryParameters() {
        return this.parameters;
    }

    @Override
    public String getUrlPath() throws IOException {
        return "documents/" + this.paths.get("documentId") + "/tags/" + this.encodeValue(this.paths.get("tagKey"));
    }

    public UpdateDocumentTagKeyRequest siteId(String siteId) {
        this.parameters.put("siteId", siteId);
        return this;
    }

    public UpdateDocumentTagKeyRequest tagKey(String tagKey) {
        this.paths.put("tagKey", tagKey);
        return this;
    }

    public String tagValue() {
        return this.tagValue;
    }

    public UpdateDocumentTagKeyRequest tagValue(String value) {
        this.tagValue = value;
        return this;
    }

    public List<String> tagValues() {
        return this.tagValues;
    }

    public UpdateDocumentTagKeyRequest tagValues(List<String> list) {
        this.tagValues = list;
        return this;
    }

    @Override
    public void validate() {
        Validate.notNull(this.paths.get("documentId"), "DocumentId is required.", new Object[0]);
        Validate.notNull(this.paths.get("tagKey"), "TagKey is required.", new Object[0]);
        Validate.notNull(this.tagValue, this.tagValues, "either TagValue/TagValues is required.", new Object[0]);
    }

    public UpdateDocumentTagKeyRequest webnotify(boolean webnotify) {
        this.parameters.put("webnotify", String.valueOf(webnotify));
        return this;
    }
}

