/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.api;

import com.fortanix.sdkms.v1.ApiClient;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.Configuration;
import com.fortanix.sdkms.v1.Pair;
import com.fortanix.sdkms.v1.model.App;
import com.fortanix.sdkms.v1.model.Plugin;
import com.fortanix.sdkms.v1.model.PluginInvokeRequest;
import com.fortanix.sdkms.v1.model.PluginInvokeResponse;
import com.fortanix.sdkms.v1.model.PluginRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class PluginsApi {
    private ApiClient apiClient;

    public PluginsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PluginsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Plugin createPlugin(PluginRequest body) throws ApiException {
        PluginRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPlugin");
        }
        String localVarPath = "/sys/v1/plugins";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<Plugin> localVarReturnType = new GenericType<Plugin>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deletePlugin(String pluginId) throws ApiException {
        Object localVarPostBody = null;
        if (pluginId == null) {
            throw new ApiException(400, "Missing the required parameter 'pluginId' when calling deletePlugin");
        }
        String localVarPath = "/sys/v1/plugins/{plugin-id}".replaceAll("\\{plugin-id\\}", this.apiClient.escapeString(pluginId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Plugin getPlugin(String pluginId) throws ApiException {
        Object localVarPostBody = null;
        if (pluginId == null) {
            throw new ApiException(400, "Missing the required parameter 'pluginId' when calling getPlugin");
        }
        String localVarPath = "/sys/v1/plugins/{plugin-id}".replaceAll("\\{plugin-id\\}", this.apiClient.escapeString(pluginId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<Plugin> localVarReturnType = new GenericType<Plugin>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Plugin> getPlugins(String groupId, String sort, String start, Integer limit, Integer offset) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sys/v1/plugins";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_id", groupId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<List<Plugin>> localVarReturnType = new GenericType<List<Plugin>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PluginInvokeResponse invokePlugin(String pluginId, PluginInvokeRequest body) throws ApiException {
        PluginInvokeRequest localVarPostBody = body;
        if (pluginId == null) {
            throw new ApiException(400, "Missing the required parameter 'pluginId' when calling invokePlugin");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling invokePlugin");
        }
        String localVarPath = "/sys/v1/plugins/{plugin-id}".replaceAll("\\{plugin-id\\}", this.apiClient.escapeString(pluginId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<PluginInvokeResponse> localVarReturnType = new GenericType<PluginInvokeResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PluginInvokeResponse sysV1PluginsInvokePluginIdGet(String pluginId) throws ApiException {
        Object localVarPostBody = null;
        if (pluginId == null) {
            throw new ApiException(400, "Missing the required parameter 'pluginId' when calling sysV1PluginsInvokePluginIdGet");
        }
        String localVarPath = "/sys/v1/plugins/invoke/{plugin-id}".replaceAll("\\{plugin-id\\}", this.apiClient.escapeString(pluginId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<PluginInvokeResponse> localVarReturnType = new GenericType<PluginInvokeResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Plugin> getPlugins(String groupId) throws ApiException {
        return this.getPlugins(groupId, null, null, null, null);
    }

    public App updatePlugin(String pluginId, PluginRequest body) throws ApiException {
        PluginRequest localVarPostBody = body;
        if (pluginId == null) {
            throw new ApiException(400, "Missing the required parameter 'pluginId' when calling updatePlugin");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePlugin");
        }
        String localVarPath = "/sys/v1/plugins/{plugin-id}".replaceAll("\\{plugin-id\\}", this.apiClient.escapeString(pluginId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<App> localVarReturnType = new GenericType<App>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

