/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.AuthConfig;
import com.fortanix.sdkms.v1.model.KeyUndoPolicy;
import com.fortanix.sdkms.v1.model.LoggingConfigRequest;
import com.fortanix.sdkms.v1.model.NotificationPref;
import com.fortanix.sdkms.v1.model.SubscriptionChangeRequest;
import com.fortanix.sdkms.v1.model.SubscriptionType;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccountRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="organization")
    private String organization = null;
    @JsonProperty(value="country")
    private String country = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="notification_pref")
    private NotificationPref notificationPref = null;
    @JsonProperty(value="auth_config")
    private AuthConfig authConfig = null;
    @JsonProperty(value="add_logging_configs")
    private List<LoggingConfigRequest> addLoggingConfigs = null;
    @JsonProperty(value="mod_logging_configs")
    private Map<String, LoggingConfigRequest> modLoggingConfigs = null;
    @JsonProperty(value="del_logging_configs")
    private List<String> delLoggingConfigs = null;
    @JsonProperty(value="pending_subscription_change_request")
    private SubscriptionChangeRequest pendingSubscriptionChangeRequest = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="subscription")
    private SubscriptionType subscription = null;
    @JsonProperty(value="custom_metadata")
    private Map<String, String> customMetadata = null;
    @JsonProperty(value="key_undo_policy")
    private KeyUndoPolicy keyUndoPolicy = null;

    public AccountRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the account. Accounts must be unique within an SDKMS instance.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public AccountRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Account ID uniquely identifying this account.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public AccountRequest organization(String organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(value="Organization (e.g. company name) that owns this account")
    @JsonProperty(value="organization")
    public String getOrganization() {
        return this.organization;
    }

    @JsonProperty(value="organization")
    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public AccountRequest country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="Main country associated with this account")
    @JsonProperty(value="country")
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    public void setCountry(String country) {
        this.country = country;
    }

    public AccountRequest phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="Contact phone number associated with this account")
    @JsonProperty(value="phone")
    public String getPhone() {
        return this.phone;
    }

    @JsonProperty(value="phone")
    public void setPhone(String phone) {
        this.phone = phone;
    }

    public AccountRequest notificationPref(NotificationPref notificationPref) {
        this.notificationPref = notificationPref;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="notification_pref")
    public NotificationPref getNotificationPref() {
        return this.notificationPref;
    }

    @JsonProperty(value="notification_pref")
    public void setNotificationPref(NotificationPref notificationPref) {
        this.notificationPref = notificationPref;
    }

    public AccountRequest authConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="auth_config")
    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    @JsonProperty(value="auth_config")
    public void setAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    public AccountRequest addLoggingConfigs(List<LoggingConfigRequest> addLoggingConfigs) {
        this.addLoggingConfigs = addLoggingConfigs;
        return this;
    }

    public AccountRequest addAddLoggingConfigsItem(LoggingConfigRequest addLoggingConfigsItem) {
        if (this.addLoggingConfigs == null) {
            this.addLoggingConfigs = new ArrayList<LoggingConfigRequest>();
        }
        this.addLoggingConfigs.add(addLoggingConfigsItem);
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="add_logging_configs")
    public List<LoggingConfigRequest> getAddLoggingConfigs() {
        return this.addLoggingConfigs;
    }

    @JsonProperty(value="add_logging_configs")
    public void setAddLoggingConfigs(List<LoggingConfigRequest> addLoggingConfigs) {
        this.addLoggingConfigs = addLoggingConfigs;
    }

    public AccountRequest modLoggingConfigs(Map<String, LoggingConfigRequest> modLoggingConfigs) {
        this.modLoggingConfigs = modLoggingConfigs;
        return this;
    }

    public AccountRequest putModLoggingConfigsItem(String key, LoggingConfigRequest modLoggingConfigsItem) {
        if (this.modLoggingConfigs == null) {
            this.modLoggingConfigs = new HashMap<String, LoggingConfigRequest>();
        }
        this.modLoggingConfigs.put(key, modLoggingConfigsItem);
        return this;
    }

    @ApiModelProperty(value="Map from UUIDs to LoggingConfigRequest objects")
    @JsonProperty(value="mod_logging_configs")
    public Map<String, LoggingConfigRequest> getModLoggingConfigs() {
        return this.modLoggingConfigs;
    }

    @JsonProperty(value="mod_logging_configs")
    public void setModLoggingConfigs(Map<String, LoggingConfigRequest> modLoggingConfigs) {
        this.modLoggingConfigs = modLoggingConfigs;
    }

    public AccountRequest delLoggingConfigs(List<String> delLoggingConfigs) {
        this.delLoggingConfigs = delLoggingConfigs;
        return this;
    }

    public AccountRequest addDelLoggingConfigsItem(String delLoggingConfigsItem) {
        if (this.delLoggingConfigs == null) {
            this.delLoggingConfigs = new ArrayList<String>();
        }
        this.delLoggingConfigs.add(delLoggingConfigsItem);
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="del_logging_configs")
    public List<String> getDelLoggingConfigs() {
        return this.delLoggingConfigs;
    }

    @JsonProperty(value="del_logging_configs")
    public void setDelLoggingConfigs(List<String> delLoggingConfigs) {
        this.delLoggingConfigs = delLoggingConfigs;
    }

    public AccountRequest pendingSubscriptionChangeRequest(SubscriptionChangeRequest pendingSubscriptionChangeRequest) {
        this.pendingSubscriptionChangeRequest = pendingSubscriptionChangeRequest;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="pending_subscription_change_request")
    public SubscriptionChangeRequest getPendingSubscriptionChangeRequest() {
        return this.pendingSubscriptionChangeRequest;
    }

    @JsonProperty(value="pending_subscription_change_request")
    public void setPendingSubscriptionChangeRequest(SubscriptionChangeRequest pendingSubscriptionChangeRequest) {
        this.pendingSubscriptionChangeRequest = pendingSubscriptionChangeRequest;
    }

    public AccountRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Whether this account is enabled. This may only be changed by sysadmins.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AccountRequest subscription(SubscriptionType subscription) {
        this.subscription = subscription;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="subscription")
    public SubscriptionType getSubscription() {
        return this.subscription;
    }

    @JsonProperty(value="subscription")
    public void setSubscription(SubscriptionType subscription) {
        this.subscription = subscription;
    }

    public AccountRequest customMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
        return this;
    }

    public AccountRequest putCustomMetadataItem(String key, String customMetadataItem) {
        if (this.customMetadata == null) {
            this.customMetadata = new HashMap<String, String>();
        }
        this.customMetadata.put(key, customMetadataItem);
        return this;
    }

    @ApiModelProperty(value="Sysadmin-defined metadata for this account. Stored as key-value pairs. This field may only be used by sysadmin users. ")
    @JsonProperty(value="custom_metadata")
    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="custom_metadata")
    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    public AccountRequest keyUndoPolicy(KeyUndoPolicy keyUndoPolicy) {
        this.keyUndoPolicy = keyUndoPolicy;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="key_undo_policy")
    public KeyUndoPolicy getKeyUndoPolicy() {
        return this.keyUndoPolicy;
    }

    @JsonProperty(value="key_undo_policy")
    public void setKeyUndoPolicy(KeyUndoPolicy keyUndoPolicy) {
        this.keyUndoPolicy = keyUndoPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountRequest accountRequest = (AccountRequest)o;
        return Objects.equals(this.name, accountRequest.name) && Objects.equals(this.description, accountRequest.description) && Objects.equals(this.organization, accountRequest.organization) && Objects.equals(this.country, accountRequest.country) && Objects.equals(this.phone, accountRequest.phone) && Objects.equals(this.notificationPref, accountRequest.notificationPref) && Objects.equals(this.authConfig, accountRequest.authConfig) && Objects.equals(this.addLoggingConfigs, accountRequest.addLoggingConfigs) && Objects.equals(this.modLoggingConfigs, accountRequest.modLoggingConfigs) && Objects.equals(this.delLoggingConfigs, accountRequest.delLoggingConfigs) && Objects.equals(this.pendingSubscriptionChangeRequest, accountRequest.pendingSubscriptionChangeRequest) && Objects.equals(this.enabled, accountRequest.enabled) && Objects.equals(this.subscription, accountRequest.subscription) && Objects.equals(this.customMetadata, accountRequest.customMetadata) && Objects.equals(this.keyUndoPolicy, accountRequest.keyUndoPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.organization, this.country, this.phone, this.notificationPref, this.authConfig, this.addLoggingConfigs, this.modLoggingConfigs, this.delLoggingConfigs, this.pendingSubscriptionChangeRequest, this.enabled, this.subscription, this.customMetadata, this.keyUndoPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    notificationPref: ").append(this.toIndentedString(this.notificationPref)).append("\n");
        sb.append("    authConfig: ").append(this.toIndentedString(this.authConfig)).append("\n");
        sb.append("    addLoggingConfigs: ").append(this.toIndentedString(this.addLoggingConfigs)).append("\n");
        sb.append("    modLoggingConfigs: ").append(this.toIndentedString(this.modLoggingConfigs)).append("\n");
        sb.append("    delLoggingConfigs: ").append(this.toIndentedString(this.delLoggingConfigs)).append("\n");
        sb.append("    pendingSubscriptionChangeRequest: ").append(this.toIndentedString(this.pendingSubscriptionChangeRequest)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    subscription: ").append(this.toIndentedString(this.subscription)).append("\n");
        sb.append("    customMetadata: ").append(this.toIndentedString(this.customMetadata)).append("\n");
        sb.append("    keyUndoPolicy: ").append(this.toIndentedString(this.keyUndoPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

