/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class DigestAlgorithm {
    private String value;
    public static final DigestAlgorithm BLAKE2B256 = new DigestAlgorithm("Blake2b256");
    public static final DigestAlgorithm BLAKE2B384 = new DigestAlgorithm("Blake2b384");
    public static final DigestAlgorithm BLAKE2B512 = new DigestAlgorithm("Blake2b512");
    public static final DigestAlgorithm BLAKE2S256 = new DigestAlgorithm("Blake2s256");
    public static final DigestAlgorithm RIPEMD160 = new DigestAlgorithm("RIPEMD160");
    public static final DigestAlgorithm SHA1 = new DigestAlgorithm("SHA1");
    public static final DigestAlgorithm SHA256 = new DigestAlgorithm("SHA256");
    public static final DigestAlgorithm SHA384 = new DigestAlgorithm("SHA384");
    public static final DigestAlgorithm SHA512 = new DigestAlgorithm("SHA512");
    public static final DigestAlgorithm SHA3_224 = new DigestAlgorithm("SHA3_224");
    public static final DigestAlgorithm SHA3_256 = new DigestAlgorithm("SHA3_256");
    public static final DigestAlgorithm SHA3_384 = new DigestAlgorithm("SHA3_384");
    public static final DigestAlgorithm SHA3_512 = new DigestAlgorithm("SHA3_512");
    public static final DigestAlgorithm SSL3 = new DigestAlgorithm("Ssl3");
    public static final DigestAlgorithm STREEBOG256 = new DigestAlgorithm("Streebog256");
    public static final DigestAlgorithm STREEBOG512 = new DigestAlgorithm("Streebog512");
    private static final Map<String, DigestAlgorithm> valueMap = new HashMap<String, DigestAlgorithm>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private DigestAlgorithm(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DigestAlgorithm[] values() {
        valueMapLock.lock();
        try {
            DigestAlgorithm[] digestAlgorithmArray = valueMap.values().toArray(new DigestAlgorithm[valueMap.values().size()]);
            return digestAlgorithmArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static DigestAlgorithm fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                DigestAlgorithm digestAlgorithm = valueMap.get(val);
                return digestAlgorithm;
            }
            DigestAlgorithm newValue = new DigestAlgorithm(val);
            valueMap.put(val, newValue);
            DigestAlgorithm digestAlgorithm = newValue;
            return digestAlgorithm;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("Blake2b256", BLAKE2B256);
        valueMap.put("Blake2b384", BLAKE2B384);
        valueMap.put("Blake2b512", BLAKE2B512);
        valueMap.put("Blake2s256", BLAKE2S256);
        valueMap.put("RIPEMD160", RIPEMD160);
        valueMap.put("SHA1", SHA1);
        valueMap.put("SHA256", SHA256);
        valueMap.put("SHA384", SHA384);
        valueMap.put("SHA512", SHA512);
        valueMap.put("SHA3_224", SHA3_224);
        valueMap.put("SHA3_256", SHA3_256);
        valueMap.put("SHA3_384", SHA3_384);
        valueMap.put("SHA3_512", SHA3_512);
        valueMap.put("Ssl3", SSL3);
        valueMap.put("Streebog256", STREEBOG256);
        valueMap.put("Streebog512", STREEBOG512);
    }
}

