/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CipherMode;
import com.fortanix.sdkms.v1.model.ObjectType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="alg is required. mode is required for symmetric algorithms.")
public class EncryptInitRequest {
    @JsonProperty(value="alg")
    private ObjectType alg = null;
    @JsonProperty(value="mode")
    private CipherMode mode = null;
    @JsonProperty(value="iv")
    private byte[] iv = null;
    @JsonProperty(value="ad")
    private byte[] ad = null;

    public EncryptInitRequest alg(ObjectType alg) {
        this.alg = alg;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="alg")
    public ObjectType getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    public void setAlg(ObjectType alg) {
        this.alg = alg;
    }

    public EncryptInitRequest mode(CipherMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mode")
    public CipherMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(CipherMode mode) {
        this.mode = mode;
    }

    public EncryptInitRequest iv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    @ApiModelProperty(value="For symmetric ciphers, this value will be used for the cipher initialization value. If not provided, SDKMS will generate a random iv and return it in the response. If provided, iv length must match the length required by the cipher and mode. ")
    @JsonProperty(value="iv")
    public byte[] getIv() {
        return this.iv;
    }

    @JsonProperty(value="iv")
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public EncryptInitRequest ad(byte[] ad) {
        this.ad = ad;
        return this;
    }

    @ApiModelProperty(value="For symmetric ciphers with cipher mode GCM or CCM, this optionally specifies the authenticated data used by the cipher. This field must not be provided with other cipher modes. ")
    @JsonProperty(value="ad")
    public byte[] getAd() {
        return this.ad;
    }

    @JsonProperty(value="ad")
    public void setAd(byte[] ad) {
        this.ad = ad;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptInitRequest encryptInitRequest = (EncryptInitRequest)o;
        return Objects.equals(this.alg, encryptInitRequest.alg) && Objects.equals(this.mode, encryptInitRequest.mode) && Objects.equals(this.iv, encryptInitRequest.iv) && Objects.equals(this.ad, encryptInitRequest.ad);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.mode, this.iv, this.ad);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EncryptInitRequest {\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    iv: ").append(this.toIndentedString(this.iv)).append("\n");
        sb.append("    ad: ").append(this.toIndentedString(this.ad)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

