/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class EncryptResponse {
    @JsonProperty(value="kid")
    private String kid = null;
    @JsonProperty(value="cipher")
    private byte[] cipher = null;
    @JsonProperty(value="iv")
    private byte[] iv = null;
    @JsonProperty(value="tag")
    private byte[] tag = null;

    public EncryptResponse kid(String kid) {
        this.kid = kid;
        return this;
    }

    @ApiModelProperty(value="ID of the key used to perform encryption.")
    @JsonProperty(value="kid")
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    public void setKid(String kid) {
        this.kid = kid;
    }

    public EncryptResponse cipher(byte[] cipher) {
        this.cipher = cipher;
        return this;
    }

    @ApiModelProperty(required=true, value="The encrypted data.")
    @JsonProperty(value="cipher")
    public byte[] getCipher() {
        return this.cipher;
    }

    @JsonProperty(value="cipher")
    public void setCipher(byte[] cipher) {
        this.cipher = cipher;
    }

    public EncryptResponse iv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    @ApiModelProperty(value="The initialiation value used for symmetric encryption. Not returned for asymmetric ciphers.")
    @JsonProperty(value="iv")
    public byte[] getIv() {
        return this.iv;
    }

    @JsonProperty(value="iv")
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public EncryptResponse tag(byte[] tag) {
        this.tag = tag;
        return this;
    }

    @ApiModelProperty(value="For symmetric ciphers with cipher mode GCM or CCM, the authentication tag produced by the cipher. Its length will match the tag length specified by the encryption request. ")
    @JsonProperty(value="tag")
    public byte[] getTag() {
        return this.tag;
    }

    @JsonProperty(value="tag")
    public void setTag(byte[] tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptResponse encryptResponse = (EncryptResponse)o;
        return Objects.equals(this.kid, encryptResponse.kid) && Objects.equals(this.cipher, encryptResponse.cipher) && Objects.equals(this.iv, encryptResponse.iv) && Objects.equals(this.tag, encryptResponse.tag);
    }

    public int hashCode() {
        return Objects.hash(this.kid, this.cipher, this.iv, this.tag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EncryptResponse {\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    cipher: ").append(this.toIndentedString(this.cipher)).append("\n");
        sb.append("    iv: ").append(this.toIndentedString(this.iv)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

