/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A structure for specifying a particular date, used as an upper or lower bound for date parts. Note that depending on the `FpeDate` variant used, the `day` or `year` fields may be ignored. (For example, a Day-Month date would not require a `year` field, so specifying a year in a Day-Month date's upper bound is meaningless.) ")
public class FpeDateBound {
    @JsonProperty(value="year")
    private Integer year = null;
    @JsonProperty(value="month")
    private Integer month = null;
    @JsonProperty(value="day")
    private Integer day = null;

    public FpeDateBound year(Integer year) {
        this.year = year;
        return this;
    }

    @ApiModelProperty(value="The year, which should be a number less than 100000. Zero is treated as a leap year.")
    @JsonProperty(value="year")
    public Integer getYear() {
        return this.year;
    }

    @JsonProperty(value="year")
    public void setYear(Integer year) {
        this.year = year;
    }

    public FpeDateBound month(Integer month) {
        this.month = month;
        return this;
    }

    @ApiModelProperty(required=true, value="The month, which should be a number from 1 to 12.")
    @JsonProperty(value="month")
    public Integer getMonth() {
        return this.month;
    }

    @JsonProperty(value="month")
    public void setMonth(Integer month) {
        this.month = month;
    }

    public FpeDateBound day(Integer day) {
        this.day = day;
        return this;
    }

    @ApiModelProperty(value="The day, which should be a number from 1 to 31, and must not be out-of-range for the given month. February is considered to be 29 days long, unless the year, if specified, is not a leap year. ")
    @JsonProperty(value="day")
    public Integer getDay() {
        return this.day;
    }

    @JsonProperty(value="day")
    public void setDay(Integer day) {
        this.day = day;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FpeDateBound fpeDateBound = (FpeDateBound)o;
        return Objects.equals(this.year, fpeDateBound.year) && Objects.equals(this.month, fpeDateBound.month) && Objects.equals(this.day, fpeDateBound.day);
    }

    public int hashCode() {
        return Objects.hash(this.year, this.month, this.day);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FpeDateBound {\n");
        sb.append("    year: ").append(this.toIndentedString(this.year)).append("\n");
        sb.append("    month: ").append(this.toIndentedString(this.month)).append("\n");
        sb.append("    day: ").append(this.toIndentedString(this.day)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

